/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrCrossFileFieldUsageChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFieldAccessChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrCrossFileFieldUsageChecker
implements IrExpressionChecker<IrFieldAccessExpression> {
    @NotNull
    public static final IrCrossFileFieldUsageChecker INSTANCE = new IrCrossFileFieldUsageChecker();

    private IrCrossFileFieldUsageChecker() {
    }

    @Override
    public void check(@NotNull IrFieldAccessExpression expression2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        if (Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB())) {
            return;
        }
        IrFile irFile = IrUtilsKt.getFileOrNull(field);
        if (irFile == null) {
            return;
        }
        IrFile containingFile = irFile;
        if (!Intrinsics.areEqual(containingFile, context2.getFile())) {
            context2.error(expression2, "Access to a field declared in another file: " + IrDeclarationsKt.getPath(containingFile));
        }
    }
}

