/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CramFsInode
implements StructConverter {
    private int mode;
    private int uid;
    private int size;
    private int gid;
    private int namelen;
    private int offset;
    private String name;
    private long address;

    public CramFsInode(BinaryReader reader) throws IOException {
        this.address = reader.getPointerIndex();
        int modeUID = reader.readNextInt();
        int sizeGID = reader.readNextInt();
        int namelenOffset = reader.readNextInt();
        if (reader.isBigEndian()) {
            modeUID = Integer.reverseBytes(modeUID);
            sizeGID = Integer.reverseBytes(sizeGID);
            namelenOffset = Integer.reverseBytes(namelenOffset);
        }
        this.uid = (modeUID & 0xFFFF0000) >> 16 & 0xFFFF;
        this.mode = modeUID & 0xFFFF;
        this.gid = (sizeGID & 0xFF000000) >> 24 & 0xFF;
        this.size = sizeGID & 0xFFFFFF;
        this.offset = (namelenOffset & 0xFFFFFFC0) >> 6 & 0xCFFFFFF;
        this.namelen = namelenOffset & 0x3F;
        this.name = reader.readNextAsciiString(this.namelen * 4);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        int length = this.namelen * 4;
        StructureDataType struct = new StructureDataType("cramfs_inode_" + length, 0);
        struct.add(DWORD, "modeUID", null);
        struct.add(DWORD, "sizeGID", null);
        struct.add(DWORD, "namelenOffset", null);
        if (this.namelen > 0) {
            struct.add(STRING, length, "name", null);
        }
        return struct;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("mode = 0x" + Integer.toHexString(this.mode) + " 16 MSB, UID = 0x" + Integer.toHexString(this.uid) + " 16 LSB\n");
        buffer.append("size = 0x" + Integer.toHexString(this.size) + " 24 MSB,  GID = 0x" + Integer.toHexString(this.gid) + " 8 LSB\n");
        buffer.append("namelen = 0x" + Integer.toHexString(this.namelen) + " 6 MSB, offset = 0x" + Integer.toHexString(this.offset) + " 26 LSB\n");
        if (this.isFile()) {
            buffer.append("Pointer to data = 0x" + Integer.toHexString(this.getOffsetAdjusted()) + "\n");
        }
        if (this.isDirectory()) {
            if (this.offset == 0) {
                buffer.append("EMPTY DIRECTORY\n");
            } else {
                buffer.append("Pointer to next inode = 0x" + Integer.toHexString(this.getOffsetAdjusted()) + "\n");
            }
        }
        return buffer.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public int getUid() {
        return this.uid;
    }

    public int getSize() {
        return this.size;
    }

    public int getGid() {
        return this.gid;
    }

    public int getNamelen() {
        return this.namelen;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public int getOffsetAdjusted() {
        return this.offset * 4;
    }

    public boolean isFile() {
        return (this.mode & 0x8000) != 0;
    }

    public boolean isDirectory() {
        return (this.mode & 0x4000) != 0;
    }

    public long getAddress() {
        return this.address;
    }
}

