/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import generic.ULongSpan;
import ghidra.util.MathUtilities;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SemisparseByteArray {
    public static final int BLOCK_SIZE = 4096;
    private final Map<Long, byte[]> blocks;
    private final ULongSpan.MutableULongSpanSet defined;

    public SemisparseByteArray() {
        this.blocks = new HashMap<Long, byte[]>();
        this.defined = new ULongSpan.DefaultULongSpanSet();
    }

    protected SemisparseByteArray(Map<Long, byte[]> blocks, ULongSpan.MutableULongSpanSet defined) {
        this.blocks = blocks;
        this.defined = defined;
    }

    static byte[] copyArr(Map.Entry<?, byte[]> ent) {
        byte[] b = ent.getValue();
        return Arrays.copyOf(b, b.length);
    }

    public synchronized SemisparseByteArray fork() {
        Map<Long, byte[]> copyBlocks = this.blocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, SemisparseByteArray::copyArr));
        ULongSpan.DefaultULongSpanSet copyDefined = new ULongSpan.DefaultULongSpanSet();
        copyDefined.addAll(this.defined);
        return new SemisparseByteArray(copyBlocks, copyDefined);
    }

    public synchronized void clear() {
        this.defined.clear();
        this.blocks.clear();
    }

    public synchronized void getData(long loc, byte[] data) {
        this.getData(loc, data, 0, data.length);
    }

    public synchronized byte[] getDirect(long loc) {
        long blockNum = Long.divideUnsigned(loc, 4096L);
        int blockOffset = (int)Long.remainderUnsigned(loc, 4096L);
        if (blockOffset != 0) {
            throw new IllegalArgumentException("Offset must be at block boundary");
        }
        return this.blocks.computeIfAbsent(blockNum, n -> new byte[4096]);
    }

    public synchronized void getData(long loc, byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        long blockNum = Long.divideUnsigned(loc, 4096L);
        int blockOffset = (int)Long.remainderUnsigned(loc, 4096L);
        byte[] block = this.blocks.get(blockNum);
        int amt = Math.min(length, 4096 - blockOffset);
        if (block != null) {
            System.arraycopy(block, blockOffset, data, offset, amt);
        }
        for (int cur = amt; cur < length; cur += amt) {
            if (++blockNum == 0L) {
                throw new BufferUnderflowException();
            }
            block = this.blocks.get(blockNum);
            amt = Math.min(length - cur, 4096);
            if (block == null) continue;
            System.arraycopy(block, 0, data, cur + offset, amt);
        }
    }

    public synchronized ULongSpan.ULongSpanSet getInitialized(long a, long b) {
        ULongSpan.DefaultULongSpanSet result = new ULongSpan.DefaultULongSpanSet();
        ULongSpan query = ULongSpan.span(a, b);
        for (ULongSpan span : this.defined.intersecting(query)) {
            result.add(query.intersect(span));
        }
        return result;
    }

    public synchronized boolean isInitialized(long a, long b) {
        return this.defined.encloses(ULongSpan.span(a, b));
    }

    public synchronized boolean isInitialized(long a) {
        return this.defined.contains(a);
    }

    public synchronized ULongSpan.ULongSpanSet getUninitialized(long a, long b) {
        ULongSpan.DefaultULongSpanSet result = new ULongSpan.DefaultULongSpanSet();
        for (ULongSpan s : this.defined.complement(ULongSpan.span(a, b))) {
            result.add(s);
        }
        return result;
    }

    public synchronized void putData(long loc, byte[] data) {
        this.putData(loc, data, 0, data.length);
    }

    public synchronized void putData(long loc, byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (length == 0) {
            return;
        }
        this.defined.add(ULongSpan.extent(loc, length));
        long blockNum = Long.divideUnsigned(loc, 4096L);
        int blockOffset = (int)Long.remainderUnsigned(loc, 4096L);
        byte[] block = this.blocks.computeIfAbsent(blockNum, n -> new byte[4096]);
        int amt = Math.min(length, 4096 - blockOffset);
        System.arraycopy(data, offset, block, blockOffset, amt);
        for (int cur = amt; cur < length; cur += amt) {
            if (++blockNum == 0L) {
                throw new BufferOverflowException();
            }
            block = this.blocks.computeIfAbsent(blockNum, n -> new byte[4096]);
            amt = Math.min(length - cur, 4096);
            System.arraycopy(data, cur + offset, block, 0, amt);
        }
    }

    public synchronized void putAll(SemisparseByteArray from) {
        byte[] temp = new byte[4096];
        for (ULongSpan span : from.defined.spans()) {
            long lower = (Long)span.min();
            long length = span.length();
            long i = 0L;
            while (Long.compareUnsigned(i, length) < 0) {
                int l = MathUtilities.unsignedMin((int)temp.length, (long)(length - i));
                from.getData(lower + i, temp, 0, l);
                this.putData(lower + i, temp, 0, l);
                i += (long)l;
            }
        }
    }

    public synchronized int contiguousAvailableAfter(long loc) {
        ULongSpan span = (ULongSpan)this.defined.spanContaining(loc);
        if (span == null) {
            return 0;
        }
        long diff = (Long)span.max() - loc + 1L;
        return MathUtilities.unsignedMin((int)Integer.MAX_VALUE, (long)diff);
    }
}

