/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcState
implements Serializable {
    private static final long serialVersionUID = 7805L;
    char state = '\u0000';
    String name = null;
    long ppid = 0L;
    int tty = 0;
    int nice = 0;
    int priority = 0;
    long threads = 0L;
    int processor = 0;
    public static final char SLEEP = 'S';
    public static final char RUN = 'R';
    public static final char STOP = 'T';
    public static final char ZOMBIE = 'Z';
    public static final char IDLE = 'D';

    public native void gather(Sigar var1, long var2) throws SigarException;

    static ProcState fetch(Sigar sigar, long pid) throws SigarException {
        ProcState procState = new ProcState();
        procState.gather(sigar, pid);
        return procState;
    }

    public char getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public long getPpid() {
        return this.ppid;
    }

    public int getTty() {
        return this.tty;
    }

    public int getNice() {
        return this.nice;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getThreads() {
        return this.threads;
    }

    public int getProcessor() {
        return this.processor;
    }

    void copyTo(ProcState copy) {
        copy.state = this.state;
        copy.name = this.name;
        copy.ppid = this.ppid;
        copy.tty = this.tty;
        copy.nice = this.nice;
        copy.priority = this.priority;
        copy.threads = this.threads;
        copy.processor = this.processor;
    }

    public Map toMap() {
        String strprocessor;
        String strthreads;
        String strpriority;
        String strnice;
        String strtty;
        String strppid;
        String strname;
        HashMap<String, String> map = new HashMap<String, String>();
        String strstate = String.valueOf(this.state);
        if (!"-1".equals(strstate)) {
            map.put("State", strstate);
        }
        if (!"-1".equals(strname = String.valueOf(this.name))) {
            map.put("Name", strname);
        }
        if (!"-1".equals(strppid = String.valueOf(this.ppid))) {
            map.put("Ppid", strppid);
        }
        if (!"-1".equals(strtty = String.valueOf(this.tty))) {
            map.put("Tty", strtty);
        }
        if (!"-1".equals(strnice = String.valueOf(this.nice))) {
            map.put("Nice", strnice);
        }
        if (!"-1".equals(strpriority = String.valueOf(this.priority))) {
            map.put("Priority", strpriority);
        }
        if (!"-1".equals(strthreads = String.valueOf(this.threads))) {
            map.put("Threads", strthreads);
        }
        if (!"-1".equals(strprocessor = String.valueOf(this.processor))) {
            map.put("Processor", strprocessor);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

