/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemory;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewMemoryRegionBlock;
import ghidra.trace.database.program.DBTraceProgramViewMemorySpaceBlock;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.LockHold;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;

public class DBTraceProgramViewMemory
extends AbstractDBTraceProgramViewMemory {
    private final Map<TraceMemoryRegion, DBTraceProgramViewMemoryRegionBlock> regionBlocks = new WeakValueHashMap();
    private final Map<AddressSpace, DBTraceProgramViewMemorySpaceBlock> spaceBlocks = new WeakValueHashMap();
    private NavigableMap<Address, RegionEntry> regionsByAddress;
    private Map<String, RegionEntry> regionsByName;
    private volatile boolean regionsValid;

    public DBTraceProgramViewMemory(DBTraceProgramView program) {
        super(program);
    }

    protected void forPhysicalSpaces(Consumer<AddressSpace> consumer) {
        for (AddressSpace space : this.program.getAddressFactory().getAddressSpaces()) {
            if (!space.isMemorySpace() || space.getType() == 7) continue;
            consumer.accept(space);
        }
    }

    protected NavigableMap<Address, RegionEntry> computeRegionsByAddress() {
        return new RegionsByAddressComputer().compute();
    }

    protected Map<String, RegionEntry> computeRegionsByName(Collection<RegionEntry> regions) {
        HashMap<String, RegionEntry> result = new HashMap<String, RegionEntry>();
        for (RegionEntry entry : regions) {
            result.put(entry.region.getName(entry.snap), entry);
        }
        return result;
    }

    protected NavigableMap<Address, RegionEntry> getRegionsByAddress() {
        if (!this.regionsValid) {
            NavigableMap<Address, RegionEntry> byAddr = this.computeRegionsByAddress();
            this.regionsByAddress = byAddr;
            this.regionsByName = this.computeRegionsByName(byAddr.values());
            this.regionsValid = true;
        }
        return this.regionsByAddress;
    }

    protected Map<String, RegionEntry> getRegionsByName() {
        if (!this.regionsValid) {
            NavigableMap<Address, RegionEntry> byAddr = this.computeRegionsByAddress();
            this.regionsByAddress = byAddr;
            this.regionsByName = this.computeRegionsByName(byAddr.values());
            this.regionsValid = true;
        }
        return this.regionsByName;
    }

    protected void forVisibleRegions(Consumer<RegionEntry> action) {
        for (RegionEntry entry : this.getRegionsByAddress().values()) {
            action.accept(entry);
        }
    }

    @Override
    void setSnap(long snap) {
        super.setSnap(snap);
        this.updateBytesChanged(null);
        this.invalidateRegions();
    }

    protected AddressSet computeRegionsAddressSet() {
        AddressSet result = new AddressSet();
        try (LockHold hold = this.program.trace.lockRead();){
            this.forVisibleRegions(e -> result.add(e.range));
        }
        return result;
    }

    protected AddressSet computeSpacesAddressSet() {
        AddressSet result = new AddressSet();
        try (LockHold hold = this.program.trace.lockRead();){
            this.forPhysicalSpaces(space -> result.add(space.getMinAddress(), space.getMaxAddress()));
        }
        return result;
    }

    @Override
    protected AddressSetView computeAddressSet() {
        return this.isForceFullView() ? this.computeSpacesAddressSet() : this.computeRegionsAddressSet();
    }

    protected MemoryBlock getRegionBlock(RegionEntry entry) {
        return this.regionBlocks.computeIfAbsent(entry.region, r -> new DBTraceProgramViewMemoryRegionBlock(this.program, entry.region, entry.snap));
    }

    protected MemoryBlock getSpaceBlock(AddressSpace space) {
        return this.spaceBlocks.computeIfAbsent(space, s -> new DBTraceProgramViewMemorySpaceBlock(this.program, space));
    }

    public MemoryBlock getBlock(Address addr) {
        if (this.isForceFullView()) {
            return this.getSpaceBlock(addr.getAddressSpace());
        }
        Map.Entry<Address, RegionEntry> entry = this.getRegionsByAddress().floorEntry(addr);
        if (entry == null || !entry.getValue().range.contains(addr)) {
            return null;
        }
        return this.getRegionBlock(entry.getValue());
    }

    public MemoryBlock getBlock(String blockName) {
        if (this.isForceFullView()) {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace(blockName);
            return space == null ? null : this.getSpaceBlock(space);
        }
        RegionEntry entry = this.getRegionsByName().get(blockName);
        if (entry == null) {
            return null;
        }
        return this.getRegionBlock(entry);
    }

    public MemoryBlock[] getBlocks() {
        ArrayList result = new ArrayList();
        if (this.isForceFullView()) {
            this.forPhysicalSpaces(space -> result.add(this.getSpaceBlock((AddressSpace)space)));
        } else {
            this.forVisibleRegions(reg -> result.add(this.getRegionBlock((RegionEntry)reg)));
        }
        Collections.sort(result, Comparator.comparing(b -> b.getStart()));
        return result.toArray(new MemoryBlock[result.size()]);
    }

    public AddressSetView getExecuteSet() {
        AddressSet result = new AddressSet();
        this.forVisibleRegions(e -> {
            if (e.region.isExecute(e.snap)) {
                result.add(e.range);
            }
        });
        return result;
    }

    protected void invalidateRegions() {
        this.regionsValid = false;
        if (this.regionBlocks != null) {
            this.regionBlocks.clear();
        }
        if (!this.isForceFullView()) {
            this.invalidateAddressSet();
        }
    }

    public void updateAddSpaceBlock(AddressSpace space) {
    }

    public void updateDeleteSpaceBlock(AddressSpace space) {
        this.spaceBlocks.remove(space);
    }

    public void updateRefreshBlocks() {
        this.invalidateRegions();
        this.spaceBlocks.clear();
    }

    public void updateBytesChanged(AddressRange range) {
        if (this.regionBlocks == null) {
            return;
        }
        this.cache.invalidate(range);
    }

    class RegionsByAddressComputer {
        TreeMap<Address, RegionEntry> map = new TreeMap();
        Map<TraceMemoryRegion, Address> addressByRegion = new HashMap<TraceMemoryRegion, Address>();

        RegionsByAddressComputer() {
        }

        protected void putDeletingOverlaps(RegionEntry newEntry) {
            Address newKey = newEntry.range.getMinAddress();
            RegionEntry curEntry = this.map.get(newKey);
            if (newEntry.isSameAtDifferentSnap(curEntry)) {
                curEntry.snap = newEntry.snap;
                return;
            }
            Map.Entry<Address, RegionEntry> floorEntry = this.map.floorEntry(newKey);
            Address min = floorEntry != null && floorEntry.getValue().range.contains(newKey) ? floorEntry.getKey() : newKey;
            this.map.subMap(min, true, newEntry.range.getMaxAddress(), true).clear();
            Address oldKey = this.addressByRegion.remove(newEntry.region);
            if (oldKey != null) {
                this.map.remove(oldKey);
            }
            this.map.put(newKey, newEntry);
            this.addressByRegion.put(newEntry.region, newKey);
        }

        public NavigableMap<Address, RegionEntry> compute() {
            for (long snap : DBTraceProgramViewMemory.this.program.viewport.getReversedSnaps()) {
                for (AddressSpace space : DBTraceProgramViewMemory.this.getTrace().getBaseAddressFactory().getPhysicalSpaces()) {
                    AddressRangeImpl range = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
                    for (TraceMemoryRegion traceMemoryRegion : DBTraceProgramViewMemory.this.memoryManager.getRegionsIntersecting(Lifespan.at(snap), (AddressRange)range)) {
                        RegionEntry entry = new RegionEntry(traceMemoryRegion, snap);
                        this.putDeletingOverlaps(entry);
                    }
                }
            }
            return this.map;
        }
    }

    static class RegionEntry {
        final TraceMemoryRegion region;
        final AddressRange range;
        long snap;

        public RegionEntry(TraceMemoryRegion region, long snap) {
            this.region = region;
            this.range = region.getRange(snap);
            this.snap = snap;
        }

        public boolean isSameAtDifferentSnap(RegionEntry that) {
            if (that == null) {
                return false;
            }
            return this.region == that.region && this.range.equals((Object)that.range);
        }
    }
}

