/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import ghidra.bitpatterns.gui.ContextRegisterFilterInputDialog;
import ghidra.bitpatterns.info.ContextRegisterExtent;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class ContextRegisterFilterablePanelBuilder {
    private static final String APPLY_BUTTON_TEXT = "Apply Register Filter";
    private static final String CLEAR_BUTTON_TEXT = "Clear Register Filter";
    private JPanel buttonPanel = this.buildContextRegisterFilterPanel();
    private JButton applyButton;
    private JButton clearButton;
    private ContextRegisterExtent extent;
    private ContextRegisterFilter registerFilter;
    protected JPanel mainPanel;

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void updateExtentAndClearFilter(ContextRegisterExtent contextRegisterExtent) {
        this.extent = contextRegisterExtent;
        this.registerFilter = null;
    }

    public void enableFilterButtons(boolean enable) {
        if (this.applyButton != null) {
            this.applyButton.setEnabled(enable);
        }
        if (this.clearButton != null) {
            this.clearButton.setEnabled(enable);
        }
    }

    public ContextRegisterFilter getContextRegisterFilter() {
        return this.registerFilter;
    }

    private JPanel buildContextRegisterFilterPanel() {
        this.buttonPanel = new JPanel(new FlowLayout());
        this.applyButton = new JButton(APPLY_BUTTON_TEXT);
        this.buttonPanel.add(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextRegisterFilterInputDialog filterDialog = new ContextRegisterFilterInputDialog("Set Context Register Filter", ContextRegisterFilterablePanelBuilder.this.extent, ContextRegisterFilterablePanelBuilder.this.mainPanel);
                ContextRegisterFilterablePanelBuilder.this.registerFilter = filterDialog.getFilter();
                if (ContextRegisterFilterablePanelBuilder.this.registerFilter == null) {
                    return;
                }
                ContextRegisterFilterablePanelBuilder.this.applyFilterAction();
            }
        });
        this.clearButton = new JButton(CLEAR_BUTTON_TEXT);
        this.buttonPanel.add(this.clearButton);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextRegisterFilterablePanelBuilder.this.clearFilterAction();
            }
        });
        return this.buttonPanel;
    }

    public abstract void applyFilterAction();

    public abstract void clearFilterAction();
}

