/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LayoutSizeChange {

    public static interface Listener<V> {
        public void layoutSizeChanged(Event<V> var1);
    }

    public static class Event<V> {
        public final LayoutModel<V> layoutModel;
        public final int width;
        public final int height;

        public Event(LayoutModel<V> layoutModel, int width, int height) {
            this.layoutModel = layoutModel;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return "LayoutSizeChange.Event{layoutModel=" + this.layoutModel + ", " + this.width + ", " + this.height + "}";
        }
    }

    public static class SupportImpl<V>
    implements Support<V> {
        private static final Logger log = LoggerFactory.getLogger(SupportImpl.class);
        protected boolean fireEvents = true;
        protected List<Listener<V>> changeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            log.trace("setFireEvents({})", (Object)fireEvents);
            this.fireEvents = fireEvents;
        }

        @Override
        public void addLayoutSizeChangeListener(Listener<V> l) {
            this.changeListeners.add(l);
        }

        @Override
        public void removeLayoutSizeChangeListener(Listener<V> l) {
            this.changeListeners.remove(l);
        }

        @Override
        public List<Listener<V>> getLayoutSizeChangeListeners() {
            return this.changeListeners;
        }

        @Override
        public void fireLayoutSizeChanged(LayoutModel<V> layoutModel, int width, int height) {
            if (this.fireEvents && this.changeListeners.size() > 0) {
                log.trace("fireLayoutSizeChange width:{}, height:{}", (Object)width, (Object)height);
                Event<V> evt = new Event<V>(layoutModel, width, height);
                for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                    this.changeListeners.get(i).layoutSizeChanged(evt);
                }
            }
        }
    }

    public static interface Support<V> {
        public static <V> Support<V> create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addLayoutSizeChangeListener(Listener<V> var1);

        public void removeLayoutSizeChangeListener(Listener<V> var1);

        public List<Listener<V>> getLayoutSizeChangeListeners();

        public void fireLayoutSizeChanged(LayoutModel<V> var1, int var2, int var3);
    }

    public static interface Producer<V> {
        public Support<V> getLayoutSizeChangeSupport();
    }
}

