/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedDataEntry;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.InvalidInputException;

public class HighCodeSymbol
extends HighSymbol {
    private CodeSymbol symbol;

    public HighCodeSymbol(CodeSymbol sym, HighFunction func) {
        super(sym.getID(), sym.getName(), null, func);
        MappedEntry entry;
        this.symbol = sym;
        this.setNameLock(true);
        this.setTypeLock(true);
        Object dataObj = this.symbol.getObject();
        if (dataObj instanceof Data) {
            Data data = (Data)dataObj;
            data = (Data)dataObj;
            this.type = data.getDataType();
            int size = this.type.getLength();
            if (size <= 0) {
                size = data.getLength();
            }
            VariableStorage store = VariableStorage.UNASSIGNED_STORAGE;
            try {
                store = new VariableStorage((ProgramArchitecture)this.symbol.getProgram(), this.symbol.getAddress(), size);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            entry = new MappedDataEntry((HighSymbol)this, store, data);
        } else {
            this.type = DataType.DEFAULT;
            entry = new MappedEntry(this, VariableStorage.UNASSIGNED_STORAGE, null);
        }
        this.addMapEntry(entry);
    }

    public HighCodeSymbol(long id, Address addr, DataType dataType, int sz, HighFunction func) {
        super(id, SymbolUtilities.getDynamicName(func.getFunction().getProgram(), addr), dataType, func);
        VariableStorage store;
        this.symbol = null;
        this.setNameLock(true);
        this.setTypeLock(true);
        Program program = func.getFunction().getProgram();
        Data data = program.getListing().getDataAt(addr);
        try {
            store = new VariableStorage((ProgramArchitecture)program, addr, sz);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = data != null ? new MappedDataEntry((HighSymbol)this, store, data) : new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    public HighCodeSymbol(long id, String nm, Data data, PcodeDataTypeManager dtmanage) {
        super(id, nm, data.getDataType(), true, true, dtmanage);
        VariableStorage store;
        Program program = dtmanage.getProgram();
        try {
            store = new VariableStorage((ProgramArchitecture)program, data.getMinAddress(), data.getLength());
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedDataEntry entry = new MappedDataEntry((HighSymbol)this, store, data);
        this.addMapEntry(entry);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public CodeSymbol getCodeSymbol() {
        return this.symbol;
    }

    public Data getData() {
        SymbolEntry entry = this.entryList[0];
        if (entry instanceof MappedDataEntry) {
            return ((MappedDataEntry)entry).getData();
        }
        return null;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        super.decode(decoder);
        this.symbol = null;
    }
}

