/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class ContextCommit
extends ContextChange {
    private TripleSymbol sym;
    private int num;
    private int mask;
    private boolean flow;

    public ContextCommit() {
    }

    @Override
    public void validate() {
    }

    public ContextCommit(TripleSymbol s, int sbit, int ebit, boolean fl) {
        this.sym = s;
        this.flow = fl;
        MutableInt n = new MutableInt();
        MutableInt zero = new MutableInt(0);
        MutableInt m = new MutableInt();
        Utils.calc_maskword(s.getLocation(), sbit, ebit, n, zero, m);
        this.num = n.get();
        this.mask = m.get();
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_COMMIT);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.sym.getId());
        encoder.writeSignedInteger(SlaFormat.ATTRIB_NUMBER, this.num);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_MASK, Utils.unsignedInt(this.mask));
        encoder.writeBool(SlaFormat.ATTRIB_FLOW, this.flow);
        encoder.closeElement(SlaFormat.ELEM_COMMIT);
    }
}

