/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.jar.ResourceFile;
import generic.stl.IteratorSTL;
import generic.stl.MapSTL;
import generic.stl.Pair;
import generic.stl.SelfComparator;
import generic.stl.VectorSTL;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.context.Token;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slgh_compile.ConsistencyChecker;
import ghidra.pcodeCPort.slgh_compile.ExprTree;
import ghidra.pcodeCPort.slgh_compile.FieldContext;
import ghidra.pcodeCPort.slgh_compile.FieldQuality;
import ghidra.pcodeCPort.slgh_compile.MacroBuilder;
import ghidra.pcodeCPort.slgh_compile.PcodeCompile;
import ghidra.pcodeCPort.slgh_compile.RtlPair;
import ghidra.pcodeCPort.slgh_compile.SectionVector;
import ghidra.pcodeCPort.slgh_compile.SleighCompileLauncher;
import ghidra.pcodeCPort.slgh_compile.SleighCompilePreprocessorDefinitionsAdapater;
import ghidra.pcodeCPort.slgh_compile.SpaceQuality;
import ghidra.pcodeCPort.slgh_compile.space_class;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghpatexpress.EndInstructionValue;
import ghidra.pcodeCPort.slghpatexpress.EqualEquation;
import ghidra.pcodeCPort.slghpatexpress.EquationAnd;
import ghidra.pcodeCPort.slghpatexpress.Next2InstructionValue;
import ghidra.pcodeCPort.slghpatexpress.OperandEquation;
import ghidra.pcodeCPort.slghpatexpress.PatternEquation;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenField;
import ghidra.pcodeCPort.slghsymbol.BitrangeSymbol;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.slghsymbol.ContextCommit;
import ghidra.pcodeCPort.slghsymbol.ContextOp;
import ghidra.pcodeCPort.slghsymbol.ContextSymbol;
import ghidra.pcodeCPort.slghsymbol.DecisionProperties;
import ghidra.pcodeCPort.slghsymbol.EndSymbol;
import ghidra.pcodeCPort.slghsymbol.EpsilonSymbol;
import ghidra.pcodeCPort.slghsymbol.FamilySymbol;
import ghidra.pcodeCPort.slghsymbol.LabelSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.NameSymbol;
import ghidra.pcodeCPort.slghsymbol.Next2Symbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SectionSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SpaceSymbol;
import ghidra.pcodeCPort.slghsymbol.StartSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.SymbolScope;
import ghidra.pcodeCPort.slghsymbol.TokenSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueMapSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeListSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.ConstantSpace;
import ghidra.pcodeCPort.space.OtherSpace;
import ghidra.pcodeCPort.space.UniqueSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.PackedEncode;
import ghidra.program.model.pcode.XmlEncode;
import ghidra.sleigh.grammar.BailoutException;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.PreprocessorException;
import ghidra.sleigh.grammar.SleighCompiler;
import ghidra.sleigh.grammar.SleighLexer;
import ghidra.sleigh.grammar.SleighParser;
import ghidra.sleigh.grammar.SleighPreprocessor;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnbufferedTokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighCompile
extends SleighBase {
    static boolean yydebug = false;
    private static int UNIQUE_CROSSBUILD_POSITION = 8;
    private static int UNIQUE_CROSSBUILD_NUMBITS = 8;
    public final PcodeCompile pcode = new PcodeCompile(){

        @Override
        public void reportError(Location location, String msg) {
            SleighCompile.this.reportError(location, msg);
        }

        @Override
        public void reportWarning(Location location, String msg) {
            SleighCompile.this.reportWarning(location, msg);
        }

        @Override
        public int getErrors() {
            return SleighCompile.this.numErrors();
        }

        @Override
        public int getWarnings() {
            return SleighCompile.this.numWarnings();
        }

        @Override
        public AddrSpace getConstantSpace() {
            return SleighCompile.this.getConstantSpace();
        }

        @Override
        public AddrSpace getDefaultSpace() {
            return SleighCompile.this.getDefaultSpace();
        }

        @Override
        public AddrSpace getUniqueSpace() {
            return SleighCompile.this.getUniqueSpace();
        }

        @Override
        public void addSymbol(SleighSymbol sym) {
            SleighCompile.this.addSymbol(sym);
        }

        @Override
        public SleighSymbol findSymbol(String nm) {
            return SleighCompile.this.findSymbol(nm);
        }

        @Override
        public long allocateTemp() {
            return SleighCompile.this.getUniqueAddr();
        }

        @Override
        public void recordNop(Location location) {
            SleighCompile.this.recordNop(location);
        }

        @Override
        public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
            return SleighCompile.this.createMacroUse(location, sym, param);
        }

        @Override
        public SectionSymbol newSectionSymbol(Location where, String text) {
            return SleighCompile.this.newSectionSymbol(where, text);
        }

        @Override
        public VectorSTL<OpTpl> createCrossBuild(Location find, VarnodeTpl v, SectionSymbol section) {
            return SleighCompile.this.createCrossBuild(find, v, section);
        }

        @Override
        public ConstructTpl enterSection(Location where) {
            return SleighCompile.this.enterSection(where);
        }

        @Override
        public SectionVector standaloneSection(ConstructTpl c) {
            return SleighCompile.this.standaloneSection(c);
        }

        @Override
        public SectionVector firstNamedSection(ConstructTpl main, SectionSymbol sym) {
            return SleighCompile.this.firstNamedSection(main, sym);
        }

        @Override
        public SectionVector nextNamedSection(SectionVector vec, ConstructTpl section, SectionSymbol sym) {
            return SleighCompile.this.nextNamedSection(vec, section, sym);
        }

        @Override
        public SectionVector finalNamedSection(SectionVector vec, ConstructTpl section) {
            return SleighCompile.this.finalNamedSection(vec, section);
        }
    };
    private MapSTL<String, String> preproc_defines = new MapSTL((Comparator)new SelfComparator());
    private VectorSTL<FieldContext> contexttable = new VectorSTL();
    private Integer firstContextField = null;
    private VectorSTL<ConstructTpl> macrotable = new VectorSTL();
    private VectorSTL<Token> tokentable = new VectorSTL();
    private VectorSTL<SubtableSymbol> tables = new VectorSTL();
    private VectorSTL<SectionSymbol> sections = new VectorSTL();
    private Constructor curct;
    private MacroSymbol curmacro;
    private boolean contextlock;
    private int userop_count;
    private boolean warnunnecessarypcode;
    private boolean warndeadtemps;
    private boolean warnunusedfields;
    private boolean lenientconflicterrors;
    private boolean largetemporarywarning;
    private boolean warnalllocalcollisions;
    private boolean warnallnops;
    private boolean failinsensitivedups;
    private boolean debugoutput;
    private VectorSTL<String> noplist = new VectorSTL();
    private Deque<WithBlock> withstack = new LinkedList<WithBlock>();
    private int errors;
    private int warnings;

    private static boolean isLocationIsh(Object o) {
        if (o instanceof Location) {
            return true;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (Object t : l) {
                if (!SleighCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        if (o instanceof VectorSTL) {
            VectorSTL v = (VectorSTL)o;
            for (Object t : v) {
                if (!SleighCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static void entry(String name, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("(");
        sb.append(Arrays.stream(args).filter(a -> SleighCompile.isLocationIsh(a)).map(Object::toString).collect(Collectors.joining(", ")));
        sb.append(")");
        Msg.trace(SleighCompile.class, (Object)sb.toString());
    }

    private void predefinedSymbols() {
        SleighCompile.entry("predefinedSymbols", new Object[0]);
        this.symtab.addScope();
        Location location = Location.INTERNALLY_DEFINED;
        this.root = new SubtableSymbol(location, "instruction");
        this.symtab.addSymbol(this.root);
        this.insertSpace(new ConstantSpace(this));
        SpaceSymbol spacesym = new SpaceSymbol(location, this.getConstantSpace());
        this.symtab.addSymbol(spacesym);
        OtherSpace otherSpace = new OtherSpace(this, "OTHER", 1);
        this.insertSpace(otherSpace);
        spacesym = new SpaceSymbol(location, otherSpace);
        this.symtab.addSymbol(spacesym);
        this.insertSpace(new UniqueSpace(this, this.numSpaces(), 0));
        spacesym = new SpaceSymbol(location, this.getUniqueSpace());
        this.symtab.addSymbol(spacesym);
        StartSymbol startsym = new StartSymbol(location, "inst_start", this.getConstantSpace());
        this.symtab.addSymbol(startsym);
        EndSymbol endsym = new EndSymbol(location, "inst_next", this.getConstantSpace());
        this.symtab.addSymbol(endsym);
        Next2Symbol next2sym = new Next2Symbol(location, "inst_next2", this.getConstantSpace());
        this.symtab.addSymbol(next2sym);
        EpsilonSymbol epsilon = new EpsilonSymbol(location, "epsilon", this.getConstantSpace());
        this.symtab.addSymbol(epsilon);
    }

    protected SectionSymbol newSectionSymbol(Location location, String nm) {
        SleighCompile.entry("newSectionSymbol", location, nm);
        SectionSymbol sym = new SectionSymbol(location, nm, this.sections.size());
        try {
            this.symtab.addGlobalSymbol(sym);
        }
        catch (SleighError err) {
            this.reportError(err.location, err.getMessage());
        }
        this.sections.push_back((Object)sym);
        this.numSections = this.sections.size();
        return sym;
    }

    protected VectorSTL<OpTpl> createCrossBuild(Location location, VarnodeTpl addr, SectionSymbol sym) {
        SleighCompile.entry("createCrossBuild", location, addr, sym);
        this.unique_allocatemask = 1;
        VectorSTL res = new VectorSTL();
        VarnodeTpl sectionid = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, sym.getTemplateId()), new ConstTpl(ConstTpl.const_type.real, 4L));
        OpTpl op = new OpTpl(location, OpCode.CPUI_PTRSUB);
        op.addInput(addr);
        op.addInput(sectionid);
        res.push_back((Object)op);
        sym.incrementRefCount();
        return res;
    }

    protected ConstructTpl enterSection(Location where) {
        SleighCompile.entry("enterSection", where);
        this.pcode.resetLabelCount();
        return new ConstructTpl(where);
    }

    protected SectionVector standaloneSection(ConstructTpl main) {
        SleighCompile.entry("standaloneSection", main);
        SectionVector res = new SectionVector(main, this.symtab.getCurrentScope());
        return res;
    }

    protected SectionVector firstNamedSection(ConstructTpl main, SectionSymbol sym) {
        SleighCompile.entry("firstNamedSection", main);
        sym.incrementDefineCount();
        SymbolScope curscope = this.symtab.getCurrentScope();
        SymbolScope parscope = curscope.getParent();
        if (parscope != this.symtab.getGlobalScope()) {
            throw new LowlevelError("firstNamedSection called when not in Constructor scope");
        }
        this.symtab.addScope();
        SectionVector res = new SectionVector(main, curscope);
        res.setNextIndex(sym.getTemplateId());
        return res;
    }

    protected SectionVector nextNamedSection(SectionVector vec, ConstructTpl section, SectionSymbol sym) {
        SleighCompile.entry("nextNamedSection", vec, section, sym);
        sym.incrementDefineCount();
        SymbolScope curscope = this.symtab.getCurrentScope();
        this.symtab.popScope();
        SymbolScope parscope = this.symtab.getCurrentScope().getParent();
        if (parscope != this.symtab.getGlobalScope()) {
            throw new LowlevelError("nextNamedSection called when not in section scope");
        }
        this.symtab.addScope();
        vec.append(section, curscope);
        vec.setNextIndex(sym.getTemplateId());
        return vec;
    }

    protected SectionVector finalNamedSection(SectionVector vec, ConstructTpl section) {
        SleighCompile.entry("finalNamedSection", vec, section);
        vec.append(section, this.symtab.getCurrentScope());
        this.symtab.popScope();
        return vec;
    }

    private int calcContextVarLayout(int start, int sz, int numbits) {
        SleighCompile.entry("calcContextVarLayout", start, sz, numbits);
        VarnodeSymbol sym = ((FieldContext)this.contexttable.get((int)start)).sym;
        int symSize = sym.getSize();
        if (symSize % 4 != 0) {
            this.reportError(sym.location, String.format("Invalid size of context register '%s' (%d); must be a multiple of 4", sym.getName(), symSize));
        }
        int maxBits = symSize * 8 - 1;
        int i = 0;
        while (i < sz) {
            int endword;
            int j;
            FieldQuality qual = ((FieldContext)this.contexttable.get((int)(i + start))).qual;
            int max = qual.high;
            int min = qual.low;
            if (max - min > 32) {
                this.reportError(qual.location, String.format("Size of bitfield %s=(%d,%d) larger than %d bits in context register '%s'", qual.name, min, max, 32, sym.getName()));
            }
            if (max > maxBits) {
                this.reportError(qual.location, String.format("Scope of bitfield %s=(%d,%d) extends beyond the size of context register '%s' (%d)", qual.name, min, max, sym.getName(), maxBits));
            }
            for (j = i + 1; j < sz; ++j) {
                qual = ((FieldContext)this.contexttable.get((int)(j + start))).qual;
                if (qual.low > max) break;
                if (qual.high <= max) continue;
                max = qual.high;
            }
            int alloc = max - min + 1;
            int startword = Utils.unsignedDivide(numbits, 32);
            if (startword != (endword = Utils.unsignedDivide(numbits + alloc - 1, 32))) {
                numbits = endword * 32;
            }
            int low = numbits;
            numbits += alloc;
            while (i < j) {
                qual = ((FieldContext)this.contexttable.get((int)(i + start))).qual;
                int l = qual.low - min + low;
                int h = numbits - 1 - (max - qual.high);
                ContextField field = new ContextField(qual.location, qual.signext, l, h);
                int id = this.addSymbol(new ContextSymbol(qual.location, qual.name, field, sym, qual.low, qual.high, qual.flow));
                if (this.firstContextField == null) {
                    this.firstContextField = id;
                }
                ++i;
            }
        }
        sym.markAsContext();
        return numbits;
    }

    private void buildDecisionTrees() {
        SleighCompile.entry("buildDecisionTrees", new Object[0]);
        DecisionProperties props = new DecisionProperties();
        this.root.buildDecisionTree(props);
        for (int i = 0; i < this.tables.size(); ++i) {
            ((SubtableSymbol)this.tables.get(i)).buildDecisionTree(props);
        }
        VectorSTL<String> ierrors = props.getIdentErrors();
        for (int i = 0; i < ierrors.size(); ++i) {
            ++this.errors;
            Msg.error((Object)this, (Object)ierrors.get(i));
        }
        if (!this.lenientconflicterrors) {
            VectorSTL<String> cerrors = props.getConflictErrors();
            for (int i = 0; i < cerrors.size(); ++i) {
                ++this.errors;
                Msg.error((Object)this, (Object)cerrors.get(i));
            }
        }
    }

    private void buildPatterns() {
        SleighCompile.entry("buildPatterns", new Object[0]);
        if (this.root == null) {
            this.reportError(null, "No patterns to match--could not find any constructors");
            return;
        }
        this.root.buildPattern(System.err);
        if (this.root.isError()) {
            ++this.errors;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            if (((SubtableSymbol)this.tables.get(i)).isError()) {
                this.reportError(((SubtableSymbol)this.tables.get(i)).getLocation(), "Problem in table: '" + ((SubtableSymbol)this.tables.get(i)).getName());
                ++this.errors;
            }
            if (((SubtableSymbol)this.tables.get(i)).getPattern() != null) continue;
            this.reportWarning(((SubtableSymbol)this.tables.get(i)).getLocation(), "Unreferenced table: '" + ((SubtableSymbol)this.tables.get(i)).getName() + "'");
        }
    }

    private void checkConsistency() {
        SleighCompile.entry("checkConsistency", new Object[0]);
        ConsistencyChecker checker = new ConsistencyChecker(this, this.root, this.warnunnecessarypcode, this.warndeadtemps, this.largetemporarywarning);
        if (!checker.testSizeRestrictions()) {
            ++this.errors;
            return;
        }
        if (!checker.testTruncations()) {
            ++this.errors;
            return;
        }
        if (!this.warnunnecessarypcode && checker.getNumUnnecessaryPcode() > 0) {
            this.reportWarning(null, checker.getNumUnnecessaryPcode() + " unnecessary extensions/truncations were converted to copies");
            this.reportWarning(null, "Use -u switch to list each individually");
        }
        checker.optimizeAll();
        if (checker.getNumReadNoWrite() > 0) {
            ++this.errors;
            return;
        }
        if (!this.warndeadtemps && checker.getNumWriteNoRead() > 0) {
            this.reportWarning(null, checker.getNumWriteNoRead() + " operations wrote to temporaries that were not read");
            this.reportWarning(null, "Use -t switch to list each individually");
        }
        checker.testLargeTemporary();
    }

    private static int findCollision(Map<Long, Integer> local2Operand, ArrayList<Long> locals, int operand) {
        Integer boxOperand = operand;
        for (Long local : locals) {
            Integer previous = local2Operand.putIfAbsent(local, boxOperand);
            if (previous == null || previous == operand) continue;
            return previous;
        }
        return -1;
    }

    private boolean checkLocalExports(Constructor ct) {
        if (ct.getTempl() == null) {
            return true;
        }
        if (ct.getTempl().buildOnly()) {
            return true;
        }
        if (ct.getNumOperands() < 2) {
            return true;
        }
        boolean noCollisions = true;
        TreeMap<Long, Integer> collect = new TreeMap<Long, Integer>();
        for (int i = 0; i < ct.getNumOperands(); ++i) {
            int collideOperand;
            ArrayList<Long> newCollect = new ArrayList<Long>();
            ct.getOperand(i).collectLocalValues(newCollect);
            if (newCollect.isEmpty() || (collideOperand = SleighCompile.findCollision(collect, newCollect, i)) < 0) continue;
            noCollisions = false;
            if (!this.warnalllocalcollisions) break;
            this.reportWarning(ct.location, String.format("Possible operand collision between symbols '%s' and '%s'", ct.getOperand(collideOperand).getName(), ct.getOperand(i).getName()));
            break;
        }
        return noCollisions;
    }

    private void checkLocalCollisions() {
        int collisionCount = 0;
        SubtableSymbol sym = this.root;
        int i = -1;
        while (true) {
            int numconst = sym.getNumConstructors();
            for (int j = 0; j < numconst; ++j) {
                if (this.checkLocalExports(sym.getConstructor(j))) continue;
                ++collisionCount;
            }
            if (++i >= this.tables.size()) break;
            sym = (SubtableSymbol)this.tables.get(i);
        }
        if (collisionCount > 0) {
            this.reportWarning(null, collisionCount + " constructors with local collisions between operands");
            if (!this.warnalllocalcollisions) {
                this.reportWarning(null, "Use -c switch to list each individually");
            }
        }
    }

    private void checkNops() {
        if (this.noplist.size() > 0) {
            if (this.warnallnops) {
                IteratorSTL iter = this.noplist.begin();
                while (!iter.isEnd()) {
                    Msg.warn(SleighCompile.class, (Object)iter.get());
                    iter.increment();
                }
            }
            Msg.warn(SleighCompile.class, (Object)(this.noplist.size() + " NOP constructors found"));
            if (!this.warnallnops) {
                Msg.warn(SleighCompile.class, (Object)"Use -n switch to list each individually");
            }
        }
    }

    private void checkCaseSensitivity() {
        if (!this.failinsensitivedups) {
            return;
        }
        HashMap<String, SleighSymbol> registerMap = new HashMap<String, SleighSymbol>();
        SymbolScope scope = this.symtab.getGlobalScope();
        IteratorSTL<SleighSymbol> iter = scope.begin();
        while (!iter.isEnd()) {
            SleighSymbol sym = (SleighSymbol)iter.get();
            if (sym instanceof VarnodeSymbol) {
                String nm;
                SleighSymbol oldsym;
                VarnodeSymbol vsym = (VarnodeSymbol)sym;
                AddrSpace space = vsym.getFixedVarnode().space;
                if (space.getType() == spacetype.IPTR_PROCESSOR && (oldsym = registerMap.putIfAbsent(nm = sym.getName().toUpperCase(), sym)) != null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("Name collision: ").append(sym.getName()).append(" --- ");
                    Location oldLocation = oldsym.getLocation();
                    buffer.append("Duplicate symbol ").append(oldsym.getName()).append(" defined at ");
                    buffer.append(oldLocation);
                    this.reportError(sym.getLocation(), buffer.toString());
                }
            }
            iter.increment();
        }
    }

    private String checkSymbols(SymbolScope scope) {
        SleighCompile.entry("checkSymbols", scope);
        ArrayList<String> symbolErrors = new ArrayList<String>();
        IteratorSTL<SleighSymbol> iter = scope.begin();
        while (!iter.equals(scope.end())) {
            SleighSymbol sym = (SleighSymbol)iter.get();
            if (sym.getType() == symbol_type.label_symbol) {
                LabelSymbol labsym = (LabelSymbol)sym;
                if (labsym.getRefCount() == 0) {
                    symbolErrors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was placed but never used", sym.getName())));
                } else if (!labsym.isPlaced()) {
                    symbolErrors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was referenced but never placed", sym.getName())));
                }
            }
            iter.increment();
        }
        return symbolErrors.stream().collect(Collectors.joining("  "));
    }

    protected int addSymbol(SleighSymbol sym) {
        SleighCompile.entry("addSymbol", sym);
        int id = -1;
        try {
            id = this.symtab.addSymbol(sym);
        }
        catch (SleighError err) {
            this.reportError(err.location, err.getMessage());
        }
        return id;
    }

    public SleighCompile() {
        SleighCompile.entry("SleighCompile", new Object[0]);
        this.contextlock = false;
        this.userop_count = 0;
        this.errors = 0;
        this.warnunnecessarypcode = false;
        this.lenientconflicterrors = true;
        this.largetemporarywarning = false;
        this.warnallnops = false;
        this.failinsensitivedups = true;
        this.debugoutput = false;
        this.root = null;
        this.pcode.resetLabelCount();
    }

    public void reportError(Location location, String msg) {
        SleighCompile.entry("reportError", location, msg);
        Msg.error((Object)this, (Object)MessageFormattingUtils.format(location, msg));
        ++this.errors;
    }

    public void reportError(Location location, String msg, Throwable t) {
        SleighCompile.entry("reportError", location, msg);
        Msg.error((Object)this, (Object)MessageFormattingUtils.format(location, msg), (Throwable)t);
        ++this.errors;
    }

    public void reportWarning(Location location, String msg) {
        SleighCompile.entry("reportWarning", location, msg);
        Msg.warn((Object)this, (Object)MessageFormattingUtils.format(location, msg));
        ++this.warnings;
    }

    public void recordNop(Location location) {
        SleighCompile.entry("recordNop", location);
        this.noplist.push_back((Object)("NOP detected at " + String.valueOf(location)));
    }

    public int numErrors() {
        SleighCompile.entry("numErrors", new Object[0]);
        return this.errors;
    }

    public int numWarnings() {
        SleighCompile.entry("numWarnings", new Object[0]);
        return this.warnings;
    }

    protected long getUniqueAddr() {
        SleighCompile.entry("getUniqueAddr", new Object[0]);
        long base = this.getUniqueBase();
        this.setUniqueBase(base + 256L);
        return base;
    }

    public void setUnnecessaryPcodeWarning(boolean val) {
        SleighCompile.entry("setUnecessaryPcodeWarning", val);
        this.warnunnecessarypcode = val;
    }

    public void setDeadTempWarning(boolean val) {
        SleighCompile.entry("setDeadTempWarning", val);
        this.warndeadtemps = val;
    }

    public void setUnusedFieldWarning(boolean val) {
        SleighCompile.entry("setUnusedFieldWarning", val);
        this.warnunusedfields = val;
    }

    public void setEnforceLocalKeyWord(boolean val) {
        SleighCompile.entry("setEnforceLocalKeyWord", val);
        this.pcode.setEnforceLocalKey(val);
    }

    public void setLenientConflict(boolean val) {
        SleighCompile.entry("setLenientConflict", val);
        this.lenientconflicterrors = val;
    }

    public void setLocalCollisionWarning(boolean val) {
        SleighCompile.entry("setLocalCollisionWarning", val);
        this.warnalllocalcollisions = val;
    }

    public void setAllNopWarning(boolean val) {
        SleighCompile.entry("setAllNopWarning", val);
        this.warnallnops = val;
    }

    public void setInsensitiveDuplicateError(boolean val) {
        SleighCompile.entry("setInsensitiveDuplicateError", val);
        this.failinsensitivedups = val;
    }

    public void setDebugOutput(boolean val) {
        SleighCompile.entry("setDebugOutput", val);
        this.debugoutput = val;
    }

    private void process() {
        SleighCompile.entry("process", new Object[0]);
        this.checkNops();
        this.checkCaseSensitivity();
        if (this.getDefaultSpace() == null) {
            this.reportError(null, "No default space specified");
        }
        if (this.errors > 0) {
            return;
        }
        this.checkConsistency();
        if (this.errors > 0) {
            return;
        }
        this.checkLocalCollisions();
        if (this.errors > 0) {
            return;
        }
        this.buildPatterns();
        if (this.errors > 0) {
            return;
        }
        this.buildDecisionTrees();
        if (this.errors > 0) {
            return;
        }
        ArrayList<SleighSymbol> errorPairs = new ArrayList<SleighSymbol>();
        this.buildXrefs(errorPairs);
        if (!errorPairs.isEmpty()) {
            for (int i = 0; i < errorPairs.size(); i += 2) {
                SleighSymbol sym1 = errorPairs.get(i);
                SleighSymbol sym2 = errorPairs.get(i + 1);
                String msg = String.format("Duplicate (offset,size) pair for registers: %s (%s) and %s (%s)", sym1.getName(), sym1.getLocation(), sym2.getName(), sym2.getLocation());
                this.reportError(sym1.getLocation(), msg);
                this.reportError(sym2.getLocation(), msg);
            }
            ++this.errors;
            return;
        }
        this.checkUniqueAllocation();
        this.checkFieldUsage();
        this.symtab.purge();
    }

    public void calcContextLayout() {
        int sz;
        SleighCompile.entry("calcContextLayout", new Object[0]);
        if (this.contextlock) {
            return;
        }
        this.contextlock = true;
        int context_offset = 0;
        this.contexttable.sort();
        for (int begin = 0; begin < this.contexttable.size(); begin += sz) {
            sz = 1;
            while (begin + sz < this.contexttable.size() && ((FieldContext)this.contexttable.get((int)(begin + sz))).sym.equals(((FieldContext)this.contexttable.get((int)begin)).sym)) {
                ++sz;
            }
            context_offset = this.calcContextVarLayout(begin, sz, context_offset);
        }
        this.contexttable.clear();
    }

    public Pair<Boolean, String> getPreprocValue(String nm) {
        IteratorSTL iter = this.preproc_defines.find((Object)nm);
        if (iter.isEnd()) {
            return new Pair((Object)false, null);
        }
        return new Pair((Object)true, (Object)((String)((Pair)iter.get()).second));
    }

    public void setPreprocValue(String nm, String value) {
        this.preproc_defines.put((Object)nm, (Object)value);
    }

    public boolean undefinePreprocValue(String nm) {
        IteratorSTL iter = this.preproc_defines.find((Object)nm);
        if (iter.isEnd()) {
            return false;
        }
        this.preproc_defines.erase(iter);
        return true;
    }

    public TokenSymbol defineToken(Location location, String name, long sz, int endian) {
        SleighCompile.entry("defineToken", location, name, sz);
        int size = (int)sz;
        if ((size & 7) != 0) {
            this.reportError(location, "Definition of '" + name + "' token -- size must be multiple of 8");
            size = size / 8 + 1;
        } else {
            size /= 8;
        }
        boolean isBig = endian == 0 ? this.isBigEndian() : endian > 0;
        Token newtoken = new Token(name, size, isBig, this.tokentable.size());
        this.tokentable.push_back((Object)newtoken);
        TokenSymbol res = new TokenSymbol(location, newtoken);
        this.addSymbol(res);
        return res;
    }

    public void addTokenField(Location location, TokenSymbol sym, FieldQuality qual) {
        SleighCompile.entry("addTokenField", location, sym, qual);
        if (qual.high < qual.low) {
            this.reportError(location, "Field '" + qual.name + "' starts at " + Integer.toString(qual.low) + " and ends at " + Integer.toString(qual.high));
        }
        if (sym.getToken().getSize() * 8 <= qual.high) {
            this.reportError(location, "Field '" + qual.name + "' high must be less than token size");
        }
        TokenField field = new TokenField(location, sym.getToken(), qual.signext, qual.low, qual.high);
        this.addSymbol(new ValueSymbol(location, qual.name, field));
    }

    public boolean addContextField(Location location, VarnodeSymbol sym, FieldQuality qual) {
        SleighCompile.entry("addContextField", sym, qual);
        if (qual.high < qual.low) {
            this.reportError(location, "Context field '" + qual.name + "' starts at " + Integer.toString(qual.low) + " and ends at " + Integer.toString(qual.high));
        }
        if (sym.getSize() * 8 <= qual.high) {
            this.reportError(location, "Context field '" + qual.name + "' high must be less than context size");
        }
        if (this.contextlock) {
            return false;
        }
        this.contexttable.push_back((Object)new FieldContext(sym, qual));
        return true;
    }

    private int bitsConsumedByUnitSize(int ws) {
        int cnt = 0;
        for (int test = ws - 1; test != 0; test >>= 1) {
            ++cnt;
        }
        return cnt;
    }

    public void newSpace(Location location, SpaceQuality qual) {
        SleighCompile.entry("newSpace", location, qual);
        if (qual.size == 0) {
            this.reportError(location, "Space definition '" + qual.name + "' missing size attribute");
            return;
        }
        if (qual.size <= 0 || qual.size > 8) {
            throw new SleighError("Space '" + qual.name + "' has unsupported size: " + qual.size, location);
        }
        if (qual.wordsize < 1 || qual.wordsize > 8) {
            throw new SleighError("Space '" + qual.name + "' has unsupported wordsize: " + qual.wordsize, location);
        }
        int addressBits = this.bitsConsumedByUnitSize(qual.wordsize) + 8 * qual.size;
        if (addressBits > 64) {
            throw new SleighError("Space '" + qual.name + "' has unsupported dimensions: requires " + addressBits + " bits -- limit is 64 bits", location);
        }
        int delay = qual.type == space_class.register_space ? 0 : 1;
        AddrSpace spc = new AddrSpace(this, spacetype.IPTR_PROCESSOR, qual.name, qual.size, qual.wordsize, this.numSpaces(), 256, delay);
        this.insertSpace(spc);
        if (qual.isdefault) {
            if (this.getDefaultSpace() != null) {
                this.reportError(location, "Multiple default spaces -- '" + this.getDefaultSpace().getName() + "', '" + qual.name + "'");
            } else {
                this.setDefaultSpace(spc.getIndex());
            }
        }
        this.addSymbol(new SpaceSymbol(location, spc));
    }

    public void setEndian(int end) {
        SleighCompile.entry("setEndian", end);
        this.target_endian = end;
        this.predefinedSymbols();
    }

    public void setAlignment(int val) {
        SleighCompile.entry("setAlignment", val);
        this.alignment = val;
    }

    public void defineVarnodes(SpaceSymbol spacesym, long off, int size, VectorSTL<String> names, VectorSTL<Location> locations) {
        SleighCompile.entry("defineVarnodes", spacesym, off, size, names, locations);
        AddrSpace spc = spacesym.getSpace();
        long myoff = off;
        for (int i = 0; i < names.size(); ++i) {
            Location location = (Location)locations.get(i);
            if (!"_".equals(names.get(i))) {
                this.addSymbol(new VarnodeSymbol(location, (String)names.get(i), spc, myoff, size));
            }
            myoff += (long)size;
        }
    }

    public void defineBitrange(Location location, String name, VarnodeSymbol sym, int bitoffset, int numb) {
        SleighCompile.entry("defineBitrange", location, name, sym, bitoffset, numb);
        String namecopy = name;
        int size = 8 * sym.getSize();
        if (numb == 0) {
            this.reportError(location, "Size of bitrange is zero for '" + namecopy + "'");
            return;
        }
        if (bitoffset >= size || bitoffset + numb > size) {
            this.reportError(location, "Bad bitrange for '" + namecopy + "'");
            return;
        }
        if (bitoffset % 8 == 0 && numb % 8 == 0) {
            AddrSpace newspace = sym.getFixedVarnode().space;
            long newoffset = sym.getFixedVarnode().offset;
            int newsize = numb / 8;
            newoffset = this.isBigEndian() ? (newoffset += (long)((size - bitoffset - numb) / 8)) : (newoffset += (long)(bitoffset / 8));
            this.addSymbol(new VarnodeSymbol(location, namecopy, newspace, newoffset, newsize));
        } else {
            if (size > 64) {
                this.reportError(location, "'" + sym.getName() + "': Illegal bitrange on varnode larger than 64 bits");
            }
            this.addSymbol(new BitrangeSymbol(location, namecopy, sym, bitoffset, numb));
        }
    }

    public void addUserOp(VectorSTL<String> names, VectorSTL<Location> locations) {
        SleighCompile.entry("addUserOp", names, locations);
        for (int i = 0; i < names.size(); ++i) {
            boolean isInternal = this.pcode.isInternalFunction((String)names.get(i));
            if (isInternal) {
                this.reportError((Location)locations.get(i), "'" + (String)names.get(i) + "' is an internal pcodeop and cannot be redefined as a pseudoop");
            }
            UserOpSymbol sym = new UserOpSymbol((Location)locations.get(i), (String)names.get(i));
            sym.setIndex(this.userop_count++);
            this.addSymbol(sym);
        }
    }

    public SleighSymbol dedupSymbolList(VectorSTL<SleighSymbol> symlist) {
        SleighCompile.entry("dedupSymbolList", symlist);
        SleighSymbol res = null;
        for (int i = 0; i < symlist.size(); ++i) {
            SleighSymbol sym = (SleighSymbol)symlist.get(i);
            if (sym == null) continue;
            for (int j = i + 1; j < symlist.size(); ++j) {
                if (symlist.get(j) != sym) continue;
                res = sym;
                symlist.set(j, null);
            }
        }
        return res;
    }

    public void attachValues(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<Long> numlist) {
        SleighCompile.entry("attachValues", symlist, locations, numlist);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "'attach values' list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)numlist.size()) {
                this.reportError(location, "Attach value '" + String.valueOf(sym) + "' is wrong size for list: " + String.valueOf(numlist));
            }
            this.symtab.replaceSymbol(sym, new ValueMapSymbol(location, sym.getName(), patval, numlist));
        }
    }

    public void attachNames(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<String> names) {
        SleighCompile.entry("attachNames", symlist, locations, names);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "'attach names' list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)names.size()) {
                this.reportError(location, "Attach name '" + String.valueOf(sym) + "' is wrong size for list: " + String.valueOf(names));
            }
            this.symtab.replaceSymbol(sym, new NameSymbol(location, sym.getName(), patval, names));
        }
    }

    public void attachVarnodes(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<SleighSymbol> varlist) {
        SleighCompile.entry("attachVarnodes", symlist, locations, varlist);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "'attach variables' list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            if (this.firstContextField != null && sym.getId() == this.firstContextField.intValue()) {
                this.reportError(location, "'" + sym.getName() + "' cannot be used to attach variables because it occurs at the lowest bit position in context at " + String.valueOf(sym.getLocation()));
                continue;
            }
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)varlist.size()) {
                this.reportError(location, "Attach varnode '" + String.valueOf(sym) + "' is wrong size for list: " + String.valueOf(varlist));
            }
            int sz = 0;
            for (int j = 0; j < varlist.size(); ++j) {
                VarnodeSymbol vsym = (VarnodeSymbol)varlist.get(j);
                if (vsym == null) continue;
                if (sz == 0) {
                    sz = vsym.getFixedVarnode().size;
                    continue;
                }
                if (sz == vsym.getFixedVarnode().size) continue;
                this.reportError(location, "Attach statement contains varnodes of different sizes");
                break;
            }
            this.symtab.replaceSymbol(sym, new VarnodeListSymbol(location, sym.getName(), patval, varlist));
        }
    }

    public SubtableSymbol newTable(Location location, String nm) {
        SleighCompile.entry("newTable", location, nm);
        SubtableSymbol sym = new SubtableSymbol(location, nm);
        this.addSymbol(sym);
        this.tables.push_back((Object)sym);
        return sym;
    }

    public void newOperand(Location location, Constructor ct, String nm) {
        SleighCompile.entry("newOperand", location, ct, nm);
        int index = ct.getNumOperands();
        OperandSymbol sym = new OperandSymbol(location, nm, index, ct);
        this.addSymbol(sym);
        ct.addOperand(sym);
    }

    public PatternEquation constrainOperand(Location location, OperandSymbol sym, PatternExpression patexp) {
        EqualEquation res;
        SleighCompile.entry("constrainOperand", location, sym, patexp);
        TripleSymbol definingSymbol = sym.getDefiningSymbol();
        if (definingSymbol instanceof FamilySymbol) {
            FamilySymbol famsym = (FamilySymbol)definingSymbol;
            res = new EqualEquation(location, famsym.getPatternValue(), patexp);
        } else {
            this.reportError(location, "Constraining currently undefined operand: " + String.valueOf(sym));
            PatternExpression.release(patexp);
            res = null;
        }
        return res;
    }

    public void defineOperand(Location location, OperandSymbol sym, PatternExpression patexp) {
        SleighCompile.entry("defineOperand", location, sym, patexp);
        try {
            sym.defineOperand(patexp);
            sym.setOffsetIrrelevant();
        }
        catch (SleighError err) {
            this.reportError(location, err.getMessage());
            PatternExpression.release(patexp);
        }
    }

    public PatternEquation defineInvisibleOperand(Location location, TripleSymbol sym) {
        SleighCompile.entry("defineInvisibleOperand", location, sym);
        int index = this.curct.getNumOperands();
        OperandSymbol opsym = new OperandSymbol(location, sym.getName(), index, this.curct);
        this.addSymbol(opsym);
        this.curct.addInvisibleOperand(opsym);
        OperandEquation res = new OperandEquation(location, opsym.getIndex());
        symbol_type tp = sym.getType();
        try {
            if (tp == symbol_type.value_symbol || tp == symbol_type.context_symbol) {
                opsym.defineOperand(sym.getPatternExpression());
            } else {
                opsym.defineOperand(sym);
            }
        }
        catch (SleighError err) {
            this.reportError(location, err.getMessage());
        }
        return res;
    }

    public void selfDefine(OperandSymbol sym) {
        SleighCompile.entry("selfDefine", sym);
        SleighSymbol sleighSymbol = this.symtab.findSymbol(sym.getName(), 1);
        if (!(sleighSymbol instanceof TripleSymbol)) {
            this.reportError(sym.getLocation(), "No matching global symbol '" + sym.getName() + "'");
            return;
        }
        TripleSymbol glob = (TripleSymbol)sleighSymbol;
        symbol_type tp = glob.getType();
        try {
            if (tp == symbol_type.value_symbol || tp == symbol_type.context_symbol) {
                sym.defineOperand(glob.getPatternExpression());
            } else {
                sym.defineOperand(glob);
            }
        }
        catch (SleighError err) {
            this.reportError(sym.getLocation(), err.getMessage());
        }
    }

    public boolean contextMod(VectorSTL<ContextChange> vec, ContextSymbol sym, PatternExpression pe) {
        SleighCompile.entry("contextMod", vec, sym, pe);
        VectorSTL vallist = new VectorSTL();
        pe.listValues((VectorSTL<PatternValue>)vallist);
        for (int i = 0; i < vallist.size(); ++i) {
            PatternValue v = (PatternValue)vallist.get(i);
            if (!(v instanceof EndInstructionValue) && !(v instanceof Next2InstructionValue)) continue;
            return false;
        }
        ContextField field = (ContextField)sym.getPatternValue();
        ContextOp op = new ContextOp(sym.getLocation(), field.getStartBit(), field.getEndBit(), pe);
        vec.push_back((Object)op);
        return true;
    }

    public void contextSet(VectorSTL<ContextChange> vec, TripleSymbol sym, ContextSymbol cvar) {
        SleighCompile.entry("contextSet", vec, sym, cvar);
        ContextField field = (ContextField)cvar.getPatternValue();
        ContextCommit op = new ContextCommit(sym, field.getStartBit(), field.getEndBit(), cvar.isFlow());
        vec.push_back((Object)op);
    }

    public MacroSymbol createMacro(Location location, String name, VectorSTL<String> params, VectorSTL<Location> locations) {
        SleighCompile.entry("createMacro", location, name, params, locations);
        this.curct = null;
        this.curmacro = new MacroSymbol(location, name, this.macrotable.size());
        this.addSymbol(this.curmacro);
        this.symtab.addScope();
        this.pcode.resetLabelCount();
        for (int i = 0; i < params.size(); ++i) {
            OperandSymbol oper = new OperandSymbol((Location)locations.get(i), (String)params.get(i), i, null);
            this.addSymbol(oper);
            this.curmacro.addOperand(oper);
        }
        return this.curmacro;
    }

    public void compareMacroParams(MacroSymbol sym, VectorSTL<ExprTree> param) {
        SleighCompile.entry("compareMacroParams", sym, param);
        for (int i = 0; i < param.size(); ++i) {
            VarnodeTpl outvn = ((ExprTree)param.get((int)i)).outvn;
            if (outvn == null || outvn.getOffset().getType() != ConstTpl.const_type.handle) continue;
            int hand = outvn.getOffset().getHandleIndex();
            OperandSymbol macroop = sym.getOperand(i);
            OperandSymbol parentop = this.curct == null ? this.curmacro.getOperand(hand) : this.curct.getOperand(hand);
            if (!macroop.isCodeAddress()) continue;
            parentop.setCodeAddress();
        }
    }

    public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
        SleighCompile.entry("createMacroUse", location, sym, param);
        if (sym.getNumOperands() != param.size()) {
            boolean tooManyParams = param.size() > sym.getNumOperands();
            this.reportError(sym.getLocation(), String.format("Invocation of macro '%s' passes too " + (tooManyParams ? "many" : "few") + " parameters", sym.getName()));
            return new VectorSTL();
        }
        this.compareMacroParams(sym, param);
        OpTpl op = new OpTpl(location, OpCode.CPUI_CAST);
        VarnodeTpl idvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, sym.getIndex()), new ConstTpl(ConstTpl.const_type.real, 4L));
        op.addInput(idvn);
        return ExprTree.appendParams(op, param);
    }

    public Constructor createConstructor(Location location, SubtableSymbol sym) {
        SleighCompile.entry("createConstructor", location, sym);
        if (sym == null) {
            sym = WithBlock.getCurrentSubtable(this.withstack);
        }
        if (sym == null) {
            sym = this.root;
        }
        this.curmacro = null;
        this.curct = new Constructor(location, sym);
        sym.addConstructor(this.curct);
        this.symtab.addScope();
        this.pcode.resetLabelCount();
        Integer index = this.indexer.index(location);
        if (index != null) {
            this.curct.setSourceFileIndex(index);
        }
        return this.curct;
    }

    protected void resetConstructors() {
        SleighCompile.entry("resetConstructors", new Object[0]);
        this.symtab.setCurrentScope(this.symtab.getGlobalScope());
    }

    private static VarnodeTpl findSize(ConstTpl offset, ConstructTpl ct) {
        SleighCompile.entry("find_size", offset, ct);
        VectorSTL<OpTpl> ops = ct.getOpvec();
        for (int i = 0; i < ops.size(); ++i) {
            OpTpl op = (OpTpl)ops.get(i);
            VarnodeTpl vn = op.getOut();
            if (vn != null && vn.isLocalTemp() && vn.getOffset().equals(offset)) {
                return vn;
            }
            for (int j = 0; j < op.numInput(); ++j) {
                vn = op.getIn(j);
                if (!vn.isLocalTemp() || !vn.getOffset().equals(offset)) continue;
                return vn;
            }
        }
        return null;
    }

    private static boolean forceExportSize(ConstructTpl ct) {
        SleighCompile.entry("force_exportsize", ct);
        HandleTpl result = ct.getResult();
        if (result == null) {
            return true;
        }
        if (result.getPtrSpace().isUniqueSpace() && result.getPtrSize().isZero()) {
            VarnodeTpl vt = SleighCompile.findSize(result.getPtrOffset(), ct);
            if (vt == null) {
                return false;
            }
            result.setPtrSize(vt.getSize());
        } else if (result.getSpace().isUniqueSpace() && result.getSize().isZero()) {
            VarnodeTpl vt = SleighCompile.findSize(result.getPtrOffset(), ct);
            if (vt == null) {
                return false;
            }
            result.setSize(vt.getSize());
        }
        return true;
    }

    private boolean expandMacros(ConstructTpl ctpl) {
        VectorSTL<OpTpl> vec = ctpl.getOpvec();
        VectorSTL newvec = new VectorSTL();
        IteratorSTL iter = vec.begin();
        while (!iter.isEnd()) {
            OpTpl op = (OpTpl)iter.get();
            if (op.getOpcode() == OpCode.CPUI_CAST) {
                MacroBuilder builder = new MacroBuilder(this, op.location, (VectorSTL<OpTpl>)newvec, ctpl.numLabels());
                int index = (int)op.getIn(0).getOffset().getReal();
                if (index >= this.macrotable.size()) {
                    return false;
                }
                builder.setMacroOp(op);
                ConstructTpl macro_tpl = (ConstructTpl)this.macrotable.get(index);
                builder.build(macro_tpl, -1);
                ctpl.setNumLabels(ctpl.numLabels() + macro_tpl.numLabels());
                op.dispose();
                if (builder.hasError()) {
                    return false;
                }
            } else {
                newvec.push_back((Object)op);
            }
            iter.increment();
        }
        ctpl.setOpvec((VectorSTL<OpTpl>)newvec);
        return true;
    }

    private boolean finalizeSections(Constructor big, SectionVector vec) {
        SleighCompile.entry("finalizeSections", big, vec);
        VectorSTL myErrors = new VectorSTL();
        RtlPair cur = vec.getMainPair();
        int i = -1;
        Object sectionstring = "   Main section: ";
        int max = vec.getMaxId();
        while (true) {
            String scopeString = String.valueOf(cur.section.loc) + ": " + (String)sectionstring;
            String errstring = this.checkSymbols(cur.scope);
            if (errstring.length() != 0) {
                myErrors.push_back((Object)(scopeString + errstring));
            } else {
                if (!this.expandMacros(cur.section)) {
                    myErrors.push_back((Object)(scopeString + "Could not expand macros"));
                }
                VectorSTL check = new VectorSTL();
                big.markSubtableOperands((VectorSTL<Integer>)check);
                Pair<Integer, Location> res = cur.section.fillinBuild((VectorSTL<Integer>)check, this.getConstantSpace());
                if ((Integer)res.first == 1) {
                    myErrors.push_back((Object)(scopeString + "Duplicate BUILD statements at " + String.valueOf(res.second)));
                }
                if ((Integer)res.first == 2) {
                    myErrors.push_back((Object)(scopeString + "Unnecessary BUILD statements at " + String.valueOf(res.second)));
                }
                if (!this.pcode.propagateSize(cur.section)) {
                    myErrors.push_back((Object)(scopeString + "Could not resolve at least 1 variable size"));
                }
            }
            if (i < 0 && cur.section.getResult() != null) {
                if (big.getParent() == this.root) {
                    myErrors.push_back((Object)"   Cannot have export statement in root constructor");
                } else if (!SleighCompile.forceExportSize(cur.section)) {
                    myErrors.push_back((Object)"   Size of export is unknown");
                }
            }
            if (cur.section.delaySlot() != 0) {
                if (this.root != big.getParent()) {
                    this.reportWarning(big.location, "Delay slot used in " + String.valueOf(big));
                }
                if (cur.section.delaySlot() > this.maxdelayslotbytes) {
                    this.maxdelayslotbytes = cur.section.delaySlot();
                }
            }
            while (++i < max) {
                cur = vec.getNamedPair(i);
                if (cur.section == null) continue;
            }
            if (i >= max) break;
            SectionSymbol sym = (SectionSymbol)this.sections.get(i);
            sectionstring = "   " + sym.getName() + " section: ";
        }
        if (!myErrors.empty()) {
            this.reportError(big.location, "in " + String.valueOf(big));
            for (int j = 0; j < myErrors.size(); ++j) {
                this.reportError(big.location, (String)myErrors.get(j));
            }
            return false;
        }
        return true;
    }

    private static long insertCrossBuildRegion(long addr) {
        long upperbits = addr >> UNIQUE_CROSSBUILD_POSITION << UNIQUE_CROSSBUILD_POSITION + UNIQUE_CROSSBUILD_NUMBITS;
        long lowerbits = addr << 64 - UNIQUE_CROSSBUILD_POSITION >>> 64 - UNIQUE_CROSSBUILD_POSITION;
        return upperbits | lowerbits;
    }

    private static void shiftUniqueVn(VarnodeTpl vn) {
        SleighCompile.entry("shiftUniqueVn", vn);
        if (vn.getSpace().isUniqueSpace() && vn.getOffset().getType() == ConstTpl.const_type.real) {
            long val = SleighCompile.insertCrossBuildRegion(vn.getOffset().getReal());
            vn.setOffset(val);
        }
    }

    private static void shiftUniqueOp(OpTpl op) {
        SleighCompile.entry("shiftUniqueOp", op);
        VarnodeTpl outvn = op.getOut();
        if (outvn != null) {
            SleighCompile.shiftUniqueVn(outvn);
        }
        for (int i = 0; i < op.numInput(); ++i) {
            SleighCompile.shiftUniqueVn(op.getIn(i));
        }
    }

    private static void shiftUniqueHandle(HandleTpl hand) {
        long val;
        SleighCompile.entry("shiftUniqueHandle", hand);
        if (hand.getSpace().isUniqueSpace() && hand.getPtrSpace().getType() == ConstTpl.const_type.real && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            val = SleighCompile.insertCrossBuildRegion(hand.getPtrOffset().getReal());
            hand.setPtrOffset(val);
        } else if (hand.getPtrSpace().isUniqueSpace() && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            val = SleighCompile.insertCrossBuildRegion(hand.getPtrOffset().getReal());
            hand.setPtrOffset(val);
        }
        if (hand.getTempSpace().isUniqueSpace() && hand.getTempOffset().getType() == ConstTpl.const_type.real) {
            val = SleighCompile.insertCrossBuildRegion(hand.getTempOffset().getReal());
            hand.setTempOffset(val);
        }
    }

    private static void shiftUniqueConstruct(ConstructTpl tpl) {
        SleighCompile.entry("shiftUniqueConstruct", tpl);
        HandleTpl result = tpl.getResult();
        if (result != null) {
            SleighCompile.shiftUniqueHandle(result);
        }
        VectorSTL<OpTpl> vec = tpl.getOpvec();
        for (int i = 0; i < vec.size(); ++i) {
            SleighCompile.shiftUniqueOp((OpTpl)vec.get(i));
        }
    }

    private void checkUniqueAllocation() {
        if (this.unique_allocatemask == 0) {
            return;
        }
        this.unique_allocatemask = 255;
        int secsize = this.sections.size();
        SubtableSymbol sym = this.root;
        int i = -1;
        while (true) {
            int numconst = sym.getNumConstructors();
            for (int j = 0; j < numconst; ++j) {
                Constructor ct = sym.getConstructor(j);
                ConstructTpl tpl = ct.getTempl();
                if (tpl != null) {
                    SleighCompile.shiftUniqueConstruct(tpl);
                }
                for (int k = 0; k < secsize; ++k) {
                    ConstructTpl namedtpl = ct.getNamedTempl(k);
                    if (namedtpl == null) continue;
                    SleighCompile.shiftUniqueConstruct(namedtpl);
                }
            }
            if (++i >= this.tables.size()) break;
            sym = (SubtableSymbol)this.tables.get(i);
        }
        long ubase = this.getUniqueBase();
        ubase += (long)(1 << UNIQUE_CROSSBUILD_POSITION);
        this.setUniqueBase(ubase <<= UNIQUE_CROSSBUILD_NUMBITS);
    }

    private void checkFieldUsage() {
        if (this.warnunusedfields) {
            VectorSTL<SleighSymbol> unsoughtSymbols = this.symtab.getUnsoughtSymbols();
            IteratorSTL siter = unsoughtSymbols.begin();
            while (!siter.isEnd()) {
                ValueSymbol valueSymbol;
                PatternValue patternValue;
                SleighSymbol sleighSymbol = (SleighSymbol)siter.get();
                if (sleighSymbol instanceof ValueSymbol && (patternValue = (valueSymbol = (ValueSymbol)sleighSymbol).getPatternValue()) instanceof TokenField && sleighSymbol.location != Location.INTERNALLY_DEFINED) {
                    this.reportWarning(patternValue.location, "token field '" + sleighSymbol.getName() + "' defined but never used");
                }
                siter.increment();
            }
        }
    }

    public void pushWith(SubtableSymbol ss, PatternEquation pateq, VectorSTL<ContextChange> contvec) {
        this.withstack.push(new WithBlock(ss, pateq, contvec));
    }

    public void popWith() {
        this.withstack.pop();
    }

    public void buildConstructor(Constructor big, PatternEquation pateq, VectorSTL<ContextChange> contvec, SectionVector vec) {
        boolean noerrors = true;
        if (vec != null && (noerrors = this.finalizeSections(big, vec))) {
            big.setMainSection(vec.getMainSection());
            int max = vec.getMaxId();
            for (int i = 0; i < max; ++i) {
                ConstructTpl section = vec.getNamedSection(i);
                if (section == null) continue;
                big.setNamedSection(section, i);
            }
        }
        if (noerrors) {
            pateq = WithBlock.collectAndPrependPattern(this.withstack, pateq);
            contvec = WithBlock.collectAndPrependContext(this.withstack, contvec);
            big.addEquation(pateq);
            big.removeTrailingSpace();
            if (contvec != null) {
                big.addContext(contvec);
            }
        }
        this.symtab.popScope();
    }

    public void buildMacro(MacroSymbol sym, ConstructTpl rtl) {
        SleighCompile.entry("buildMacro", sym, rtl);
        String errstring = this.checkSymbols(this.symtab.getCurrentScope());
        if (errstring.length() != 0) {
            this.reportError(sym.getLocation(), "Error in definition of macro '" + sym.getName() + "': " + errstring);
            return;
        }
        if (!this.expandMacros(rtl)) {
            this.reportError(sym.getLocation(), "Could not expand submacro in definition of macro '" + sym.getName() + "'");
            return;
        }
        this.pcode.propagateSize(rtl);
        sym.setConstruct(rtl);
        this.symtab.popScope();
        this.macrotable.push_back((Object)rtl);
    }

    @Override
    public int instructionLength(Address baseaddr) {
        return 0;
    }

    @Override
    public int printAssembly(PrintStream s, int size, Address baseaddr) {
        return 0;
    }

    public void setAllOptions(Map<String, String> preprocs, boolean unnecessaryPcodeWarning, boolean lenientConflict, boolean allCollisionWarning, boolean allNopWarning, boolean deadTempWarning, boolean unusedFieldWarning, boolean enforceLocalKeyWord, boolean caseSensitiveRegisterNames, boolean debugOutput) {
        Set<Map.Entry<String, String>> entrySet = preprocs.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.setPreprocValue(entry.getKey(), entry.getValue());
        }
        this.setUnnecessaryPcodeWarning(unnecessaryPcodeWarning);
        this.setLenientConflict(lenientConflict);
        this.setLocalCollisionWarning(allCollisionWarning);
        this.setAllNopWarning(allNopWarning);
        this.setDeadTempWarning(deadTempWarning);
        this.setUnusedFieldWarning(unusedFieldWarning);
        this.setEnforceLocalKeyWord(enforceLocalKeyWord);
        this.setInsensitiveDuplicateError(!caseSensitiveRegisterNames);
        this.setDebugOutput(debugOutput);
    }

    public int run_compilation(String filein, String fileout) throws IOException, RecognitionException {
        block11: {
            LineArrayListWriter writer = new LineArrayListWriter();
            ParsingEnvironment env = new ParsingEnvironment(writer);
            try {
                SleighCompilePreprocessorDefinitionsAdapater definitionsAdapter = new SleighCompilePreprocessorDefinitionsAdapater(this);
                File inputFile = new File(filein);
                FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((File)inputFile);
                if (!result.isOk()) {
                    throw new BailoutException("input file \"" + String.valueOf(inputFile) + "\" is not properly case dependent: " + result.getMessage());
                }
                SleighPreprocessor sp = new SleighPreprocessor(definitionsAdapter, inputFile);
                sp.process(writer);
                ANTLRStringStream input = new ANTLRStringStream(writer.toString());
                SleighLexer lex = new SleighLexer((CharStream)input);
                lex.setEnv(env);
                UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lex);
                SleighParser parser = new SleighParser((TokenStream)tokens);
                parser.setEnv(env);
                parser.setLexer(lex);
                SleighParser.spec_return parserRoot = parser.spec();
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)parserRoot.getTree());
                nodes.setTokenStream((TokenStream)tokens);
                SleighCompiler walker = new SleighCompiler((TreeNodeStream)nodes);
                int parseres = -1;
                try {
                    parseres = walker.root(env, this);
                }
                catch (SleighError e) {
                    this.reportError(e.location, e.getMessage());
                }
                if (parseres == 0) {
                    this.process();
                }
                if (parseres == 0 && this.numErrors() == 0) {
                    ResourceFile resourceFile = new ResourceFile(fileout);
                    if (this.debugoutput) {
                        XmlEncode encoder = new XmlEncode();
                        this.encode(encoder);
                        OutputStream stream = resourceFile.getOutputStream();
                        encoder.writeTo(stream);
                        stream.close();
                    } else {
                        PackedEncode encoder = SlaFormat.buildEncoder(resourceFile);
                        this.encode(encoder);
                        encoder.getOutputStream().close();
                    }
                    break block11;
                }
                Msg.error(SleighCompile.class, (Object)"No output produced");
                return 2;
            }
            catch (BailoutException e) {
                Msg.error(SleighCompile.class, (Object)"Unrecoverable error(s), halting compilation", (Throwable)e);
                return 3;
            }
            catch (NullPointerException e) {
                Msg.error(SleighCompile.class, (Object)"Unrecoverable error(s), halting compilation", (Throwable)e);
                return 4;
            }
            catch (PreprocessorException e) {
                Msg.error(SleighCompile.class, (Object)e.getMessage());
                Msg.error(SleighCompile.class, (Object)"Errors during preprocessing, halting compilation");
                return 5;
            }
        }
        return 0;
    }

    public static void main(String[] args) throws IOException, RecognitionException {
        System.exit(SleighCompileLauncher.runMain(args));
    }

    protected static class WithBlock {
        SubtableSymbol ss;
        PatternEquation pateq;
        VectorSTL<ContextChange> contvec;

        WithBlock(SubtableSymbol ss, PatternEquation pateq, VectorSTL<ContextChange> contvec) {
            this.ss = ss;
            this.pateq = pateq;
            this.contvec = contvec;
        }

        static PatternEquation collectAndPrependPattern(Deque<WithBlock> stack, PatternEquation pateq) {
            for (WithBlock with : stack) {
                if (with.pateq == null) continue;
                pateq = new EquationAnd(null, with.pateq, pateq);
            }
            return pateq;
        }

        static VectorSTL<ContextChange> collectAndPrependContext(Deque<WithBlock> stack, VectorSTL<ContextChange> contvec) {
            for (WithBlock with : stack) {
                if (with.contvec == null) continue;
                contvec.insertAll(contvec.begin(), with.contvec);
            }
            return contvec;
        }

        static SubtableSymbol getCurrentSubtable(Deque<WithBlock> stack) {
            for (WithBlock with : stack) {
                if (with.ss == null) continue;
                return with.ss;
            }
            return null;
        }
    }
}

