/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.io.IOException;
import org.rzo.netty.ahessian.io.CRCInputStream;
import org.rzo.netty.ahessian.io.InputStreamBuffer;
import org.rzo.netty.ahessian.stopable.StopableHandler;

public class InputStreamHandler
extends ChannelInboundHandlerAdapter
implements StopableHandler {
    volatile InputStreamBuffer _in = null;
    boolean _stopEnabled = true;
    boolean _crcCheck = false;
    private volatile Runnable _disconnectListener = null;
    private static AttributeKey<InputStreamBuffer> INSTREAM = AttributeKey.valueOf((String)"INSTREAM");

    public InputStreamHandler() {
    }

    public InputStreamHandler(boolean crcCheck) {
        this._crcCheck = crcCheck;
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        this._in.write((ByteBuf)e);
        ctx.fireChannelReadComplete();
        ctx.fireChannelRead((Object)this._in);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this._in == null) {
            this._in = this._crcCheck ? new CRCInputStream() : new InputStreamBuffer();
            ctx.channel().attr(INSTREAM).set((Object)this._in);
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this._disconnectListener != null) {
            this._disconnectListener.run();
        }
        ctx.fireChannelInactive();
    }

    public static InputStreamBuffer getInputStream(ChannelHandlerContext ctx) {
        return (InputStreamBuffer)ctx.channel().attr(INSTREAM).get();
    }

    @Override
    public boolean isStopEnabled() {
        return this._stopEnabled;
    }

    @Override
    public void setStopEnabled(boolean stopEnabled) {
        this._stopEnabled = stopEnabled;
    }

    @Override
    public void stop() {
        try {
            this._in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._in = null;
    }

    public void setDisconnectListener(Runnable disconnectListener) {
        this._disconnectListener = disconnectListener;
    }

    public static InputStreamHandler getHandler(ChannelHandlerContext ctx) {
        return (InputStreamHandler)ctx.pipeline().get(InputStreamHandler.class);
    }
}

