/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import java.util.HashSet;
import java.util.Set;

public class BsfvGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    public BsfvGraphDisplayListener(PluginTool tool, Program program, GraphDisplay display) {
        super(tool, program, display);
    }

    public GraphDisplayListener cloneWith(GraphDisplay gDisplay) {
        return new BsfvGraphDisplayListener(this.tool, this.program, gDisplay);
    }

    protected Set<AttributedVertex> getVertices(AddressSetView selection) {
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        AddressFactory addrFactory = this.program.getAddressFactory();
        for (AttributedVertex v : this.graphDisplay.getGraph().vertexSet()) {
            Address stop;
            Address start;
            Address opAddr;
            if (v.hasAttribute("Address") && selection.contains(opAddr = addrFactory.getAddress(v.getAttribute("Address")))) {
                vertices.add(v);
            }
            if (!v.hasAttribute("Block Start") || !v.hasAttribute("Block Stop") || !selection.intersects(start = addrFactory.getAddress(v.getAttribute("Block Start")), stop = addrFactory.getAddress(v.getAttribute("Block Stop")))) continue;
            vertices.add(v);
        }
        return vertices;
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertexIds) {
        AddressSet addresses = new AddressSet();
        AddressFactory addrFactory = this.program.getAddressFactory();
        for (AttributedVertex v : vertexIds) {
            if (v.hasAttribute("Address")) {
                addresses.add(addrFactory.getAddress(v.getAttribute("Address")));
            }
            if (!v.hasAttribute("Block Start") || !v.hasAttribute("Block Stop")) continue;
            Address start = addrFactory.getAddress(v.getAttribute("Block Start"));
            Address stop = addrFactory.getAddress(v.getAttribute("Block Stop"));
            addresses.add(start, stop);
        }
        return addresses;
    }

    protected Address getAddress(AttributedVertex vertex) {
        AddressFactory addrFactory = this.program.getAddressFactory();
        if (vertex.hasAttribute("Address")) {
            return addrFactory.getAddress(vertex.getAttribute("Address"));
        }
        if (vertex.hasAttribute("Block Start")) {
            return addrFactory.getAddress(vertex.getAttribute("Block Start"));
        }
        return null;
    }
}

