/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class ExeSpecifier
implements Comparable<ExeSpecifier> {
    public String exename = "";
    public String arch = "";
    public String execompname = "";
    public String exemd5 = "";

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append(" <exe>\n");
        if (this.exemd5.length() != 0) {
            fwrite.append("  <md5>").append(this.exemd5).append("</md5>\n");
            fwrite.append("  <name>");
            if (this.exename.length() != 0) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.exename);
            }
            fwrite.append("</name>\n");
        } else {
            fwrite.append("  <name>");
            if (this.exename.length() != 0) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.exename);
            }
            fwrite.append("</name>\n");
            fwrite.append("  <arch>");
            if (this.arch.length() != 0) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.arch);
            }
            fwrite.append("</arch>\n");
            fwrite.append("  <compiler>");
            if (this.execompname.length() != 0) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.execompname);
            }
            fwrite.append("</compiler>\n");
        }
        fwrite.append(" </exe>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        XmlElement el = parser.start(new String[0]);
        if (el.getName().equals("md5")) {
            this.exemd5 = parser.end().getText();
            parser.start(new String[0]);
            this.exename = parser.end().getText();
            this.arch = "";
            this.execompname = "";
        } else {
            this.exemd5 = "";
            this.exename = parser.end().getText();
            parser.start(new String[]{"arch"});
            this.arch = parser.end().getText();
            parser.start(new String[]{"compiler"});
            this.execompname = parser.end().getText();
        }
        parser.end();
    }

    public void transfer(ExecutableRecord op2) {
        this.exemd5 = op2.getMd5();
        this.exename = op2.getNameExec();
        this.arch = "";
        this.execompname = "";
    }

    public String getExeNameWithMD5() {
        StringBuilder buf = new StringBuilder();
        boolean addspace = false;
        if (!StringUtils.isBlank((CharSequence)this.exename)) {
            buf.append(this.exename);
            addspace = true;
        }
        if (!StringUtils.isBlank((CharSequence)this.exemd5)) {
            if (addspace) {
                buf.append(' ');
            }
            buf.append(this.exemd5);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        ExeSpecifier o = (ExeSpecifier)obj;
        if (this.exemd5.length() != 0) {
            return this.exemd5.equals(o.exemd5);
        }
        boolean cmp = this.exename.equals(o.exename);
        if (!cmp) {
            return false;
        }
        cmp = this.arch.equals(o.arch);
        if (!cmp) {
            return false;
        }
        return this.execompname.equals(o.execompname);
    }

    @Override
    public int compareTo(ExeSpecifier o) {
        if (this.exemd5.length() != 0) {
            return this.exemd5.compareTo(o.exemd5);
        }
        int comp = this.exename.compareTo(o.exename);
        if (comp != 0) {
            return comp;
        }
        comp = this.arch.compareTo(o.arch);
        if (comp != 0) {
            return comp;
        }
        return this.execompname.compareTo(o.execompname);
    }
}

