/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.feature.vt.api.correlator.program.DataMatchProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public class ExactDataMatchProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    static final String DESC = "Compares data by iterating over all defined data meeting the minimum size requirement in the source program and looking for identical byte matches in the destination program. It reports back any that have ONLY ONE identical match.";
    static final String EXACT_MATCH = "Exact Data Match";
    public static final String DATA_MINIMUM_SIZE = "Data Minimum Size";
    public static final int DATA_MINIMUM_SIZE_DEFAULT = 5;
    public static final String DATA_MAXIMUM_SIZE = "Data Maximum Size";
    public static final int DATA_MAXIMUM_SIZE_DEFAULT = 0x100000;
    public static final String DATA_ALIGNMENT = "Data Alignment";
    public static final int DATA_ALIGNMENT_DEFAULT = 1;
    public static final String SKIP_HOMOGENOUS_DATA = "Skip Homogenous Data";
    public static final boolean SKIP_HOMOGENOUS_DATA_DEFAULT = true;

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    protected VTProgramCorrelator doCreateCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new DataMatchProgramCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options, EXACT_MATCH, true);
    }

    @Override
    public String getName() {
        return EXACT_MATCH;
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(EXACT_MATCH);
        options.setInt(DATA_MINIMUM_SIZE, 5);
        options.setInt(DATA_MAXIMUM_SIZE, 0x100000);
        options.setInt(DATA_ALIGNMENT, 1);
        options.setBoolean(SKIP_HOMOGENOUS_DATA, true);
        return options;
    }

    @Override
    public String getDescription() {
        return DESC;
    }
}

