/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.wizard.WizardDialog;
import docking.wizard.WizardStep;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class WizardModel<T> {
    private List<WizardStep<T>> wizardSteps = new ArrayList<WizardStep<T>>();
    private int currentStepIndex = 0;
    protected T data;
    protected WizardDialog wizardDialog;
    private WizardStep<T> currentStep;
    private String title;
    private Icon wizardIcon;
    private boolean completed = false;
    private boolean busy;

    protected WizardModel(String title, T data) {
        this(title, data, null);
    }

    protected WizardModel(String title, T data, Icon wizardIcon) {
        this.title = title;
        this.data = data;
        this.wizardIcon = wizardIcon;
    }

    protected abstract void addWizardSteps(List<WizardStep<T>> var1);

    protected abstract boolean doFinish();

    protected void cancel() {
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.wizardIcon;
    }

    public String getStatusMessage() {
        return this.getCurrentStep().getStatusMessage();
    }

    public final void finish() {
        if (!this.canFinish()) {
            return;
        }
        int failedStep = this.applyRemainingSteps();
        if (failedStep >= 0) {
            this.setWizardStep(failedStep);
            return;
        }
        boolean success = this.doFinish();
        if (success) {
            this.completed = true;
            this.wizardDialog.close();
        }
    }

    public void dispose() {
        for (WizardStep<T> step : this.wizardSteps) {
            step.dispose(this.data);
        }
    }

    public T getData() {
        return this.data;
    }

    public boolean wasCancelled() {
        return !this.completed;
    }

    public WizardStep<T> getCurrentStep() {
        return this.currentStep;
    }

    public boolean canGoBack() {
        return !this.busy && this.currentStepIndex > 0;
    }

    public boolean canGoNext() {
        if (this.busy) {
            return false;
        }
        this.currentStep.clearStatus();
        if (!this.currentStep.isValid()) {
            return false;
        }
        this.currentStep.populateData(this.data);
        return this.findNextApplicableStep() >= 0;
    }

    public boolean canFinish() {
        if (this.busy) {
            return false;
        }
        if (!this.currentStep.isValid()) {
            return false;
        }
        this.currentStep.populateData(this.data);
        for (int i = this.currentStepIndex + 1; i < this.wizardSteps.size(); ++i) {
            WizardStep<T> step = this.wizardSteps.get(i);
            if (!step.isApplicable(this.data) || step.canFinish(this.data)) continue;
            return false;
        }
        return true;
    }

    public boolean canCancel() {
        return !this.busy;
    }

    public void goBack() {
        if (this.canGoBack()) {
            this.setWizardStep(this.findPreviousApplicableStep());
        }
    }

    public void goNext() {
        if (!this.canGoNext()) {
            return;
        }
        boolean success = this.apply();
        if (success) {
            this.setWizardStep(this.findNextApplicableStep());
        } else {
            this.wizardDialog.statusChanged();
        }
    }

    protected Dimension getPreferredSize() {
        int width = 300;
        int height = 200;
        for (WizardStep<T> step : this.wizardSteps) {
            JComponent c = step.getComponent();
            if (c == null) continue;
            Dimension preferredSize = c.getPreferredSize();
            width = Math.max(width, preferredSize.width);
            height = Math.max(height, preferredSize.height);
        }
        return new Dimension(width, height);
    }

    void initialize(WizardDialog dialog) {
        this.addWizardSteps(this.wizardSteps);
        this.setWizardStep(0);
        this.wizardDialog = dialog;
    }

    private boolean apply() {
        this.busy = true;
        try {
            boolean bl = this.currentStep.apply(this.data);
            return bl;
        }
        finally {
            this.busy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int applyRemainingSteps() {
        this.busy = true;
        try {
            for (int i = this.currentStepIndex; i < this.wizardSteps.size(); ++i) {
                WizardStep<T> step = this.wizardSteps.get(i);
                if (!step.isApplicable(this.data) || step.apply(this.data)) continue;
                int n = i;
                return n;
            }
        }
        finally {
            this.busy = false;
        }
        return -1;
    }

    private void setWizardStep(int stepIndex) {
        this.currentStepIndex = stepIndex;
        this.currentStep = this.wizardSteps.get(this.currentStepIndex);
        this.currentStep.initialize(this.data);
        this.notifyWizardStepChanged();
    }

    private void notifyWizardStepChanged() {
        if (this.wizardDialog != null) {
            this.wizardDialog.wizardStepChanged(this.currentStep);
        }
    }

    protected void statusChanged(WizardStep<T> step) {
        if (this.wizardDialog != null && step == this.currentStep) {
            this.wizardDialog.statusChanged();
        }
    }

    protected void setStatusMessage(String statusMessage) {
        this.currentStep.setStatusMessage(statusMessage);
    }

    private int findNextApplicableStep() {
        for (int i = this.currentStepIndex + 1; i < this.wizardSteps.size(); ++i) {
            if (!this.wizardSteps.get(i).isApplicable(this.data)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousApplicableStep() {
        for (int i = this.currentStepIndex - 1; i >= 1; --i) {
            if (!this.wizardSteps.get(i).isApplicable(this.data)) continue;
            return i;
        }
        return 0;
    }
}

