/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import java.util.Set;
import java.util.stream.Stream;

public class SuccessorsRelativeVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathFilter filter;

    public SuccessorsRelativeVisitor(PathFilter filter) {
        this.filter = filter;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.append(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath valPath) {
        KeyPath path = valPath.getPath();
        return TreeTraversal.VisitResult.result(this.filter.matches(path), this.filter.successorCouldMatch(path, true) && value.isObject());
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.isObject() ? value.getChild() : null;
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath pre) {
        Set<String> nextKeys = this.filter.getNextKeys(pre.getPath());
        if (nextKeys.isEmpty()) {
            return Stream.empty();
        }
        Stream<Object> attrStream = nextKeys.contains("") ? object.getAttributes(span).stream() : Stream.empty();
        Stream<Object> elemStream = nextKeys.contains("[]") ? object.getElements(span).stream() : Stream.empty();
        Stream restStream = nextKeys.stream().filter(k -> !"".equals(k) && !"[]".equals(k)).flatMap(k -> object.getValues(span, (String)k).stream());
        return Stream.concat(Stream.concat(attrStream, elemStream), restStream);
    }
}

