/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class DatatypeMatchFilter
implements QualifierFilter {
    private int position = -1;
    private DatatypeFilter typeFilter = null;

    @Override
    public QualifierFilter clone() {
        DatatypeMatchFilter res = new DatatypeMatchFilter();
        res.position = this.position;
        res.typeFilter = this.typeFilter.clone();
        return res;
    }

    @Override
    public boolean isEquivalent(QualifierFilter op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        DatatypeMatchFilter otherFilter = (DatatypeMatchFilter)op;
        if (this.position != otherFilter.position) {
            return false;
        }
        return this.typeFilter.isEquivalent(otherFilter.typeFilter);
    }

    @Override
    public boolean filter(PrototypePieces proto, int pos) {
        DataType dt;
        if (this.position < 0) {
            dt = proto.outtype;
        } else {
            if (this.position >= proto.intypes.size()) {
                return false;
            }
            dt = proto.intypes.get(this.position);
        }
        return this.typeFilter.filter(dt);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE_AT);
        encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, this.position);
        this.typeFilter.encode(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE_AT);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE_AT.name()});
        this.position = SpecXmlUtils.decodeInt((String)elem.getAttribute(AttributeId.ATTRIB_INDEX.name()));
        this.typeFilter = DatatypeFilter.restoreFilterXml(parser);
        parser.end(elem);
    }
}

