/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.actions;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.FieldMatcher;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import javax.swing.KeyStroke;

public abstract class AbstractFindReferencesDataTypeAction
extends DockingAction {
    private static final String HELP_TOPIC = "LocationReferencesPlugin";
    public static final String NAME = "Find References To";
    public static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);
    private PluginTool tool;

    protected AbstractFindReferencesDataTypeAction(PluginTool tool, String name, String owner) {
        this(tool, name, owner, null);
    }

    protected AbstractFindReferencesDataTypeAction(PluginTool tool, String name, String owner, KeyStroke defaultKeyStroke) {
        super(name, owner, KeyBindingType.SHARED);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "Data_Types"));
        this.setDescription("Shows all uses of the selected data type");
        this.initKeyStroke(defaultKeyStroke);
    }

    protected abstract DataType getDataType(ActionContext var1);

    protected String getDataTypeField(DataType baseDataType) {
        return null;
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataType dataType = this.getDataType(context);
        return dataType != null;
    }

    public void actionPerformed(ActionContext context) {
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)this.tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The FindAppliedDataTypesService is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        DataType dataType = this.getDataType(context);
        DataType baseDataType = ReferenceUtils.getBaseDataType(dataType);
        String field = this.getDataTypeField(baseDataType);
        Swing.runLater(() -> this.doFindDataTypeUsage(service, baseDataType, field));
    }

    private void doFindDataTypeUsage(FindAppliedDataTypesService service, DataType dt, String field) {
        Integer offset;
        if (field == null) {
            service.findAndDisplayAppliedDataTypeAddresses(dt);
            return;
        }
        if (dt instanceof Structure && (offset = this.getOffsetForDeafaultFieldName((Structure)dt, field)) != null) {
            FieldMatcher fieldMatcher = new FieldMatcher(dt, offset);
            service.findAndDisplayAppliedDataTypeAddresses(dt, fieldMatcher);
            return;
        }
        service.findAndDisplayAppliedDataTypeAddresses(dt, field);
    }

    private Integer getOffsetForDeafaultFieldName(Structure structure, String fieldName) {
        DataTypeComponent[] components;
        for (DataTypeComponent dtc : components = structure.getComponents()) {
            if (!dtc.isDefaultFieldName(fieldName)) continue;
            return dtc.getOffset();
        }
        return null;
    }
}

