/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LocalVariableJava
implements StructConverter {
    private short startPC;
    private short length;
    private short nameIndex;
    private short descriptorIndex;
    private short index;

    public LocalVariableJava(BinaryReader reader) throws IOException {
        this.startPC = reader.readNextShort();
        this.length = reader.readNextShort();
        this.nameIndex = reader.readNextShort();
        this.descriptorIndex = reader.readNextShort();
        this.index = reader.readNextShort();
    }

    public int getStartPC() {
        return this.startPC & 0xFFFF;
    }

    public int getLength() {
        return this.length & 0xFFFF;
    }

    public int getNameIndex() {
        return this.nameIndex & 0xFFFF;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex & 0xFFFF;
    }

    public int getIndex() {
        return this.index & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("local_variable", 0);
        structure.add(WORD, "start_pc", null);
        structure.add(WORD, "length", null);
        structure.add(WORD, "name_index", null);
        structure.add(WORD, "descriptor_index", null);
        structure.add(WORD, "index", null);
        return structure;
    }
}

