/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13LineRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class C13FileRecord {
    private long fileId;
    private long nLines;
    private long lenFileBlock;
    private List<C13LineRecord> lineRecords = new ArrayList<C13LineRecord>();

    static C13FileRecord parse(PdbByteReader reader, boolean hasColumn, TaskMonitor monitor) throws PdbException {
        return new C13FileRecord(reader, hasColumn, monitor);
    }

    private C13FileRecord(PdbByteReader reader, boolean hasColumn, TaskMonitor monitor) throws PdbException {
        int sizeColumns;
        if (reader.numRemaining() < 12) {
            throw new PdbException("Not enough data for FileRecord header");
        }
        this.fileId = reader.parseUnsignedIntVal();
        this.nLines = reader.parseUnsignedIntVal();
        this.lenFileBlock = reader.parseUnsignedIntVal();
        long lenMinusHeader = this.lenFileBlock - 12L;
        Long x = this.nLines;
        int nLinesI = x.intValue();
        int sizeLines = nLinesI * 8;
        int sizeRequired = sizeLines + (sizeColumns = nLinesI * (hasColumn ? 4 : 0));
        if (lenMinusHeader != (long)sizeRequired) {
            throw new PdbException("Corrupt FileRecord");
        }
        if (reader.numRemaining() < sizeRequired) {
            throw new PdbException("Not enough data for FileRecord records");
        }
        PdbByteReader lineReader = reader.getSubPdbByteReader(sizeLines);
        PdbByteReader columnReader = hasColumn ? reader.getSubPdbByteReader(sizeColumns) : null;
        int i = 0;
        while ((long)i < this.nLines) {
            C13LineRecord lineRecord = C13LineRecord.parse(lineReader, columnReader);
            this.lineRecords.add(lineRecord);
            ++i;
        }
    }

    public int getFileId() {
        Long v = this.fileId;
        return v.intValue();
    }

    public long getNLines() {
        return this.nLines;
    }

    public long getLenFileBlock() {
        return this.lenFileBlock;
    }

    public List<C13LineRecord> getLineRecords() {
        return this.lineRecords;
    }

    void dump(Writer writer, long offCon) throws IOException {
        writer.write(String.format("fileId: %06x, nLines: %d, lenFileBlock: %d\n", this.getFileId(), this.getNLines(), this.getLenFileBlock()));
        int i = 0;
        while ((long)i < this.getNLines()) {
            List<C13LineRecord> records = this.getLineRecords();
            records.get(i).dump(writer, offCon);
            writer.write("\n");
            ++i;
        }
    }
}

