/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.mcpserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dev.langchain4j.service.tool.ToolExecutionResult;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.ai.mcpserver.MCPAuthenticator;
import org.freeplane.plugin.ai.mcpserver.ModelContextProtocolToolDispatcher;
import org.freeplane.plugin.ai.mcpserver.ModelContextProtocolToolRegistry;
import org.freeplane.plugin.ai.tools.AIToolSet;

public class ModelContextProtocolServer
implements IFreeplanePropertyListener {
    public static final String MCP_SERVER_ENABLED_PROPERTY = "ai_mcp_server_enabled";
    public static final String MCP_SERVER_PORT_PROPERTY = "ai_mcp_server_port";
    public static final String MCP_TOKEN_PROPERTY = "ai_mcp_token";
    public static final String MCP_TOKEN_HEADER = "X-Freeplane-MCP-Token";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String MCP_PROTOCOL_VERSION = "2024-11-05";
    private static final int DEFAULT_PORT = 6298;
    private static final int PORT_MINIMUM = 1024;
    private static final int PORT_MAXIMUM = 65535;
    private static final String SERVER_NAME = "Freeplane AI MCP Server";
    private static final String TOOLS_RESOURCE_URI = "mcp://tools";
    private final ObjectMapper objectMapper;
    private final ModelContextProtocolToolRegistry toolRegistry;
    private final ModelContextProtocolToolDispatcher toolDispatcher;
    private final MCPAuthenticator authenticator;
    private final ResourceController resourceController;
    private final AtomicBoolean running;
    private volatile HttpServer server;

    public ModelContextProtocolServer(AIToolSet toolSet, ViewController viewController) {
        this(toolSet, new ObjectMapper(), ResourceController.getResourceController(), viewController);
    }

    public ModelContextProtocolServer(AIToolSet toolSet, ObjectMapper objectMapper, ViewController viewController) {
        this(toolSet, objectMapper, ResourceController.getResourceController(), viewController);
    }

    ModelContextProtocolServer(AIToolSet toolSet, ObjectMapper objectMapper, ResourceController resourceController, ViewController viewController) {
        this(toolSet, objectMapper, resourceController, new MCPAuthenticator(resourceController, viewController, MCP_TOKEN_PROPERTY, MCP_TOKEN_HEADER));
    }

    ModelContextProtocolServer(AIToolSet toolSet, ObjectMapper objectMapper, ResourceController resourceController, MCPAuthenticator authenticator) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.toolRegistry = new ModelContextProtocolToolRegistry(toolSet, this.objectMapper);
        this.toolDispatcher = new ModelContextProtocolToolDispatcher(toolSet, this.objectMapper);
        this.resourceController = Objects.requireNonNull(resourceController, "resourceController");
        this.authenticator = Objects.requireNonNull(authenticator, "authenticator");
        this.running = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        if (this.resourceController.getBooleanProperty(MCP_SERVER_ENABLED_PROPERTY)) {
            this.start();
        }
    }

    public void start() {
        int port = this.resourceController.getIntProperty(MCP_SERVER_PORT_PROPERTY, 6298);
        this.start(port);
    }

    public void start(int port) {
        if (!this.isValidPort(port)) {
            LogUtils.severe((String)("MCP server port is invalid: " + port));
            return;
        }
        if (!this.isPortAvailable(port)) {
            LogUtils.warn((String)("MCP server port is already in use: " + port));
            return;
        }
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        try {
            HttpServer httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", port), 0);
            httpServer.createContext("/", new ModelContextProtocolHandler());
            httpServer.setExecutor(null);
            httpServer.start();
            this.server = httpServer;
            LogUtils.info((String)("MCP server started on port " + port));
        }
        catch (Exception error) {
            this.running.set(false);
            LogUtils.severe((String)("Failed to start MCP server: " + error.getMessage()));
        }
    }

    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
        LogUtils.info((String)"MCP server stopped.");
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (MCP_SERVER_ENABLED_PROPERTY.equals(propertyName)) {
            if (Boolean.parseBoolean(newValue)) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    private boolean isValidPort(int port) {
        return port >= 1024 && port <= 65535;
    }

    private boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException error) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private class ModelContextProtocolHandler
    implements HttpHandler {
        private ModelContextProtocolHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            JsonNode requestNode;
            if (!"POST".equals(exchange.getRequestMethod())) {
                this.sendStatus(exchange, 405);
                return;
            }
            Object authFailureResponse = ModelContextProtocolServer.this.authenticator.authenticateRequest(exchange.getRequestHeaders());
            if (authFailureResponse != null) {
                this.writeJsonResponse(exchange, authFailureResponse, 401);
                return;
            }
            try {
                byte[] bodyBytes = exchange.getRequestBody().readAllBytes();
                if (bodyBytes == null || bodyBytes.length == 0) {
                    this.writeJsonResponse(exchange, this.buildErrorResponse(null, -32600, "Invalid request"));
                    return;
                }
                requestNode = ModelContextProtocolServer.this.objectMapper.readTree(bodyBytes);
            }
            catch (JsonProcessingException error) {
                this.writeJsonResponse(exchange, this.buildErrorResponse(null, -32700, "Parse error"));
                return;
            }
            if (requestNode == null || requestNode.isNull() || requestNode.isMissingNode()) {
                this.writeJsonResponse(exchange, this.buildErrorResponse(null, -32600, "Invalid request"));
                return;
            }
            if (requestNode.isArray()) {
                this.writeJsonResponse(exchange, this.buildErrorResponse(null, -32600, "Batch requests are not supported"));
                return;
            }
            Object responsePayload = this.handleRequest(requestNode);
            if (responsePayload == null) {
                this.sendStatus(exchange, 204);
                return;
            }
            this.writeJsonResponse(exchange, responsePayload);
        }

        private Object handleRequest(JsonNode requestNode) {
            boolean notification;
            String method = this.getText(requestNode.get("method"));
            JsonNode idNode = requestNode.get("id");
            Object idValue = idNode == null || idNode.isNull() ? null : ModelContextProtocolServer.this.objectMapper.convertValue((Object)idNode, Object.class);
            boolean bl = notification = idValue == null;
            if (method == null || method.isEmpty()) {
                return this.buildErrorResponse(idValue, -32600, "Invalid request");
            }
            if ("initialize".equals(method)) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                result.put("protocolVersion", ModelContextProtocolServer.MCP_PROTOCOL_VERSION);
                result.put("capabilities", this.buildCapabilities());
                result.put("serverInfo", this.buildServerInfo());
                return this.buildSuccessResponse(idValue, result, notification);
            }
            if ("notifications/initialized".equals(method)) {
                return null;
            }
            if ("tools/list".equals(method)) {
                return this.buildSuccessResponse(idValue, this.buildToolListPayload(), notification);
            }
            if ("resources/list".equals(method)) {
                LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>();
                result.put("resources", Collections.singletonList(this.buildToolMetadataResource()));
                return this.buildSuccessResponse(idValue, result, notification);
            }
            if ("resources/templates/list".equals(method)) {
                LinkedHashMap result = new LinkedHashMap();
                result.put("resourceTemplates", Collections.emptyList());
                return this.buildSuccessResponse(idValue, result, notification);
            }
            if ("resources/read".equals(method)) {
                return this.handleResourceRead(requestNode, idValue, notification);
            }
            if ("tools/call".equals(method)) {
                return this.handleToolCall(requestNode, idValue, notification);
            }
            return this.buildErrorResponse(idValue, -32601, "Method not found");
        }

        private Object handleToolCall(JsonNode requestNode, Object idValue, boolean notification) {
            ToolExecutionResult executionResult;
            String toolName;
            JsonNode params = requestNode.get("params");
            String string = toolName = params == null ? null : this.getText(params.get("name"));
            if (toolName == null || toolName.isEmpty()) {
                return this.buildErrorResponse(idValue, -32602, "Missing tool name");
            }
            JsonNode argumentsNode = params == null ? null : params.get("arguments");
            try {
                LogUtils.info((String)("MCP call " + toolName + " " + String.valueOf(argumentsNode)));
                executionResult = ModelContextProtocolServer.this.toolDispatcher.dispatch(toolName, argumentsNode);
            }
            catch (IllegalArgumentException error) {
                return this.buildErrorResponse(idValue, -32602, error.getMessage());
            }
            catch (Exception error) {
                return this.buildErrorResponse(idValue, -32603, error.getMessage());
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("content", Collections.singletonList(this.buildTextContent(executionResult.resultText())));
            if (executionResult.isError()) {
                result.put("isError", true);
            }
            return this.buildSuccessResponse(idValue, result, notification);
        }

        private Object handleResourceRead(JsonNode requestNode, Object idValue, boolean notification) {
            String toolListJson;
            String resourceIdentifier;
            JsonNode params = requestNode.get("params");
            String string = resourceIdentifier = params == null ? null : this.getText(params.get("uri"));
            if (!ModelContextProtocolServer.TOOLS_RESOURCE_URI.equals(resourceIdentifier)) {
                return this.buildErrorResponse(idValue, -32602, "Unknown resource uri");
            }
            try {
                toolListJson = ModelContextProtocolServer.this.objectMapper.writeValueAsString(this.buildToolListPayload());
            }
            catch (JsonProcessingException error) {
                return this.buildErrorResponse(idValue, -32603, "Failed to serialize resource");
            }
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("uri", ModelContextProtocolServer.TOOLS_RESOURCE_URI);
            content.put("mimeType", "application/json");
            content.put("text", toolListJson);
            LinkedHashMap result = new LinkedHashMap();
            result.put("contents", Collections.singletonList(content));
            return this.buildSuccessResponse(idValue, result, notification);
        }

        private Map<String, Object> buildCapabilities() {
            LinkedHashMap<String, Boolean> tools = new LinkedHashMap<String, Boolean>();
            tools.put("listChanged", false);
            LinkedHashMap<String, Boolean> resources = new LinkedHashMap<String, Boolean>();
            resources.put("listChanged", false);
            LinkedHashMap<String, Object> capabilities = new LinkedHashMap<String, Object>();
            capabilities.put("tools", tools);
            capabilities.put("resources", resources);
            return capabilities;
        }

        private Map<String, Object> buildToolListPayload() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("tools", ModelContextProtocolServer.this.toolRegistry.listTools());
            return result;
        }

        private Map<String, Object> buildToolMetadataResource() {
            LinkedHashMap<String, Object> resource = new LinkedHashMap<String, Object>();
            resource.put("uri", ModelContextProtocolServer.TOOLS_RESOURCE_URI);
            resource.put("name", "Tool metadata");
            resource.put("description", "JSON tool list for MCP clients that only support resources.");
            resource.put("mimeType", "application/json");
            return resource;
        }

        private Map<String, Object> buildServerInfo() {
            LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
            info.put("name", ModelContextProtocolServer.SERVER_NAME);
            info.put("version", FreeplaneVersion.getVersion().toString());
            return info;
        }

        private Map<String, Object> buildTextContent(String text) {
            LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
            content.put("type", "text");
            content.put("text", text);
            return content;
        }

        private Object buildSuccessResponse(Object idValue, Object result, boolean notification) {
            if (notification) {
                return null;
            }
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            response.put("jsonrpc", "2.0");
            response.put("id", idValue);
            response.put("result", result);
            return response;
        }

        private Object buildErrorResponse(Object idValue, int code, String message) {
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            error.put("code", code);
            error.put("message", message);
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            response.put("jsonrpc", "2.0");
            response.put("id", idValue);
            response.put("error", error);
            return response;
        }

        private String getText(JsonNode node) {
            return node == null || node.isNull() ? null : node.asText();
        }

        private void writeJsonResponse(HttpExchange exchange, Object responseBody) throws IOException {
            this.writeJsonResponse(exchange, responseBody, 200);
        }

        private void writeJsonResponse(HttpExchange exchange, Object responseBody, int statusCode) throws IOException {
            LogUtils.info((String)("MCP response " + ModelContextProtocolServer.this.objectMapper.writeValueAsString(responseBody)));
            byte[] responseBytes = ModelContextProtocolServer.this.objectMapper.writeValueAsBytes(responseBody);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(statusCode, responseBytes.length);
            try (OutputStream outputStream = exchange.getResponseBody();){
                outputStream.write(responseBytes);
            }
            exchange.close();
        }

        private void sendStatus(HttpExchange exchange, int status) throws IOException {
            exchange.sendResponseHeaders(status, -1L);
            exchange.close();
        }
    }
}

