/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.observability.api.event.AiServiceErrorEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.ToolExecutedEvent;
import dev.langchain4j.observability.api.listener.AiServiceListener;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.ToolArgumentsErrorHandler;
import dev.langchain4j.service.tool.ToolErrorHandlerResult;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.ai.chat.ChatTokenUsageTracker;
import org.freeplane.plugin.ai.tools.AIToolSet;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryHandler;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;
import org.freeplane.plugin.ai.tools.utilities.ToolExecutorFactory;
import org.freeplane.plugin.ai.tools.utilities.ToolExecutorRegistry;

public class AIChatService {
    private static final int MAXIMUM_SUMMARY_TEXT_LENGTH = 160;
    private final AIAssistant assistant;
    private final ToolCallSummaryHandler toolCallSummaryHandler;
    private final ToolArgumentsErrorHandler toolArgumentsErrorHandler;

    public AIChatService(ChatModel chatLanguageModel, AIToolSet toolSet, ChatMemory chatMemory, final ChatTokenUsageTracker chatTokenUsageTracker, ToolCallSummaryHandler toolCallSummaryHandler, Supplier<Boolean> cancellationSupplier, final Consumer<TokenUsage> tokenUsageConsumer) {
        Objects.requireNonNull(chatTokenUsageTracker, "chatTokenUsageTracker");
        this.toolCallSummaryHandler = toolCallSummaryHandler;
        this.toolArgumentsErrorHandler = this.buildToolArgumentsErrorHandler();
        ToolExecutorFactory toolExecutorFactory = new ToolExecutorFactory(true, true, cancellationSupplier);
        ToolExecutorRegistry toolExecutorRegistry = toolExecutorFactory.createRegistry(toolSet);
        AiServices builder = AiServices.builder(AIAssistant.class).toolArgumentsErrorHandler(this.toolArgumentsErrorHandler).chatModel(chatLanguageModel).systemMessageProvider(toolSet::systemMessageForChat).tools(toolExecutorRegistry.getExecutorsBySpecification()).registerListener((AiServiceListener)new AiServiceListener<AiServiceErrorEvent>(){

            public Class<AiServiceErrorEvent> getEventClass() {
                return AiServiceErrorEvent.class;
            }

            public void onEvent(AiServiceErrorEvent event) {
                event.error().printStackTrace();
            }
        }).registerListener((AiServiceListener)new AiServiceListener<AiServiceResponseReceivedEvent>(){

            public Class<AiServiceResponseReceivedEvent> getEventClass() {
                return AiServiceResponseReceivedEvent.class;
            }

            public void onEvent(AiServiceResponseReceivedEvent event) {
                if (tokenUsageConsumer != null) {
                    tokenUsageConsumer.accept(event.response().tokenUsage());
                }
            }
        }).registerListener((AiServiceListener)new AiServiceListener<ToolExecutedEvent>(){

            public Class<ToolExecutedEvent> getEventClass() {
                return ToolExecutedEvent.class;
            }

            public void onEvent(ToolExecutedEvent event) {
                chatTokenUsageTracker.logToolExecuted(event);
            }
        });
        if (chatMemory != null) {
            builder.chatMemory(chatMemory);
        }
        this.assistant = (AIAssistant)builder.build();
    }

    public String chat(String message) {
        return this.assistant.chat(message);
    }

    private ToolArgumentsErrorHandler buildToolArgumentsErrorHandler() {
        return (error, context) -> {
            String arguments;
            String errorMessage = Utils.isNullOrBlank((String)error.getMessage()) ? error.getClass().getName() : error.getMessage();
            String toolName = context == null ? null : context.toolExecutionRequest().name();
            String string = arguments = context == null ? null : context.toolExecutionRequest().arguments();
            if (Utils.isNullOrBlank((String)toolName)) {
                toolName = "unknown tool";
            }
            this.publishToolArgumentsErrorSummary(toolName, arguments, errorMessage);
            return ToolErrorHandlerResult.text((String)("Tool arguments error for " + toolName + ": " + errorMessage));
        };
    }

    private void publishToolArgumentsErrorSummary(String toolName, String arguments, String errorMessage) {
        String safeErrorMessage;
        if (this.toolCallSummaryHandler == null) {
            return;
        }
        LogUtils.info((String)this.buildToolArgumentsErrorLog(toolName, arguments, errorMessage));
        String summaryText = "tool arguments error: tool=" + this.sanitizeSummaryValue(toolName);
        String safeArguments = this.sanitizeSummaryValue(arguments);
        if (!safeArguments.isEmpty()) {
            summaryText = summaryText + ", arguments=" + safeArguments;
        }
        if (!(safeErrorMessage = this.sanitizeSummaryValue(errorMessage)).isEmpty()) {
            summaryText = summaryText + ", error=" + safeErrorMessage;
        }
        ToolCallSummary summary = new ToolCallSummary("toolArgumentsError", summaryText, true, ToolCaller.CHAT);
        this.toolCallSummaryHandler.handleToolCallSummary(summary);
    }

    private String buildToolArgumentsErrorLog(String toolName, String arguments, String errorMessage) {
        String safeToolName = toolName == null ? "unknown tool" : toolName;
        String safeArguments = arguments == null ? "" : arguments;
        String safeError = errorMessage == null ? "" : errorMessage;
        return "Tool arguments error: tool=" + safeToolName + ", arguments=" + safeArguments + ", error=" + safeError;
    }

    private String sanitizeSummaryValue(String value) {
        if (value == null) {
            return "";
        }
        String normalized = value.replace("\r\n", " ").replace("\n", " ").replace("\r", " ").trim();
        if (normalized.length() <= 160) {
            return normalized;
        }
        return normalized.substring(0, 157) + "...";
    }

    public static interface AIAssistant {
        public String chat(String var1);
    }
}

