/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.JButton;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButtonConfigurator;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.ModeController;

public class BookmarksToolbarBuilder {
    private final BookmarksController bookmarksController;
    private final ModeController modeController;
    private final BookmarkButtonConfigurator buttonConfigurator;

    public BookmarksToolbarBuilder(ModeController modeController, BookmarksController bookmarksController) {
        this.modeController = modeController;
        this.bookmarksController = bookmarksController;
        this.buttonConfigurator = new BookmarkButtonConfigurator(bookmarksController, modeController);
    }

    public void updateBookmarksToolbar(BookmarkToolbar toolbar, MapModel map, IMapSelection selection) {
        Component component;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        int focusIndex = -1;
        if (focusOwner != null && focusOwner.getParent() == toolbar) {
            focusIndex = toolbar.getComponentIndex(focusOwner);
        }
        toolbar.removeAll();
        List<NodeBookmark> bookmarks = this.bookmarksController.getBookmarks(map).getBookmarks();
        for (NodeBookmark bookmark : bookmarks) {
            BookmarkButton button = this.createBookmarkButton(bookmark, toolbar, selection);
            toolbar.add(button);
            button.setFocusable(true);
        }
        JButton addRootBranchButton = TranslatedElementFactory.createButtonWithIcon((String)"bookmark.addRootBranch.icon", (String)"bookmark.addRootBranch.text");
        addRootBranchButton.addActionListener(e -> this.bookmarksController.addNewNode(map.getRootNode()));
        int buttonCount = toolbar.getComponentCount();
        toolbar.addSeparator();
        toolbar.add(addRootBranchButton);
        addRootBranchButton.setFocusable(true);
        for (int i = 0; i < 2; ++i) {
            component = toolbar.getComponent(buttonCount + i);
            this.buttonConfigurator.configureNonBookmarkComponent(component);
        }
        if (focusIndex >= 0) {
            int componentCount = buttonCount;
            if (componentCount > focusIndex) {
                component = toolbar.getComponent(focusIndex);
                if (component.isFocusable()) {
                    component.requestFocusInWindow();
                }
            } else {
                toolbar.requestFocusInWindow();
            }
        }
        toolbar.revalidate();
        toolbar.repaint();
    }

    private BookmarkButton createBookmarkButton(NodeBookmark bookmark, BookmarkToolbar toolbar, IMapSelection selection) {
        BookmarkButton button = new BookmarkButton(bookmark, this.modeController);
        this.buttonConfigurator.configureButton(button, bookmark, toolbar, selection);
        return button;
    }
}

