/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.configuration.ConfigurationExportWizard;
import org.jkiss.dbeaver.tools.configuration.ConfigurationImportData;
import org.jkiss.dbeaver.tools.configuration.ConfigurationImportWizardPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private static final Log log = Log.getLog(ConfigurationExportWizard.class);
    ConfigurationImportWizardPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_workspace_import_wizard_window_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new ConfigurationImportWizardPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final Path workbench = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(".plugins/org.eclipse.core.runtime/.settings");
        if (!(workbench.toFile().exists() && workbench.toFile().isDirectory() && workbench.toFile().canRead())) {
            log.error((Object)"Error reading configuration");
            return false;
        }
        final ConfigurationImportData configurationImportData = this.mainPage.getConfigurationImportData();
        new Job(this, "Importing workspace configuration"){
            final /* synthetic */ ConfigurationImportWizard this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                String zipFilepath = configurationImportData.getFilePath();
                File zipFile = Path.of(zipFilepath, new String[0]).toFile();
                if (!zipFile.exists() || !zipFile.canRead()) {
                    return Status.error((String)"Can't read configuration file");
                }
                try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));){
                    ZipEntry nextEntry = zipInputStream.getNextEntry();
                    while (nextEntry != null) {
                        String name = nextEntry.getName();
                        Path configFilePath = workbench.resolve(name);
                        if (!configFilePath.toFile().getParentFile().canWrite()) {
                            throw new IOException("Workspace directory is read-only");
                        }
                        if (configFilePath.toFile().exists()) {
                            File listFile = configFilePath.toFile();
                            if (listFile.getName().equals(name)) {
                                this.this$0.writeZipEntryToFile(zipInputStream, listFile);
                            }
                        } else {
                            Files.createFile(configFilePath, new FileAttribute[0]);
                            this.this$0.writeZipEntryToFile(zipInputStream, configFilePath.toFile());
                        }
                        nextEntry = zipInputStream.getNextEntry();
                    }
                }
                catch (FileNotFoundException exception) {
                    return Status.error((String)"File not found", (Throwable)exception);
                }
                catch (IOException exception) {
                    return Status.error((String)"Error reading file", (Throwable)exception);
                }
                if (UIUtils.confirmAction((Shell)this.this$0.getShell(), (String)NLS.bind((String)CoreMessages.dialog_workspace_import_wizard_window_restart_dialog_title, (Object)GeneralUtils.getProductName()), (String)NLS.bind((String)CoreMessages.dialog_workspace_import_wizard_window_restart_dialog_message, (Object)GeneralUtils.getProductName()))) {
                    UIUtils.asyncExec(() -> PlatformUI.getWorkbench().restart());
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return true;
    }

    private void writeZipEntryToFile(@NotNull ZipInputStream zipInputStream, @NotNull File listFile) throws IOException {
        byte[] buffer = new byte[16384];
        try (OutputStream os = Files.newOutputStream(listFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING);){
            int br = zipInputStream.read(buffer);
            while (br != -1) {
                os.write(buffer, 0, br);
                br = zipInputStream.read(buffer);
            }
        }
        zipInputStream.closeEntry();
    }
}

