/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import net.sf.jsqlparser.schema.MultiPartName;
import net.sf.jsqlparser.schema.Server;

public final class Database
implements MultiPartName {
    private Server server;
    private String databaseName;

    public Database(String databaseName) {
        this.setDatabaseName(databaseName);
    }

    public Database(Server server, String databaseName) {
        this.setServer(server);
        this.setDatabaseName(databaseName);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getFullyQualifiedName() {
        Object fqn = "";
        if (this.server != null) {
            fqn = (String)fqn + this.server.getFullyQualifiedName();
        }
        if (!((String)fqn).isEmpty()) {
            fqn = (String)fqn + ".";
        }
        if (this.databaseName != null) {
            fqn = (String)fqn + this.databaseName;
        }
        return fqn;
    }

    @Override
    public String getUnquotedName() {
        return MultiPartName.unquote(this.databaseName);
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public Database withServer(Server server) {
        this.setServer(server);
        return this;
    }

    public Database withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }
}

