import { Connection } from "vscode-languageserver";
import { DidChangeConfigurationParams } from "vscode-languageserver-protocol";
import { ExtensionSettingsWithDescription, ExtensionSettings } from "../interfaces/extensionSettings";
export declare class SettingsManager {
    private connection;
    private clientSupportsConfigRequests;
    private configurationChangeHandlers;
    private documentSettings;
    readonly defaultSettingsWithDescription: ExtensionSettingsWithDescription;
    private defaultSettings;
    globalSettings: ExtensionSettings;
    constructor(connection: Connection | null, clientSupportsConfigRequests: boolean);
    /**
     * Register a handler for configuration change on particular URI.
     *
     * Change detection is cache-based. If the client does not support the
     * configuration requests, all handlers will be fired.
     */
    onConfigurationChanged(uri: string, handler: {
        (): void;
    }): void;
    get(uri: string): Promise<ExtensionSettings>;
    handleDocumentClosed(uri: string): void;
    handleConfigurationChanged(params: DidChangeConfigurationParams): Promise<void>;
    /**
     * A recursive function to restructure the raw settings object similar to ExtensionSettings interface in order
     * to make it work with the code
     * @param settingsObject - settings object with `default` and `description` as keys
     * @returns settings - object with a structure similar to ExtensionSettings interface
     */
    private _settingsAdjustment;
}
