/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.codeInsight.dataflow.map.DfaMapInstance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyDataFlowKt;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.codeInsight.dataflow.scope.impl.ScopeVariableImpl;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyReachingDefsDfaInstance
implements DfaMapInstance<ScopeVariable> {
    public static final DFAMap<ScopeVariable> INITIAL_MAP = new DFAMap();
    public static final DFAMap<ScopeVariable> UNREACHABLE_MARKER = new DFAMap();
    private final TypeEvalContext myContext;

    public PyReachingDefsDfaInstance(@NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyReachingDefsDfaInstance.$$$reportNull$$$0(0);
        }
        this.myContext = typeEvalContext;
    }

    public DFAMap<ScopeVariable> fun(DFAMap<ScopeVariable> map, Instruction instruction) {
        CallInstruction callInstruction;
        if (map == UNREACHABLE_MARKER) {
            return map;
        }
        PsiElement element = instruction.getElement();
        if (element == null || ((PyFile)element.getContainingFile()).getLanguageLevel().isPython2()) {
            return PyReachingDefsDfaInstance.processReducedMap(map, instruction, element);
        }
        if (PyDataFlowKt.isUnreachableForInspection(element, this.myContext)) {
            return UNREACHABLE_MARKER;
        }
        if (instruction instanceof CallInstruction && (callInstruction = (CallInstruction)instruction).isNoReturnCall(this.myContext)) {
            return UNREACHABLE_MARKER;
        }
        DFAMap reducedMap = new DFAMap();
        for (Map.Entry entry : map.entrySet()) {
            PsiElement declaration;
            PyExceptPart exceptPart;
            ScopeVariable value = (ScopeVariable)entry.getValue();
            if (value.isParameter() && (exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(declaration = value.getDeclarations().iterator().next())) != null && !PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)element, (boolean)false)) continue;
            reducedMap.put((String)entry.getKey(), (Object)value);
        }
        return PyReachingDefsDfaInstance.processReducedMap((DFAMap<ScopeVariable>)reducedMap, instruction, element);
    }

    private static DFAMap<ScopeVariable> processReducedMap(DFAMap<ScopeVariable> map, Instruction instruction, PsiElement element) {
        if (element != null && element.getParent() instanceof PyTypeDeclarationStatement) {
            return map;
        }
        String name = null;
        if (instruction instanceof ReadWriteInstruction) {
            ReadWriteInstruction rwInstruction = (ReadWriteInstruction)instruction;
            if (rwInstruction.getAccess().isWriteAccess()) {
                name = ((ReadWriteInstruction)instruction).getName();
            } else if (rwInstruction.getAccess().isDeleteAccess() && instruction.getElement() instanceof PyReferenceExpression) {
                map = map.asWritable();
                map.remove(((ReadWriteInstruction)instruction).getName());
                return map;
            }
        } else if (element instanceof PyFunction) {
            name = ((PyFunction)element).getName();
        }
        if (name == null) {
            return map;
        }
        ScopeVariable variable = (ScopeVariable)map.get(name);
        PsiElement parameterScope = ScopeUtil.getParameterScope(element);
        if (parameterScope != null) {
            ScopeVariableImpl scopeVariable = new ScopeVariableImpl(name, true, element);
            map = map.asWritable();
            map.put(name, (Object)scopeVariable);
        } else {
            boolean isParameter = variable != null && variable.isParameter();
            ScopeVariableImpl scopeVariable = variable == null ? new ScopeVariableImpl(name, isParameter, element) : new ScopeVariableImpl(name, isParameter, variable.getDeclarations());
            map = map.asWritable();
            map.put(name, (Object)scopeVariable);
        }
        return map;
    }

    @NotNull
    public DFAMap<ScopeVariable> initial() {
        DFAMap<ScopeVariable> dFAMap = INITIAL_MAP;
        if (dFAMap == null) {
            PyReachingDefsDfaInstance.$$$reportNull$$$0(1);
        }
        return dFAMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/dataflow/PyReachingDefsDfaInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/dataflow/PyReachingDefsDfaInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

