/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.BooleanArrays;

public abstract class AbstractBooleanArrayAssert<SELF extends AbstractBooleanArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, boolean[], Boolean> {
    protected BooleanArrays arrays = BooleanArrays.instance();

    protected AbstractBooleanArrayAssert(boolean[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (boolean[])this.actual);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (boolean[])this.actual, expected);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, (boolean[])this.actual, boundary);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, (boolean[])this.actual, boundary);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, (boolean[])this.actual, boundary);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, (boolean[])this.actual, boundary);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, (boolean[])this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (boolean[])this.actual, other);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF contains(boolean ... values) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF contains(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContains(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsOnly(boolean ... values) {
        this.arrays.assertContainsOnly(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsOnly(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnly(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(boolean ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnlyOnce(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsSequence(boolean ... sequence) {
        this.arrays.assertContainsSequence(this.info, (boolean[])this.actual, sequence);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsSequence(Boolean[] sequence) {
        AbstractBooleanArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertContainsSequence(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(sequence));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsSubsequence(boolean ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (boolean[])this.actual, subsequence);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsSubsequence(Boolean[] subsequence) {
        AbstractBooleanArrayAssert.requireNonNullParameter(subsequence, "subsequence");
        this.arrays.assertContainsSubsequence(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(subsequence));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF contains(boolean value, Index index) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, value, index);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF doesNotContain(boolean ... values) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF doesNotContain(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF doesNotContain(boolean value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, value, index);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (boolean[])this.actual);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF startsWith(boolean ... sequence) {
        this.arrays.assertStartsWith(this.info, (boolean[])this.actual, sequence);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF startsWith(Boolean[] sequence) {
        AbstractBooleanArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertStartsWith(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(sequence));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF endsWith(boolean ... sequence) {
        this.arrays.assertEndsWith(this.info, (boolean[])this.actual, sequence);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF endsWith(Boolean[] sequence) {
        AbstractBooleanArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertEndsWith(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(sequence));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (boolean[])this.actual);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Boolean> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (boolean[])this.actual, comparator);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    @Deprecated(since="3", forRemoval=true)
    public final SELF usingElementComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }

    @Override
    @Deprecated(since="3", forRemoval=true)
    public final SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }

    public SELF containsExactly(boolean ... values) {
        this.arrays.assertContainsExactly(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsExactly(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactly(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(boolean ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsAnyOf(boolean ... values) {
        this.arrays.assertContainsAnyOf(this.info, (boolean[])this.actual, values);
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    public SELF containsAnyOf(Boolean[] values) {
        AbstractBooleanArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsAnyOf(this.info, (boolean[])this.actual, AbstractBooleanArrayAssert.toPrimitiveBooleanArray(values));
        return (SELF)((AbstractBooleanArrayAssert)this.myself);
    }

    private static boolean[] toPrimitiveBooleanArray(Boolean[] values) {
        boolean[] booleans = new boolean[values.length];
        IntStream.range(0, values.length).forEach(i -> {
            booleans[i] = values[i];
        });
        return booleans;
    }
}

