/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.ShortenOptions;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaExplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertScopeFunctionToParameter;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ScopeFunctionConversionInspectionKt;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionToParameter;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "analyzeLambda", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "replacements", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "postprocessLambda", "intellij.kotlin.codeInsight.inspections"})
public final class ConvertScopeFunctionToParameter
extends ConvertScopeFunctionFix {
    public ConvertScopeFunctionToParameter(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }

    @Override
    protected void analyzeLambda(@NotNull KaSession $this$analyzeLambda, @NotNull KtLambdaArgument lambda2, @NotNull ReplacementCollection replacements) {
        String parameterName2;
        KtFunctionLiteral functionLiteral;
        Intrinsics.checkNotNullParameter((Object)$this$analyzeLambda, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Project project = lambda2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
        Object object = functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
        if (ScopeFunctionConversionInspectionKt.needUniqueNameForParameter($this$analyzeLambda, lambda2)) {
            v3 = ScopeFunctionConversionInspectionKt.access$findUniqueParameterName($this$analyzeLambda, lambda2);
        } else {
            String string = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
            Intrinsics.checkNotNull((Object)string);
            v3 = parameterName2 = string;
        }
        if (functionLiteral != null && ScopeFunctionConversionInspectionKt.needUniqueNameForParameter($this$analyzeLambda, lambda2)) {
            replacements.setCreateParameter((Function1<? super KtPsiFactory, ? extends PsiElement>)((Function1)arg_0 -> ConvertScopeFunctionToParameter.analyzeLambda$lambda$0(functionLiteral, parameterName2, arg_0)));
        }
        lambda2.accept((PsiElementVisitor)new KtTreeVisitorVoid($this$analyzeLambda, replacements, functionLiteral, factory2, parameterName2){
            final /* synthetic */ KaSession $this_analyzeLambda;
            final /* synthetic */ ReplacementCollection $replacements;
            final /* synthetic */ KtFunctionLiteral $functionLiteral;
            final /* synthetic */ KtPsiFactory $factory;
            final /* synthetic */ String $parameterName;
            {
                this.$this_analyzeLambda = $receiver;
                this.$replacements = $replacements;
                this.$functionLiteral = $functionLiteral;
                this.$factory = $factory;
                this.$parameterName = $parameterName;
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                KaLifetimeOwner kaLifetimeOwner;
                block12: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        super.visitSimpleNameExpression(expression);
                        if (expression instanceof KtOperationReferenceExpression) {
                            return;
                        }
                        kaLifetimeOwner = this.$this_analyzeLambda.resolveToCall((KtElement)expression);
                        if (kaLifetimeOwner == null) break block11;
                        KaCallInfo $this$successfulCallOrNull$iv = kaLifetimeOwner;
                        boolean $i$f$successfulCallOrNull = false;
                        KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                        KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                        if (!(kaCall instanceof KaCallableMemberCall)) {
                            kaCall = null;
                        }
                        if ((kaLifetimeOwner = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)kaCall))) != null) break block12;
                    }
                    return;
                }
                KaLifetimeOwner resolvedCall = kaLifetimeOwner;
                KaReceiverValue dispatchReceiver = resolvedCall.getPartiallyAppliedSymbol().getDispatchReceiver();
                KaReceiverValue extensionReceiver = resolvedCall.getPartiallyAppliedSymbol().getExtensionReceiver();
                if (analyzeLambda.2.visitSimpleNameExpression$isReceiverFromFunctionLiteral(this.$functionLiteral, this.$this_analyzeLambda, dispatchReceiver) || analyzeLambda.2.visitSimpleNameExpression$isReceiverFromFunctionLiteral(this.$functionLiteral, this.$this_analyzeLambda, extensionReceiver)) {
                    PsiElement parent = expression.getParent();
                    if (parent instanceof KtCallExpression && Intrinsics.areEqual((Object)expression, (Object)((KtCallExpression)parent).getCalleeExpression())) {
                        PsiElement psiElement = ((KtCallExpression)parent).getParent();
                        KtQualifiedExpression ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
                        if (!((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtThisExpression)) {
                            this.$replacements.add(parent, (arg_0, arg_1) -> analyzeLambda.2.visitSimpleNameExpression$lambda$0(this.$factory, this.$parameterName, arg_0, arg_1));
                        }
                    } else if (!(parent instanceof KtQualifiedExpression) || !(((KtQualifiedExpression)parent).getReceiverExpression() instanceof KtThisExpression)) {
                        String referencedName = expression.getReferencedName();
                        this.$replacements.add((PsiElement)expression, (arg_0, arg_1) -> analyzeLambda.2.visitSimpleNameExpression$lambda$1(this.$parameterName, referencedName, arg_0, arg_1));
                    }
                }
            }

            public void visitThisExpression(KtThisExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                KtReferenceExpression ktReferenceExpression = expression.getInstanceReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"getInstanceReference(...)");
                if (Intrinsics.areEqual((Object)ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression).resolve(), (Object)this.$functionLiteral)) {
                    this.$replacements.add((PsiElement)expression, (arg_0, arg_1) -> analyzeLambda.2.visitThisExpression$lambda$2(this.$parameterName, arg_0, arg_1));
                }
            }

            private static final boolean visitSimpleNameExpression$isReceiverFromFunctionLiteral(KtFunctionLiteral functionLiteral, KaSession $this_analyzeLambda, KaReceiverValue receiver2) {
                if (receiver2 instanceof KaExplicitReceiverValue) {
                    KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)((KaExplicitReceiverValue)receiver2).getExpression()));
                    return Intrinsics.areEqual((Object)(ktReference != null ? ktReference.resolve() : null), (Object)functionLiteral);
                }
                if (receiver2 instanceof KaImplicitReceiverValue) {
                    KaSymbol kaSymbol = UtilsKt.getThisReceiverOwner($this_analyzeLambda, receiver2);
                    return Intrinsics.areEqual((Object)(kaSymbol != null ? kaSymbol.getPsi() : null), (Object)functionLiteral);
                }
                return false;
            }

            private static final PsiElement visitSimpleNameExpression$lambda$0(KtPsiFactory $factory, String $parameterName, KtPsiFactory $this$add, KtCallExpression element) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object[] objectArray = new Object[]{$parameterName, element};
                return (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)$factory, (String)"$0.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            }

            private static final PsiElement visitSimpleNameExpression$lambda$1(String $parameterName, String $referencedName, KtPsiFactory $this$add, KtSimpleNameExpression it) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (PsiElement)$this$add.createExpression($parameterName + "." + $referencedName);
            }

            private static final PsiElement visitThisExpression$lambda$2(String $parameterName, KtPsiFactory $this$add, KtThisExpression it) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (PsiElement)$this$add.createExpression($parameterName);
            }
        });
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        ShortenUtilsKt.shortenReferences$default((KtElement)lambda2, new ShortenOptions(false, true), null, null, 12, null);
    }

    private static final KtParameter analyzeLambda$lambda$0(KtFunctionLiteral $functionLiteral, String $parameterName, KtPsiFactory ktPsiFactory) {
        Intrinsics.checkNotNullParameter((Object)ktPsiFactory, (String)"<this>");
        KtParameterList lambdaParameterList = KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)$functionLiteral);
        List list2 = ktPsiFactory.createLambdaParameterList($parameterName).getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        KtParameter parameterToAdd = (KtParameter)CollectionsKt.first((List)list2);
        List list3 = lambdaParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getParameters(...)");
        return lambdaParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull((List)list3));
    }
}

