/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertUnsafeCastToUnsafeCastCallIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertUnsafeCastToUnsafeCastCallIntention
extends SelfTargetingIntention<KtBinaryExpressionWithTypeRHS> {
    public ConvertUnsafeCastToUnsafeCastCallIntention() {
        super(KtBinaryExpressionWithTypeRHS.class, KotlinBundle.messagePointer((String)"convert.to.unsafecast.call", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpressionWithTypeRHS element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)element))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)element.getOperationReference().getReferencedNameElementType(), (Object)KtTokens.AS_KEYWORD)) {
            return false;
        }
        KtTypeReference ktTypeReference = element.getRight();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference right = ktTypeReference;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)right, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)right);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        if (TypeUtils.isNullableType((KotlinType)type2)) {
            return false;
        }
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)element.getLeft().getText(), (String)"getText(...)");
        Intrinsics.checkNotNullExpressionValue((Object)right.getText(), (String)"getText(...)");
        this.setTextGetter(KotlinBundle.messagePointer((String)"convert.to.0.unsafecast.1", (Object[])objectArray));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpressionWithTypeRHS element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtTypeReference ktTypeReference = element.getRight();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference right = ktTypeReference;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)element.getLeft(), (String)"getLeft(...)");
        objectArray[1] = right;
        KtExpression newExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0.unsafeCast<$1>()", (Object[])objectArray, (boolean)false, (int)4, null);
        element.replace((PsiElement)newExpression);
    }
}

