/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getSourceMap", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "findSourceMap", "parseSourceMap", "bytecode", "", "findCompiledModuleClass", "module", "Lcom/intellij/openapi/module/Module;", "findLibraryClass", "composeTopLevelClassNameVariants", "", "", "Companion", "intellij.kotlin.jvm.debugger.base.util"})
@SourceDebugExtension(value={"SMAP\nKotlinSourceMapCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class KotlinSourceMapCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public KotlinSourceMapCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final SMAP getSourceMap(@NotNull VirtualFile file, @NotNull JvmClassName jvmName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)this.project)};
        Object[] dependencies = objectArray;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)CacheUtilsKt.cacheByClass(this.project, KotlinSourceMapCache.class, Arrays.copyOf(dependencies, dependencies.length), KotlinSourceMapCache::getSourceMap$lambda$0);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"org/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$getSourceMap$Key", "", "path", "", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;)V", "getPath", "()Ljava/lang/String;", "getJvmName", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "component1", "component2", "copy", "(Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;)Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$getSourceMap$Key;", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.jvm.debugger.base.util"})
        public final class Key {
            private final String path;
            private final JvmClassName jvmName;

            public Key(String path2, JvmClassName jvmName) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
                this.path = path2;
                this.jvmName = jvmName;
            }

            public final String getPath() {
                return this.path;
            }

            public final JvmClassName getJvmName() {
                return this.jvmName;
            }

            public final String component1() {
                return this.path;
            }

            public final JvmClassName component2() {
                return this.jvmName;
            }

            public final Key copy(String path2, JvmClassName jvmName) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
                return new Key(path2, jvmName);
            }

            public static /* synthetic */ Key copy$default(Key key, String string, JvmClassName jvmClassName, int n, Object object) {
                if ((n & 1) != 0) {
                    string = key.path;
                }
                if ((n & 2) != 0) {
                    jvmClassName = key.jvmName;
                }
                return key.copy(string, jvmClassName);
            }

            public String toString() {
                return "Key(path=" + this.path + ", jvmName=" + this.jvmName + ")";
            }

            public int hashCode() {
                int result2 = this.path.hashCode();
                result2 = result2 * 31 + this.jvmName.hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Key)) {
                    return false;
                }
                Key key = (Key)other;
                if (!Intrinsics.areEqual((Object)this.path, (Object)key.path)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.jvmName, (Object)key.jvmName);
            }
        }
        Key key = new Key(string, jvmName);
        return ((Optional)cache2.get(key, arg_0 -> KotlinSourceMapCache.getSourceMap$lambda$1(this, file, jvmName, arg_0))).orElse(null);
    }

    private final SMAP findSourceMap(VirtualFile file, JvmClassName jvmName) {
        SMAP sMAP;
        byte[] bytecode;
        if (bytecode != null) {
            byte[] p0 = bytecode = SourceKindFilterUtils.matches(RootKindFilter.projectSources, this.project, file) ? this.findCompiledModuleClass(file, jvmName) : (byte[])(SourceKindFilterUtils.matches(RootKindFilter.librarySources, this.project, file) ? this.findLibraryClass(jvmName) : null);
            boolean bl = false;
            sMAP = this.parseSourceMap(p0);
        } else {
            sMAP = null;
        }
        return sMAP;
    }

    private final SMAP parseSourceMap(byte[] bytecode) {
        SMAP sMAP;
        Ref.ObjectRef debugInfo = new Ref.ObjectRef();
        new ClassReader(bytecode).accept(new ClassVisitor((Ref.ObjectRef<String>)debugInfo){
            final /* synthetic */ Ref.ObjectRef<String> $debugInfo;
            {
                this.$debugInfo = $debugInfo;
                super(589824);
            }

            public void visitSource(String source, String debug) {
                this.$debugInfo.element = debug;
            }
        }, 0);
        String string = (String)debugInfo.element;
        if (string != null) {
            String string2 = string;
            SMAPParser sMAPParser = SMAPParser.INSTANCE;
            String p0 = string2;
            boolean bl = false;
            sMAP = sMAPParser.parseOrNull(p0);
        } else {
            sMAP = null;
        }
        return sMAP;
    }

    private final byte[] findCompiledModuleClass(VirtualFile file, JvmClassName jvmName) {
        Module module = ProjectFileIndex.getInstance((Project)this.project).getModuleForFile(file);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Object object = this.findCompiledModuleClass(module2, jvmName);
        if (object != null) {
            byte[] it = object;
            boolean bl = false;
            return it;
        }
        object = KotlinFacetUtils.getImplementingModules(module2).iterator();
        while (object.hasNext()) {
            Module implementingModule = (Module)object.next();
            byte[] byArray = this.findCompiledModuleClass(implementingModule, jvmName);
            if (byArray == null) continue;
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final byte[] findCompiledModuleClass(Module module, JvmClassName jvmName) {
        Module[] moduleArray = new Module[]{module};
        String[] stringArray = CompilerPaths.getOutputPaths((Module[])moduleArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getOutputPaths(...)");
        for (String outputRoot : ArraysKt.toList((Object[])stringArray)) {
            String[] stringArray2 = new String[]{jvmName.getInternalName() + ".class"};
            Path path2 = Path.of(outputRoot, stringArray2);
            Intrinsics.checkNotNull((Object)path2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            try {
                byte[] byArray = Files.readAllBytes(path2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                return byArray;
            }
            catch (IOException e) {
                LOG.debug("Can't read class file " + jvmName, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private final byte[] findLibraryClass(JvmClassName jvmName) {
        String string = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        String classFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(this.project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        VirtualFileFinder fileFinder = virtualFileFinderFactory.create(globalSearchScope);
        for (String topLevelClassName : this.composeTopLevelClassNameVariants(jvmName)) {
            VirtualFile classFile;
            VirtualFile variantClassFile = fileFinder.findVirtualFileWithHeader(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)topLevelClassName, (boolean)false, (int)2, null));
            if (variantClassFile != null && Intrinsics.areEqual((Object)topLevelClassName, (Object)jvmName.getInternalName())) {
                return KotlinSourceMapCache.findLibraryClass$readFile(jvmName, variantClassFile);
            }
            VirtualFile virtualFile = variantClassFile;
            Object packageDir = virtualFile != null ? virtualFile.getParent() : null;
            if (packageDir == null || (classFile = packageDir.findChild(classFileName + ".class")) == null) continue;
            return KotlinSourceMapCache.findLibraryClass$readFile(jvmName, classFile);
        }
        return null;
    }

    private final List<String> composeTopLevelClassNameVariants(JvmClassName jvmName) {
        List list2;
        List $this$composeTopLevelClassNameVariants_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        String string = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        String jdiName = JvmNameUtilsKt.internalNameToFqn(string);
        int index2 = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)1, (boolean)false, (int)4, null);
        while (index2 >= 0) {
            $this$composeTopLevelClassNameVariants_u24lambda_u240.add(StringsKt.take((String)jdiName, (int)index2));
            index2 = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)(index2 + 1), (boolean)false, (int)4, null);
        }
        String string2 = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        $this$composeTopLevelClassNameVariants_u24lambda_u240.add(string2);
        return CollectionsKt.build((List)list2);
    }

    private static final ConcurrentFactoryCache getSourceMap$lambda$0() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        ConcurrentMap storage = concurrentMap;
        return new ConcurrentFactoryCache(storage);
    }

    private static final Optional getSourceMap$lambda$1(KotlinSourceMapCache this$0, VirtualFile $file, JvmClassName $jvmName, getSourceMap.Key it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Optional.ofNullable(this$0.findSourceMap($file, $jvmName));
    }

    private static final byte[] findLibraryClass$readFile(JvmClassName $jvmName, VirtualFile file) {
        try {
            return file.contentsToByteArray(false);
        }
        catch (IOException e) {
            LOG.debug("Can't read class file " + $jvmName, (Throwable)e);
            return null;
        }
    }

    static {
        Logger logger = Logger.getInstance(KotlinSourceMapCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jvm.debugger.base.util"})
    @SourceDebugExtension(value={"SMAP\nKotlinSourceMapCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n30#2,2:157\n*S KotlinDebug\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion\n*L\n40#1:157,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSourceMapCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinSourceMapCache> serviceClass$iv = KotlinSourceMapCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinSourceMapCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

