/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.tools.GenerateSchemaFromInstanceDocumentDialog;
import com.intellij.xml.tools.XmlBeansBundle;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class GenerateSchemaFromInstanceDocumentAction
extends AnAction {
    GenerateSchemaFromInstanceDocumentAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateSchemaFromInstanceDocumentAction.$$$reportNull$$$0(0);
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = GenerateSchemaFromInstanceDocumentAction.isAcceptableFile(file);
        e.getPresentation().setEnabled(enabled);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GenerateSchemaFromInstanceDocumentAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateSchemaFromInstanceDocumentAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GenerateSchemaFromInstanceDocumentDialog dialog = new GenerateSchemaFromInstanceDocumentDialog(project, file);
        dialog.setOkAction(() -> GenerateSchemaFromInstanceDocumentAction.doAction(project, dialog));
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAction(Project project, GenerateSchemaFromInstanceDocumentDialog dialog) {
        VirtualFile xsdVFile;
        boolean renamed;
        FileDocumentManager.getInstance().saveAllDocuments();
        String url = dialog.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("file.doesnt.exist", url), (String)XmlBeansBundle.message("error", new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("file.doesnt.exist", url), (String)XmlBeansBundle.message("error", new Object[0]));
            return;
        }
        @NonNls LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("-design");
        parameters.add(Holder.DESIGN_TYPES.get(dialog.getDesignType()));
        parameters.add("-simple-content-types");
        parameters.add(Holder.CONTENT_TYPES.get(dialog.getSimpleContentType()));
        parameters.add("-enumerations");
        String enumLimit = dialog.getEnumerationsLimit();
        parameters.add("0".equals(enumLimit) ? "never" : enumLimit);
        parameters.add("-outDir");
        String dirPath = relativeFileDir.getPath();
        parameters.add(dirPath);
        File expectedSchemaFile = new File(dirPath + File.separator + relativeFile.getName() + "0.xsd");
        if (expectedSchemaFile.exists() && !expectedSchemaFile.delete()) {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("cant.delete.file", expectedSchemaFile.getPath()), (String)XmlBeansBundle.message("error", new Object[0]));
            return;
        }
        parameters.add("-outPrefix");
        parameters.add(relativeFile.getName());
        parameters.add(url);
        File xsd = new File(dirPath + File.separator + dialog.getTargetSchemaName());
        VirtualFile xsdFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd);
        if (xsdFile != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    xsdFile.delete(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        SecurityManager old = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkExit(int status) {
                    throw new SecurityException();
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            Inst2Xsd.main(ArrayUtilRt.toStringArray(parameters));
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("xml2xsd.generator.error.message", new Object[0]), (String)XmlBeansBundle.message("xml2xsd.generator.error", new Object[0]));
            return;
        }
        finally {
            System.setSecurityManager(old);
        }
        if (expectedSchemaFile.exists() && !(renamed = expectedSchemaFile.renameTo(xsd))) {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("cant.rename.file", expectedSchemaFile.getPath(), xsd.getPath()), (String)XmlBeansBundle.message("error", new Object[0]));
        }
        if ((xsdVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd)) != null) {
            FileEditorManager.getInstance((Project)project).openFile(xsdVFile, true);
        } else {
            Messages.showErrorDialog((Project)project, (String)XmlBeansBundle.message("xml2xsd.generator.error.message", new Object[0]), (String)XmlBeansBundle.message("xml2xsd.generator.error", new Object[0]));
        }
    }

    public static boolean isAcceptableFile(VirtualFile file) {
        return file != null && "xml".equalsIgnoreCase(file.getExtension());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/tools/GenerateSchemaFromInstanceDocumentAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/tools/GenerateSchemaFromInstanceDocumentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final Map<String, String> DESIGN_TYPES = new HashMap<String, String>();
        private static final Map<String, String> CONTENT_TYPES;

        private Holder() {
        }

        static {
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getLocalElementsGlobalComplexTypes(), "vb");
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getLocalElementsTypes(), "ss");
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getGlobalElementsLocalTypes(), "rd");
            CONTENT_TYPES = new HashMap<String, String>();
            CONTENT_TYPES.put("smart", "smart");
            CONTENT_TYPES.put("string", "string");
        }
    }
}

