/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;

public abstract class LanguageWithModel
extends Language
implements AutoCloseable {
    private final AtomicBoolean noLmWarningPrinted = new AtomicBoolean();
    private LanguageModel languageModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel != null) {
            return this.languageModel;
        }
        LanguageWithModel languageWithModel = this;
        synchronized (languageWithModel) {
            if (this.languageModel != null) {
                return this.languageModel;
            }
            this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
            return this.languageModel;
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
            this.languageModel = null;
        }
    }

    protected LanguageModel initLanguageModel(File indexDir, LanguageModel languageModel) {
        if (languageModel == null) {
            File topIndexDir = new File(indexDir, this.getShortCode());
            if (topIndexDir.exists()) {
                languageModel = new LuceneLanguageModel(topIndexDir);
            } else if (this.noLmWarningPrinted.compareAndSet(false, true)) {
                System.err.println("WARN: ngram index dir " + String.valueOf(topIndexDir) + " not found for " + this.getName());
            }
        }
        return languageModel;
    }
}

