/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinRawStringTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinRawStringTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (c != '\"') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset < 2) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement openQuote = file.findElementAt(offset - 2);
        if (openQuote == null || !(openQuote instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)openQuote).getElementType(), (Object)KtTokens.OPEN_QUOTE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement closeQuote = file.findElementAt(offset - 1);
        if (closeQuote == null || !(closeQuote instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)closeQuote).getElementType(), (Object)KtTokens.CLOSING_QUOTE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!Intrinsics.areEqual((Object)((LeafPsiElement)closeQuote).getText(), (Object)"\"")) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        editor.getDocument().insertString(offset, (CharSequence)"\"\"\"\"");
        editor.getCaretModel().getCurrentCaret().moveToOffset(offset + 1);
        return TypedHandlerDelegate.Result.STOP;
    }
}

