/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json.async;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import tools.jackson.core.JacksonException;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.async.ByteBufferFeeder;
import tools.jackson.core.async.NonBlockingInputFeeder;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;

public class NonBlockingByteBufferJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteBufferFeeder {
    private ByteBuffer _inputBuffer = ByteBuffer.wrap(NO_BYTES);

    public NonBlockingByteBufferJsonParser(ObjectReadContext readCtxt, IOContext ctxt, int stdFeatures, int formatReadFeatures, ByteQuadsCanonicalizer sym) {
        super(readCtxt, ctxt, stdFeatures, formatReadFeatures, sym);
    }

    @Override
    public NonBlockingInputFeeder nonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(ByteBuffer byteBuffer) throws JacksonException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        int start = byteBuffer.position();
        int end = byteBuffer.limit();
        if (end < start) {
            this._reportError("Input end (%d) may not be before start (%d)", end, start);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, cannot feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
        this._currInputRowStart = start - (this._inputEnd - this._currInputRowStart);
        this._currBufferStart = start;
        this._inputBuffer = byteBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._origBufferLen = end - start;
    }

    @Override
    public int releaseBuffered(OutputStream out) throws JacksonException {
        int avail = this._inputEnd - this._inputPtr;
        if (avail > 0) {
            WritableByteChannel channel = Channels.newChannel(out);
            try {
                channel.write(this._inputBuffer);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        return avail;
    }

    @Override
    protected byte getNextSignedByteFromBuffer() {
        return this._inputBuffer.get(this._inputPtr++);
    }

    @Override
    protected int getNextUnsignedByteFromBuffer() {
        return this._inputBuffer.get(this._inputPtr++) & 0xFF;
    }

    @Override
    protected byte getByteFromBuffer(int ptr) {
        return this._inputBuffer.get(ptr);
    }
}

