/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingUtils;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFloat})
public final class FloatBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = FloatBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FloatBuiltinsFactory.getFactories();
    }

    public static double asDouble(boolean right) {
        return right ? 1.0 : 0.0;
    }

    private static double castToDoubleChecked(Node inliningTarget, Object obj, CastToJavaDoubleNode cast) {
        try {
            return cast.execute(inliningTarget, obj);
        }
        catch (CannotCastException e) {
            throw FloatBuiltins.raiseWrongSelf(inliningTarget, obj);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseWrongSelf(Node inliningTarget, Object obj) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "float", obj);
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends AbstractNumericUnaryBuiltin {
        GetNewArgsNode() {
        }

        @Override
        protected Object op(double self) {
            PythonLanguage language = PythonLanguage.get(this);
            return PFactory.createTuple(language, new Object[]{PFactory.createFloat(language, self)});
        }
    }

    @Builtin(name="is_integer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsIntegerNode
    extends AbstractNumericUnaryBuiltin {
        IsIntegerNode() {
        }

        @Override
        protected Object op(double value) {
            return Double.isFinite(value) && (double)((long)value) == value;
        }
    }

    @Builtin(name="__getformat__", minNumOfPositionalArgs=2, isClassmethod=true, parameterNames={"$cls", "typestr"})
    @ArgumentClinic(name="typestr", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class GetFormatNode
    extends PythonBinaryClinicBuiltinNode {
        private static final TruffleString T_FLOAT = PythonUtils.tsLiteral("float");
        private static final TruffleString T_DOUBLE = PythonUtils.tsLiteral("double");
        private static final TruffleString T_UNKNOWN = PythonUtils.tsLiteral("unknown");
        private static final TruffleString T_IEEE_LITTLE = PythonUtils.tsLiteral("IEEE, little-endian");
        private static final TruffleString T_IEEE_BIG = PythonUtils.tsLiteral("IEEE, big-endian");

        GetFormatNode() {
        }

        private static TruffleString getDetectedEndianess() {
            try {
                ByteOrder byteOrder = ByteOrder.nativeOrder();
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return T_IEEE_BIG;
                }
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return T_IEEE_LITTLE;
                }
            }
            catch (Error error) {
                // empty catch block
            }
            return T_UNKNOWN;
        }

        protected boolean isValidTypeStr(TruffleString typeStr, TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)typeStr, (AbstractTruffleString)T_FLOAT, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)typeStr, (AbstractTruffleString)T_DOUBLE, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"isValidTypeStr(typeStr, equalNode)"}, limit="1")
        static TruffleString getFormat(Object cls, TruffleString typeStr, @Cached TruffleString.EqualNode equalNode) {
            return GetFormatNode.getDetectedEndianess();
        }

        @Fallback
        static TruffleString getFormat(Object cls, Object typeStr, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ARG_D_MUST_BE_S_OR_S, "__getformat__()", 1, "double", "float");
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FloatBuiltinsClinicProviders.GetFormatNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1, doc="Returns self, the complex conjugate of any float.")
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends FloatNode {
        ConjugateNode() {
        }
    }

    @Builtin(name="as_integer_ratio", parameterNames={"x"})
    @GenerateNodeFactory
    static abstract class AsIntegerRatio
    extends PythonUnaryBuiltinNode {
        AsIntegerRatio() {
        }

        @Specialization
        static PTuple get(Object selfObj, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile nanProfile, @Cached InlinedConditionProfile infProfile, @Cached PRaiseNode raiseNode) {
            double self = FloatBuiltins.castToDoubleChecked(inliningTarget, selfObj, cast);
            if (nanProfile.profile(inliningTarget, Double.isNaN(self))) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_CONVERT_S_TO_INT_RATIO, "NaN");
            }
            if (infProfile.profile(inliningTarget, Double.isInfinite(self))) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_CONVERT_S_TO_INT_RATIO, "Infinity");
            }
            int exponent = 0;
            double mantissa = 0.0;
            if (self != 0.0 && self != -0.0) {
                boolean neg = false;
                mantissa = self;
                if (mantissa < 0.0) {
                    mantissa = -mantissa;
                    neg = true;
                }
                if (mantissa >= 1.0) {
                    while (mantissa >= 1.0) {
                        ++exponent;
                        mantissa /= 2.0;
                    }
                } else if (mantissa < 0.5) {
                    while (mantissa < 0.5) {
                        --exponent;
                        mantissa *= 2.0;
                    }
                }
                if (neg) {
                    mantissa = -mantissa;
                }
            }
            return PFactory.createTuple(language, AsIntegerRatio.countIt(language, mantissa, exponent));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] countIt(PythonLanguage language, double mantissa, int exponent) {
            double m = mantissa;
            int e = exponent;
            for (int i = 0; i < 300 && Double.compare(m, Math.floor(m)) != 0; ++i) {
                m *= 2.0;
                --e;
            }
            BigInteger numerator = BigInteger.valueOf(Double.valueOf(m).longValue());
            BigInteger denominator = BigInteger.ONE;
            BigInteger py_exponent = denominator.shiftLeft(Math.abs(e));
            if (e > 0) {
                numerator = numerator.multiply(py_exponent);
            } else {
                denominator = py_exponent;
            }
            if (numerator.bitLength() < 64 && denominator.bitLength() < 64) {
                return new Object[]{numerator.longValue(), denominator.longValue()};
            }
            return new Object[]{PFactory.createInt(language, numerator), PFactory.createInt(language, denominator)};
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonUnaryBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static double get(Object self) {
            return 0.0;
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends FloatNode {
        RealNode() {
        }
    }

    @Builtin(name="__ceil__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CeilNode
    extends PythonUnaryBuiltinNode {
        CeilNode() {
        }

        @Specialization
        static Object ceil(Object self, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.ceil(FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast)));
        }
    }

    @Builtin(name="__floor__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FloorNode
    extends PythonUnaryBuiltinNode {
        FloorNode() {
        }

        @Specialization
        static Object floor(Object self, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.floor(FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast)));
        }
    }

    @Slot(value=Slot.SlotKind.nb_negative, isComplex=true)
    @GenerateNodeFactory
    static abstract class NegNode
    extends AbstractNumericUnaryBuiltin {
        NegNode() {
        }

        @Override
        protected Object op(double arg) {
            return -arg;
        }
    }

    @Slot(value=Slot.SlotKind.nb_positive, isComplex=true)
    @GenerateNodeFactory
    static abstract class PosNode
    extends FloatNode {
        PosNode() {
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare)
    @GenerateNodeFactory
    @GenerateUncached
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        static Object doIt(Object left, Object right, RichCmpOp op, @Bind Node inliningTarget, @Cached ComparisonHelperNode comparisonHelperNode) {
            return comparisonHelperNode.execute(inliningTarget, left, right, op);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @TypeSystemReference(value=FloatUtils.PFloatUnboxing.class)
    public static abstract class ComparisonHelperNode
    extends Node {
        abstract Object execute(Node var1, Object var2, Object var3, RichCmpOp var4);

        @Specialization
        static boolean doDD(double a, double b, RichCmpOp op) {
            return op.compare(a, b);
        }

        @Specialization
        static boolean doDI(double a, int b, RichCmpOp op) {
            return op.compare(a, (double)b);
        }

        @Specialization(guards={"check.execute(inliningTarget, bObj)"}, replaces={"doDD"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static boolean doOO(Node inliningTarget, Object aObj, Object bObj, RichCmpOp op, @Cached PyFloatCheckNode check, @Cached.Exclusive @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            double b = FloatBuiltins.castToDoubleChecked(inliningTarget, bObj, cast);
            return op.compare(a, b);
        }

        @Specialization(replaces={"doDI"})
        @HostCompilerDirectives.InliningCutoff
        static boolean doOI(Node inliningTarget, Object aObj, int b, RichCmpOp op, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return op.compare(a, (double)b);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doOL(Node inliningTarget, Object aObj, long b, RichCmpOp op, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            double a1 = ComparisonHelperNode.compareDoubleToLong(inliningTarget, a, b, longFitsToDoubleProfile);
            return op.compare(a1, 0.0);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doOPInt(Node inliningTarget, Object aObj, PInt b, RichCmpOp op, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            double a1 = ComparisonHelperNode.compareDoubleToLargeInt(a, b);
            return op.compare(a1, 0.0);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doOB(Node inliningTarget, Object aObj, boolean b, RichCmpOp op, @Cached.Shared @Cached CastToJavaDoubleNode cast) {
            double a = FloatBuiltins.castToDoubleChecked(inliningTarget, aObj, cast);
            return op.compare(a, b ? 1.0 : 0.0);
        }

        @Fallback
        static PNotImplemented fallback(Object a, Object b, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        public static double compareDoubleToLong(Node inliningTarget, double v, long w, InlinedConditionProfile wFitsInDoubleProfile) {
            if (wFitsInDoubleProfile.profile(inliningTarget, w > -281474976710656L && w < 0x1000000000000L)) {
                return v - (double)w;
            }
            return ComparisonHelperNode.compareUsingBigDecimal(v, PInt.longToBigInteger(w));
        }

        public static double compareDoubleToLargeInt(double v, PInt w) {
            int wsign;
            int vsign;
            if (!Double.isFinite(v)) {
                return v;
            }
            int n = v == 0.0 ? 0 : (vsign = v < 0.0 ? -1 : 1);
            int n2 = w.isZero() ? 0 : (wsign = w.isNegative() ? -1 : 1);
            if (vsign != wsign) {
                return vsign - wsign;
            }
            if (w.bitLength() <= 48) {
                return v - w.doubleValue();
            }
            return ComparisonHelperNode.compareUsingBigDecimal(v, w.getValue());
        }

        @CompilerDirectives.TruffleBoundary
        private static double compareUsingBigDecimal(double v, BigInteger w) {
            if (!Double.isFinite(v)) {
                return v;
            }
            return new BigDecimal(v).compareTo(new BigDecimal(w));
        }
    }

    @Builtin(name="__round__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RoundNode
    extends PythonBinaryBuiltinNode {
        RoundNode() {
        }

        @CompilerDirectives.TruffleBoundary
        private static double op(double x, int n) {
            float nlog2_10 = 3.3219f * (float)n;
            int b = Math.getExponent(x);
            if (nlog2_10 > (float)(52 - b)) {
                return x;
            }
            if (nlog2_10 < (float)(-(b + 2))) {
                return Math.copySign(0.0, x);
            }
            BigDecimal xx = new BigDecimal(x);
            BigDecimal rr = xx.setScale(n, RoundingMode.HALF_EVEN);
            return rr.doubleValue();
        }

        @Specialization
        static double round(double x, int n, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (Double.isNaN(x) || Double.isInfinite(x) || x == 0.0) {
                return x;
            }
            double d = RoundNode.op(x, n);
            if (Double.isInfinite(d)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.ROUNDED_VALUE_TOO_LARGE);
            }
            return d;
        }

        @Specialization(guards={"!isPNone(n)"})
        static Object round(VirtualFrame frame, Object x, Object n, @Bind Node inliningTarget, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return RoundNode.round(FloatBuiltins.castToDoubleChecked(inliningTarget, x, cast), asSizeNode.executeLossy((Frame)frame, inliningTarget, n), inliningTarget, raiseNode);
        }

        @Specialization
        static Object round(Object xObj, PNone none, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached CastToJavaDoubleNode cast, @Cached InlinedConditionProfile nanProfile, @Cached InlinedConditionProfile infProfile, @Cached InlinedConditionProfile isLongProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            double x = FloatBuiltins.castToDoubleChecked(inliningTarget, xObj, cast);
            if (nanProfile.profile(inliningTarget, Double.isNaN(x))) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANNOT_CONVERT_S_TO_INT, "float NaN");
            }
            if (infProfile.profile(inliningTarget, Double.isInfinite(x))) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_CONVERT_S_TO_INT, "float infinity");
            }
            double result = RoundNode.round(x, 0, inliningTarget, raiseNode);
            if (isLongProfile.profile(inliningTarget, result > 9.223372036854776E18 || result < -9.223372036854776E18)) {
                return PFactory.createInt(language, RoundNode.toBigInteger(result));
            }
            return (long)result;
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigInteger(double d) {
            return BigDecimal.valueOf(d).toBigInteger();
        }
    }

    @Slot(value=Slot.SlotKind.nb_true_divide, isComplex=true)
    @GenerateNodeFactory
    static abstract class DivNode
    extends AbstractNumericBinaryBuiltin {
        DivNode() {
        }

        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return left / right;
        }
    }

    @Slot(value=Slot.SlotKind.nb_remainder, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ModNode
    extends AbstractNumericBinaryBuiltin {
        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return ModNode.mod(left, right);
        }

        public static double mod(double left, double right) {
            double mod = left % right;
            if (mod != 0.0) {
                if (right < 0.0 != mod < 0.0) {
                    mod += right;
                }
            } else {
                mod = right < 0.0 ? -0.0 : 0.0;
            }
            return mod;
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HexNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private static String makeHexNumber(double value) {
            if (Double.isNaN(value)) {
                return "nan";
            }
            if (Double.POSITIVE_INFINITY == value) {
                return "inf";
            }
            if (Double.NEGATIVE_INFINITY == value) {
                return "-inf";
            }
            if (Double.compare(value, 0.0) == 0) {
                return "0x0.0p+0";
            }
            if (Double.compare(value, -0.0) == 0) {
                return "-0x0.0p+0";
            }
            String result = Double.toHexString(value);
            int length = result.length();
            boolean start_exponent = false;
            StringBuilder sb = new StringBuilder(length + 1);
            int padding = value > 0.0 ? 17 : 18;
            for (int i = 0; i < length; ++i) {
                char c = result.charAt(i);
                if (c == 'p') {
                    for (int pad = i; pad < padding; ++pad) {
                        sb.append('0');
                    }
                    start_exponent = true;
                } else if (start_exponent) {
                    if (c != '-') {
                        sb.append('+');
                    }
                    start_exponent = false;
                }
                sb.append(c);
            }
            return sb.toString();
        }

        @Specialization
        static TruffleString doDouble(Object value, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(HexNode.makeHexNumber(FloatBuiltins.castToDoubleChecked(inliningTarget, value, cast)), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private double fromHex(String arg) {
            boolean negative = false;
            Object str = arg.trim().toLowerCase();
            if (((String)str).isEmpty()) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
            if (((String)str).equals("inf") || ((String)str).equals("infinity") || ((String)str).equals("+inf") || ((String)str).equals("+infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (((String)str).equals("-inf") || ((String)str).equals("-infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (((String)str).equals("nan") || ((String)str).equals("+nan") || ((String)str).equals("-nan")) {
                return Double.NaN;
            }
            if (((String)str).charAt(0) == '+') {
                str = ((String)str).substring(1);
            } else if (((String)str).charAt(0) == '-') {
                str = ((String)str).substring(1);
                negative = true;
            }
            if (((String)str).isEmpty()) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
            if (!((String)str).startsWith("0x")) {
                str = "0x" + (String)str;
            }
            if (negative) {
                str = "-" + (String)str;
            }
            if (((String)str).indexOf(112) == -1) {
                str = (String)str + "p0";
            }
            try {
                double result = Double.parseDouble((String)str);
                if (Double.isInfinite(result)) {
                    throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.OverflowError, ErrorMessages.HEX_VALUE_TOO_LARGE_AS_FLOAT);
                }
                return result;
            }
            catch (NumberFormatException ex) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.INVALID_STRING);
            }
        }

        @Specialization(guards={"isPythonBuiltinClass(cl)"})
        double fromhexFloat(Object cl, TruffleString arg, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            return this.fromHex(toJavaStringNode.execute((AbstractTruffleString)arg));
        }

        @Specialization(guards={"!isPythonBuiltinClass(cl)"})
        Object fromhexO(VirtualFrame frame, Object cl, TruffleString arg, @Cached CallNode callNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            double value = this.fromHex(toJavaStringNode.execute((AbstractTruffleString)arg));
            return callNode.execute((Frame)frame, cl, value);
        }

        @Fallback
        static double fromhex(Object object, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long doDouble(double num) {
            return PyObjectHashNode.hash(num);
        }

        @Specialization(replaces={"doDouble"})
        static long doOther(Object object, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return HashNode.doDouble(FloatBuiltins.castToDoubleChecked(inliningTarget, object, cast));
        }
    }

    @Slot(value=Slot.SlotKind.nb_divmod, isComplex=true)
    @GenerateNodeFactory
    static abstract class DivModNode
    extends AbstractNumericBinaryBuiltin {
        DivModNode() {
        }

        @Override
        protected PTuple op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            PythonLanguage language = PythonLanguage.get(this);
            return PFactory.createTuple(language, new Object[]{Math.floor(left / right), ModNode.mod(left, right)});
        }
    }

    @Slot(value=Slot.SlotKind.nb_floor_divide, isComplex=true)
    @GenerateNodeFactory
    static abstract class FloorDivNode
    extends AbstractNumericBinaryBuiltin {
        FloorDivNode() {
        }

        @Override
        protected Object op(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return Math.floor(left / right);
        }
    }

    @Slot(value=Slot.SlotKind.nb_power, isComplex=true)
    @GenerateNodeFactory
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        protected abstract double executeDouble(VirtualFrame var1, double var2, double var4, PNone var6) throws UnexpectedResultException;

        protected abstract Object execute(VirtualFrame var1, double var2, double var4, PNone var6);

        public final double executeDouble(double left, double right) throws UnexpectedResultException {
            return this.executeDouble(null, left, right, PNone.NO_VALUE);
        }

        public final Object execute(double left, double right) {
            return this.execute(null, left, right, PNone.NO_VALUE);
        }

        @Specialization
        static double doDI(double left, int right, PNone none, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return PowNode.doOperation(inliningTarget, left, right, raiseNode);
        }

        private static double doSpecialCases(Node inliningTarget, double left, double right, PRaiseNode raiseNode) {
            if (Double.isNaN(right) && left == 1.0) {
                return 1.0;
            }
            if (Double.isInfinite(right) && (left == 1.0 || left == -1.0)) {
                return 1.0;
            }
            if (left == 0.0 && right < 0.0 && Double.isFinite(right)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return 0.0;
        }

        private static double doOperation(Node inliningTarget, double left, double right, PRaiseNode raiseNode) {
            if (PowNode.doSpecialCases(inliningTarget, left, right, raiseNode) == 1.0) {
                return 1.0;
            }
            return Math.pow(left, right);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        @HostCompilerDirectives.InliningCutoff
        static double doDD(VirtualFrame frame, double left, double right, PNone none, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberPowerNode powerNode, @Cached.Shared @Cached PRaiseNode raiseNode) throws UnexpectedResultException {
            if (PowNode.doSpecialCases(inliningTarget, left, right, raiseNode) == 1.0) {
                return 1.0;
            }
            if (left < 0.0 && Double.isFinite(left) && Double.isFinite(right) && right % 1.0 != 0.0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PythonLanguage language = PythonLanguage.get(inliningTarget);
                throw new UnexpectedResultException(powerNode.execute(frame, PFactory.createComplex(language, left, 0.0), PFactory.createComplex(language, right, 0.0), none));
            }
            return Math.pow(left, right);
        }

        @Specialization(replaces={"doDD"})
        @HostCompilerDirectives.InliningCutoff
        static Object doDDToComplex(VirtualFrame frame, double left, double right, PNone none, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberPowerNode powerNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (PowNode.doSpecialCases(inliningTarget, left, right, raiseNode) == 1.0) {
                return 1.0;
            }
            if (left < 0.0 && Double.isFinite(left) && Double.isFinite(right) && right % 1.0 != 0.0) {
                PythonLanguage language = PythonLanguage.get(inliningTarget);
                return powerNode.execute(frame, PFactory.createComplex(language, left, 0.0), PFactory.createComplex(language, right, 0.0), none);
            }
            return Math.pow(left, right);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Object left, Object right, Object mod, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode castToJavaDoubleNode, @Cached.Shared @Cached PyNumberPowerNode powerNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            double rightDouble;
            double leftDouble;
            if (!(mod instanceof PNone)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.POW_3RD_ARG_NOT_ALLOWED_UNLESS_INTEGERS);
            }
            try {
                leftDouble = castToJavaDoubleNode.execute(inliningTarget, left);
                rightDouble = castToJavaDoubleNode.execute(inliningTarget, right);
            }
            catch (CannotCastException e) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return PowNode.doDDToComplex(frame, leftDouble, rightDouble, PNone.NONE, inliningTarget, powerNode, raiseNode);
        }

        public static PowNode create() {
            return FloatBuiltinsFactory.PowNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_multiply, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends AbstractNumericBinaryBuiltin {
        MulNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a * b;
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    static abstract class SubNode
    extends AbstractNumericBinaryBuiltin {
        SubNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a - b;
        }
    }

    @Slot(value=Slot.SlotKind.nb_add, isComplex=true)
    @GenerateNodeFactory
    static abstract class AddNode
    extends AbstractNumericBinaryBuiltin {
        AddNode() {
        }

        @Override
        protected Object op(double a, double b) {
            return a + b;
        }
    }

    @Slot(value=Slot.SlotKind.nb_float, isComplex=true)
    @GenerateNodeFactory
    static abstract class FloatNode
    extends AbstractNumericUnaryBuiltin {
        FloatNode() {
        }

        @Override
        protected Object op(double self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.nb_int, isComplex=true)
    @Builtin(name="__trunc__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IntNode
    extends PythonUnaryBuiltinNode {
        IntNode() {
        }

        @Specialization
        static Object doDouble(Object self, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast));
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        static boolean op(double self) {
            return self != 0.0;
        }

        @Specialization
        static boolean doDouble(double num) {
            return BoolNode.op(num);
        }

        @Specialization(replaces={"doDouble"})
        static boolean doOther(Object object, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return BoolNode.op(FloatBuiltins.castToDoubleChecked(inliningTarget, object, cast));
        }
    }

    @Slot(value=Slot.SlotKind.nb_absolute, isComplex=true)
    @GenerateNodeFactory
    static abstract class AbsNode
    extends AbstractNumericUnaryBuiltin {
        AbsNode() {
        }

        @Override
        protected Object op(double arg) {
            return Math.abs(arg);
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FloatBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString formatPF(Object self, TruffleString formatString, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return FormatNode.doFormat(inliningTarget, FloatBuiltins.castToDoubleChecked(inliningTarget, self, cast), formatString);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(Node raisingNode, double self, TruffleString formatString) {
            InternalFormat.Spec spec = InternalFormat.fromText(formatString, '\uffff', '>', raisingNode);
            FloatFormatter formatter = new FloatFormatter(FormattingUtils.validateForFloat(spec, "float", raisingNode), raisingNode);
            formatter.format(self);
            return formatter.pad().getResult();
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        ReprNode() {
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    public static abstract class StrNode
    extends AbstractNumericUnaryBuiltin {
        public static final InternalFormat.Spec spec = new InternalFormat.Spec(' ', '>', '\uffff', false, -1, '\uffff', 0, 'r');

        protected TruffleString op(double self) {
            FloatFormatter f = new FloatFormatter(spec, this);
            f.setMinFracDigits(1);
            return StrNode.doFormat(self, f);
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleString doFormat(double d, FloatFormatter f) {
            return f.format(d).getResult();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="float", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class FloatNewNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        NonPrimitiveFloatNode nonPrimitiveFloatNode;

        @Specialization
        Object doIt(VirtualFrame frame, Object cls, Object arg, @Bind Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveFloatProfile, @Cached PrimitiveFloatNode primitiveFloatNode, @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode) {
            if (FloatNewNode.isPrimitiveFloat(inliningTarget, cls, isPrimitiveFloatProfile)) {
                return primitiveFloatNode.execute(frame, inliningTarget, arg);
            }
            boolean needsNativeAllocation = needsNativeAllocationNode.execute(inliningTarget, cls);
            if (this.nonPrimitiveFloatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonPrimitiveFloatNode = (NonPrimitiveFloatNode)this.insert(FloatBuiltinsFactory.FloatNewNodeFactory.NonPrimitiveFloatNodeGen.create());
            }
            return this.nonPrimitiveFloatNode.execute(frame, cls, arg, needsNativeAllocation);
        }

        protected static boolean isPrimitiveFloat(Node inliningTarget, Object cls, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile) {
            return isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PFloat);
        }

        @GenerateCached(value=false)
        @GenerateInline
        @ImportStatic(value={PGuards.class})
        static abstract class PrimitiveFloatNode
        extends Node {
            PrimitiveFloatNode() {
            }

            abstract double execute(VirtualFrame var1, Node var2, Object var3);

            @Specialization
            static double floatFromDouble(double arg) {
                return arg;
            }

            @Specialization
            static double floatFromInt(int arg) {
                return arg;
            }

            @Specialization
            static double floatFromLong(long arg) {
                return arg;
            }

            @Specialization
            static double floatFromBoolean(boolean arg) {
                return arg ? 1.0 : 0.0;
            }

            @Specialization(guards={"isNoValue(obj)"})
            static double floatFromNoValue(PNone obj) {
                return 0.0;
            }

            @HostCompilerDirectives.InliningCutoff
            @Fallback
            static double floatFromObject(VirtualFrame frame, Node inliningTarget, Object obj, @Cached PyUnicodeCheckExactNode stringCheck, @Cached PyFloatFromString fromString, @Cached PyNumberFloatNode pyNumberFloat) {
                if (stringCheck.execute(inliningTarget, obj)) {
                    return fromString.execute((Frame)frame, inliningTarget, obj);
                }
                return pyNumberFloat.execute((Frame)frame, inliningTarget, obj);
            }
        }

        @ImportStatic(value={PGuards.class})
        @GenerateInline(value=false)
        static abstract class NonPrimitiveFloatNode
        extends Node {
            NonPrimitiveFloatNode() {
            }

            abstract Object execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

            @Specialization(guards={"!needsNativeAllocation", "isNoValue(obj)"})
            @HostCompilerDirectives.InliningCutoff
            static Object floatFromNoneManagedSubclass(Object cls, PNone obj, boolean needsNativeAllocation, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                Shape shape = getInstanceShape.execute(cls);
                return PFactory.createFloat(language, cls, shape, PrimitiveFloatNode.floatFromNoValue(obj));
            }

            @Specialization(guards={"!needsNativeAllocation"})
            @HostCompilerDirectives.InliningCutoff
            static Object floatFromObjectManagedSubclass(VirtualFrame frame, Object cls, Object obj, boolean needsNativeAllocation, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Shared @Cached PrimitiveFloatNode recursiveCallNode) {
                Shape shape = getInstanceShape.execute(cls);
                return PFactory.createFloat(language, cls, shape, recursiveCallNode.execute(frame, inliningTarget, obj));
            }

            @Specialization(guards={"needsNativeAllocation", "isSubtypeOfFloat(isSubtype, cls)"}, limit="1")
            @HostCompilerDirectives.InliningCutoff
            static Object floatFromObjectNativeSubclass(VirtualFrame frame, Object cls, Object obj, boolean needsNativeAllocation, @Bind Node inliningTarget, @Cached IsSubtypeNode isSubtype, @Cached CExtNodes.FloatSubtypeNew subtypeNew, @Cached.Shared @Cached PrimitiveFloatNode recursiveCallNode) {
                return subtypeNew.call(cls, recursiveCallNode.execute(frame, inliningTarget, obj));
            }

            protected static boolean isSubtypeOfFloat(IsSubtypeNode isSubtypeNode, Object cls) {
                return isSubtypeNode.execute(cls, (Object)PythonBuiltinClassType.PFloat);
            }
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractNumericBinaryBuiltin
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        private final BranchProfile errorProfile = BranchProfile.create();

        AbstractNumericBinaryBuiltin() {
        }

        protected abstract Object op(double var1, double var3);

        @Specialization
        Object doDD(double a, double b) {
            return this.op(a, b);
        }

        @Specialization
        Object doDI(double a, int b) {
            return this.op(a, b);
        }

        @Specialization(replaces={"doDD", "doDI"})
        Object doOther(Object a, Object b, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            double bDouble;
            double aDouble;
            try {
                aDouble = cast.execute(inliningTarget, a);
                bDouble = cast.execute(inliningTarget, b);
            }
            catch (CannotCastException e) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return this.op(aDouble, bDouble);
        }

        void raiseDivisionByZero(boolean cond) {
            if (cond) {
                this.errorProfile.enter();
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractNumericUnaryBuiltin
    extends PythonUnaryBuiltinNode {
        AbstractNumericUnaryBuiltin() {
        }

        protected abstract Object op(double var1);

        @Specialization
        Object doDouble(double num) {
            return this.op(num);
        }

        @Specialization(replaces={"doDouble"})
        Object doOther(Object object, @Bind Node inliningTarget, @Cached CastToJavaDoubleNode cast) {
            return this.op(FloatBuiltins.castToDoubleChecked(inliningTarget, object, cast));
        }
    }
}

