/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.TruffleInlining;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public abstract class AbstractCompilationTask
implements TruffleCompilationTask {
    private TruffleInlining inliningData;
    private final List<OptimizedCallTarget> targetsToDequeue = new ArrayList<OptimizedCallTarget>();
    private final List<OptimizedCallTarget> inlinedTargets = new ArrayList<OptimizedCallTarget>();
    private int callCount = -1;
    private int inlinedCallCount = -1;
    private EconomicMap<Node, TruffleSourceLanguagePosition> sourcePositionCache;
    private int nodeIdCounter;

    @Deprecated
    public TruffleInlining getInlining() {
        if (this.inliningData == null) {
            this.inliningData = new TruffleInlining(this);
        }
        return this.inliningData;
    }

    public void dequeueTargets() {
        for (OptimizedCallTarget target : this.targetsToDequeue) {
            target.dequeueInlined();
        }
    }

    public int countCalls() {
        return this.callCount;
    }

    public int countInlinedCalls() {
        return this.inlinedCallCount;
    }

    public TruffleCompilable[] inlinedTargets() {
        return this.inlinedTargets.toArray(new TruffleCompilable[0]);
    }

    public void addInlinedTarget(TruffleCompilable target) {
        this.inlinedTargets.add((OptimizedCallTarget)target);
    }

    public void addTargetToDequeue(TruffleCompilable target) {
        this.targetsToDequeue.add((OptimizedCallTarget)target);
    }

    public void setCallCounts(int total, int inlined) {
        this.callCount = total;
        this.inlinedCallCount = inlined;
    }

    public TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        TruffleSourceLanguagePosition position;
        Node truffleNode = OptimizedCallTarget.runtime().asObject(Node.class, node);
        if (truffleNode == null) {
            return null;
        }
        EconomicMap cache = this.sourcePositionCache;
        if (cache == null) {
            this.sourcePositionCache = cache = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        }
        if ((position = (TruffleSourceLanguagePosition)cache.get((Object)truffleNode)) != null) {
            return position;
        }
        SourceSection section = null;
        if (truffleNode instanceof DirectCallNode) {
            section = ((DirectCallNode)truffleNode).getCurrentRootNode().getSourceSection();
        }
        if (section == null) {
            section = truffleNode.getSourceSection();
        }
        if (section == null) {
            for (Node cur = truffleNode.getParent(); cur != null && (section = cur.getSourceSection()) == null; cur = cur.getParent()) {
            }
        }
        position = new TruffleSourcePositionImpl(section, truffleNode.getClass(), this.nodeIdCounter++);
        this.sourcePositionCache.put((Object)truffleNode, (Object)position);
        return position;
    }

    public Map<String, Object> getDebugProperties(JavaConstant node) {
        Node truffleNode = OptimizedCallTarget.runtime().asObject(Node.class, node);
        if (truffleNode == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.putAll(truffleNode.getDebugProperties());
        AbstractCompilationTask.computeNodeProperties(map, truffleNode);
        return map;
    }

    private static void computeNodeProperties(Map<String, ? super Object> properties, Node node) {
        NodeInfo nodeInfo = node.getClass().getAnnotation(NodeInfo.class);
        if (nodeInfo != null && !nodeInfo.shortName().isEmpty()) {
            properties.put("shortName", nodeInfo.shortName());
        }
        properties.putAll(NodeUtil.collectNodeProperties((Node)node));
        if (Introspection.isIntrospectable((Node)node)) {
            List specializations = Introspection.getSpecializations((Node)node);
            for (Introspection.SpecializationInfo specialization : specializations) {
                String methodName = "specialization." + specialization.getMethodName();
                String state = specialization.isActive() ? "active" : (specialization.isExcluded() ? "excluded" : "inactive");
                properties.put(methodName, state);
                if (specialization.getInstances() <= 1 && (specialization.getInstances() != 1 || specialization.getCachedData(0).size() <= 0)) continue;
                properties.put(methodName + ".instances", (Object)specialization.getInstances());
                for (int instance = 0; instance < specialization.getInstances(); ++instance) {
                    List cachedData = specialization.getCachedData(instance);
                    int cachedIndex = 0;
                    for (Object o : cachedData) {
                        properties.put(methodName + ".instance[" + instance + "].cached[" + cachedIndex + "]", o);
                        ++cachedIndex;
                    }
                }
            }
        }
        for (Map.Entry<String, ? super Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (AbstractCompilationTask.isValidProtocolValue(value)) continue;
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                value = e.getDeclaringClass().getSimpleName() + "." + e.name();
            } else {
                value = value.toString();
            }
            properties.put(entry.getKey(), value);
        }
    }

    private static boolean isValidProtocolValue(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clz = object.getClass();
        return clz == String.class || clz == Boolean.class || clz == Byte.class || clz == Integer.class || clz == Long.class || clz == Float.class || clz == Double.class;
    }

    static String className(Class<?> clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static class TruffleSourcePositionImpl
    implements TruffleSourceLanguagePosition {
        private final SourceSection sourceSection;
        private final Class<?> nodeClass;
        private final int nodeId;

        TruffleSourcePositionImpl(SourceSection section, Class<?> nodeClass, int nodeId) {
            this.sourceSection = section;
            this.nodeClass = nodeClass;
            this.nodeId = nodeId;
        }

        public String getDescription() {
            if (this.sourceSection == null) {
                return "<no-description>";
            }
            return String.valueOf(this.sourceSection.getSource().getURI()) + " " + this.sourceSection.getStartLine() + ":" + this.sourceSection.getStartColumn();
        }

        public int getOffsetEnd() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getCharEndIndex();
        }

        public int getOffsetStart() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getCharIndex();
        }

        public int getLineNumber() {
            if (this.sourceSection == null) {
                return -1;
            }
            return this.sourceSection.getStartLine();
        }

        public URI getURI() {
            if (this.sourceSection == null) {
                return null;
            }
            return this.sourceSection.getSource().getURI();
        }

        public String getLanguage() {
            if (this.sourceSection == null) {
                return null;
            }
            return this.sourceSection.getSource().getLanguage();
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodeClassName() {
            return this.nodeClass.getName();
        }
    }
}

