/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class XProcException
extends RuntimeException {
    public static final QName err_E0001 = new QName("http://xproc.org/ns/errors", "XE0001");
    public static final QName err_E0002 = new QName("http://xproc.org/ns/errors", "XE0002");
    private QName error = null;
    private Step step = null;
    private XdmNode node = null;

    public XProcException() {
    }

    public XProcException(String string) {
        super(string);
    }

    public XProcException(Step step, String string) {
        super(string);
        this.step = step;
    }

    public XProcException(XdmNode xdmNode, String string) {
        super(string);
        this.node = xdmNode;
    }

    public XProcException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public XProcException(Step step, String string, Throwable throwable) {
        super(string, throwable);
        this.step = step;
    }

    public XProcException(Throwable throwable) {
        super(throwable);
    }

    public XProcException(XdmNode xdmNode, Throwable throwable) {
        super(throwable);
        this.node = xdmNode;
    }

    public XProcException(XdmNode xdmNode, String string, Throwable throwable) {
        super(string, throwable);
        this.node = xdmNode;
    }

    public XProcException(QName qName) {
        super(qName.getLocalName());
        this.error = qName;
    }

    public XProcException(Step step, QName qName) {
        super(qName.getLocalName());
        this.error = qName;
        this.step = step;
    }

    public XProcException(QName qName, String string) {
        super(string);
        this.error = qName;
    }

    public XProcException(Step step, QName qName, String string) {
        super(string);
        this.error = qName;
        this.step = step;
    }

    public XProcException(QName qName, XdmNode xdmNode, Throwable throwable, String string) {
        super(string, throwable);
        this.error = qName;
        this.node = xdmNode;
    }

    public XProcException(QName qName, XdmNode xdmNode, String string) {
        super(string);
        this.error = qName;
        this.node = xdmNode;
    }

    public XProcException(QName qName, Throwable throwable) {
        super("XProc error err:" + qName.getLocalName(), throwable);
        this.error = qName;
    }

    public static XProcException staticError(int n) {
        return new XProcException(XProcConstants.staticError(n));
    }

    public static XProcException staticError(int n, String string) {
        return new XProcException(XProcConstants.staticError(n), string);
    }

    public static XProcException staticError(int n, XdmNode xdmNode, String string) {
        return new XProcException(XProcConstants.staticError(n), xdmNode, string);
    }

    public static XProcException staticError(int n, XdmNode xdmNode, Throwable throwable, String string) {
        return new XProcException(XProcConstants.staticError(n), xdmNode, throwable, string);
    }

    public static XProcException staticError(int n, Exception exception) {
        return new XProcException(XProcConstants.staticError(n), (Throwable)exception);
    }

    public static XProcException dynamicError(int n) {
        return new XProcException(XProcConstants.dynamicError(n));
    }

    public static XProcException dynamicError(Step step, int n) {
        return new XProcException(step, XProcConstants.dynamicError(n));
    }

    public static XProcException dynamicError(int n, String string) {
        return new XProcException(XProcConstants.dynamicError(n), string);
    }

    public static XProcException dynamicError(int n, XdmNode xdmNode, String string) {
        return new XProcException(XProcConstants.dynamicError(n), xdmNode, string);
    }

    public static XProcException dynamicError(int n, XdmNode xdmNode, Exception exception, String string) {
        return new XProcException(XProcConstants.dynamicError(n), xdmNode, exception, string);
    }

    public static XProcException dynamicError(Step step, int n, String string) {
        return new XProcException(step, XProcConstants.dynamicError(n), string);
    }

    public static XProcException dynamicError(int n, Exception exception) {
        return new XProcException(XProcConstants.dynamicError(n), (Throwable)exception);
    }

    public static XProcException stepError(int n) {
        return new XProcException(XProcConstants.stepError(n));
    }

    public static XProcException stepError(int n, String string) {
        return new XProcException(XProcConstants.stepError(n), string);
    }

    public static XProcException stepError(int n, Exception exception) {
        return new XProcException(XProcConstants.stepError(n), (Throwable)exception);
    }

    public QName getErrorCode() {
        return this.error;
    }

    public Step getStep() {
        return this.step;
    }

    public SourceLocator getLocator() {
        XdmNode xdmNode = null;
        if (this.step != null) {
            xdmNode = this.step.getNode();
        }
        if (this.node != null) {
            xdmNode = this.node;
        }
        return new ExceptionLocation(xdmNode);
    }

    private class ExceptionLocation
    implements SourceLocator {
        private int line = -1;
        private int col = -1;
        private String systemId = null;

        public ExceptionLocation(XdmNode xdmNode) {
            if (xdmNode != null) {
                URI uRI = URIUtils.cwdAsURI();
                this.systemId = uRI.relativize(xdmNode.getBaseURI()).toASCIIString();
                this.line = xdmNode.getLineNumber();
                this.col = xdmNode.getColumnNumber();
            }
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return this.col;
        }
    }
}

