/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.StringValue;

public class Replace
extends SystemFunction {
    private RegularExpression regexp;
    private boolean allow30features = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.allow30features = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel());
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 3, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                err = new XPathException("The regular expression in replace() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        RegularExpression re;
        AtomicValue arg2;
        CharSequence replacement;
        String msg;
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(c);
        if (arg0 == null) {
            arg0 = StringValue.EMPTY_STRING;
        }
        if ((msg = Replace.checkReplacement(replacement = (arg2 = (AtomicValue)this.argument[2].evaluateItem(c)).getStringValueCS())) != null) {
            this.dynamicError(msg, "FORX0004", c);
        }
        if ((re = this.regexp) == null) {
            CharSequence flags;
            AtomicValue arg1 = (AtomicValue)this.argument[1].evaluateItem(c);
            if (this.argument.length == 3) {
                flags = "";
            } else {
                AtomicValue arg3 = (AtomicValue)this.argument[3].evaluateItem(c);
                flags = arg3.getStringValueCS();
            }
            try {
                int flagBits = JRegularExpression.setFlags(flags);
                int options = 2;
                if (c.getConfiguration().getXMLVersion() == 11) {
                    options |= 1;
                }
                if (this.allow30features) {
                    options |= 4;
                }
                re = new JRegularExpression(arg1.getStringValueCS(), options, flagBits);
            }
            catch (XPathException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(c);
                de.setLocator(this);
                throw de;
            }
            catch (PatternSyntaxException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(c);
                de.setLocator(this);
                throw de;
            }
            if (re.matches("")) {
                this.dynamicError("The regular expression in replace() must not be one that matches a zero-length string", "FORX0003", c);
            }
        }
        String input = arg0.getStringValue();
        CharSequence res = re.replace(input, replacement);
        return StringValue.makeStringValue(res);
    }

    public static String checkReplacement(CharSequence rep) {
        for (int i = 0; i < rep.length(); ++i) {
            char next;
            char c = rep.charAt(i);
            if (c == '$') {
                if (i + 1 < rep.length()) {
                    if ((next = rep.charAt(++i)) >= '0' && next <= '9') continue;
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
                return "Invalid replacement string in replace(): $ sign at end of string";
            }
            if (c != '\\') continue;
            if (i + 1 < rep.length()) {
                if ((next = rep.charAt(++i)) == '\\' || next == '$') continue;
                return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
            }
            return "Invalid replacement string in replace(): \\ character at end of string";
        }
        return null;
    }
}

