from pathlib import Path
from base64 import b64encode
import shutil
import subprocess
import sys

subprocess.call(
    [sys.executable, 'setup.py', 'bdist_wheel'],
    stdout=subprocess.DEVNULL
)
wheel = next(Path('dist').glob('*.whl'))
data = b64encode(wheel.read_bytes())
while data:
    print(data[:80].decode('ascii'))
    data = data[80:]

for dir in ('build', 'dist', 'project.egg-info'):
    shutil.rmtree(dir, ignore_errors=True)
