/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.core.TeamPlugin;

public class PluginStringMappings {
    private final String fExtensionID;
    private final String fAttributeName;
    private SortedMap<String, Integer> fMappings;

    public PluginStringMappings(String extensionID, String stringAttributeName) {
        this.fExtensionID = extensionID;
        this.fAttributeName = stringAttributeName;
    }

    private SortedMap<String, Integer> loadPluginPatterns() {
        IExtension[] extensions;
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin == null) {
            return result;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", this.fExtensionID);
        if (extension == null) {
            return result;
        }
        IExtension[] iExtensionArray = extensions = extension.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = e.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                String ext = configElement.getAttribute(this.fAttributeName);
                String type = configElement.getAttribute("type");
                if (ext != null && type != null) {
                    if (type.equals("text")) {
                        result.put(ext, 1);
                    } else if (type.equals("binary")) {
                        result.put(ext, 2);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public Map<String, Integer> referenceMap() {
        if (this.fMappings == null) {
            this.fMappings = this.loadPluginPatterns();
        }
        return this.fMappings;
    }

    public int getType(String filename) {
        Map<String, Integer> mappings = this.referenceMap();
        return mappings.containsKey(filename) ? mappings.get(filename) : 0;
    }
}

