//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfplugindynamicregistrationkey?language=objc)
    pub static kCFPlugInDynamicRegistrationKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfplugindynamicregisterfunctionkey?language=objc)
    pub static kCFPlugInDynamicRegisterFunctionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpluginunloadfunctionkey?language=objc)
    pub static kCFPlugInUnloadFunctionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpluginfactorieskey?language=objc)
    pub static kCFPlugInFactoriesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfplugintypeskey?language=objc)
    pub static kCFPlugInTypesKey: Option<&'static CFString>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfplugindynamicregisterfunction?language=objc)
#[cfg(feature = "CFBundle")]
pub type CFPlugInDynamicRegisterFunction = Option<unsafe extern "C-unwind" fn(*mut CFPlugIn)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfpluginunloadfunction?language=objc)
#[cfg(feature = "CFBundle")]
pub type CFPlugInUnloadFunction = Option<unsafe extern "C-unwind" fn(*mut CFPlugIn)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfpluginfactoryfunction?language=objc)
#[cfg(feature = "CFUUID")]
pub type CFPlugInFactoryFunction =
    Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const CFUUID) -> *mut c_void>;

#[cfg(feature = "CFBundle")]
unsafe impl ConcreteType for CFPlugIn {
    #[doc(alias = "CFPlugInGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFPlugInGetTypeID() -> CFTypeID;
        }
        unsafe { CFPlugInGetTypeID() }
    }
}

#[cfg(feature = "CFBundle")]
impl CFPlugIn {
    #[doc(alias = "CFPlugInCreate")]
    #[cfg(all(feature = "CFBundle", feature = "CFURL"))]
    #[inline]
    pub fn new(
        allocator: Option<&CFAllocator>,
        plug_in_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFPlugIn>> {
        extern "C-unwind" {
            fn CFPlugInCreate(
                allocator: Option<&CFAllocator>,
                plug_in_url: Option<&CFURL>,
            ) -> Option<NonNull<CFPlugIn>>;
        }
        let ret = unsafe { CFPlugInCreate(allocator, plug_in_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFPlugInGetBundle")]
    #[cfg(feature = "CFBundle")]
    #[inline]
    pub fn bundle(&self) -> Option<CFRetained<CFBundle>> {
        extern "C-unwind" {
            fn CFPlugInGetBundle(plug_in: &CFPlugIn) -> Option<NonNull<CFBundle>>;
        }
        let ret = unsafe { CFPlugInGetBundle(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFPlugInSetLoadOnDemand")]
    #[cfg(feature = "CFBundle")]
    #[inline]
    pub fn set_load_on_demand(&self, flag: bool) {
        extern "C-unwind" {
            fn CFPlugInSetLoadOnDemand(plug_in: &CFPlugIn, flag: Boolean);
        }
        unsafe { CFPlugInSetLoadOnDemand(self, flag as _) }
    }

    #[doc(alias = "CFPlugInIsLoadOnDemand")]
    #[cfg(feature = "CFBundle")]
    #[inline]
    pub fn is_load_on_demand(&self) -> bool {
        extern "C-unwind" {
            fn CFPlugInIsLoadOnDemand(plug_in: &CFPlugIn) -> Boolean;
        }
        let ret = unsafe { CFPlugInIsLoadOnDemand(self) };
        ret != 0
    }

    #[doc(alias = "CFPlugInFindFactoriesForPlugInType")]
    #[cfg(all(feature = "CFArray", feature = "CFUUID"))]
    #[inline]
    pub fn find_factories_for_plug_in_type(
        type_uuid: Option<&CFUUID>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFPlugInFindFactoriesForPlugInType(
                type_uuid: Option<&CFUUID>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFPlugInFindFactoriesForPlugInType(type_uuid) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFPlugInFindFactoriesForPlugInTypeInPlugIn")]
    #[cfg(all(feature = "CFArray", feature = "CFBundle", feature = "CFUUID"))]
    #[inline]
    pub fn find_factories_for_plug_in_type_in_plug_in(
        type_uuid: Option<&CFUUID>,
        plug_in: Option<&CFPlugIn>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFPlugInFindFactoriesForPlugInTypeInPlugIn(
                type_uuid: Option<&CFUUID>,
                plug_in: Option<&CFPlugIn>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFPlugInFindFactoriesForPlugInTypeInPlugIn(type_uuid, plug_in) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFPlugInInstance {
    #[doc(alias = "CFPlugInInstanceCreate")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn create(
        allocator: Option<&CFAllocator>,
        factory_uuid: Option<&CFUUID>,
        type_uuid: Option<&CFUUID>,
    ) -> *mut c_void {
        extern "C-unwind" {
            fn CFPlugInInstanceCreate(
                allocator: Option<&CFAllocator>,
                factory_uuid: Option<&CFUUID>,
                type_uuid: Option<&CFUUID>,
            ) -> *mut c_void;
        }
        unsafe { CFPlugInInstanceCreate(allocator, factory_uuid, type_uuid) }
    }
}

#[cfg(feature = "CFBundle")]
impl CFPlugIn {
    #[doc(alias = "CFPlugInRegisterFactoryFunction")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn register_factory_function(
        factory_uuid: Option<&CFUUID>,
        func: CFPlugInFactoryFunction,
    ) -> bool {
        extern "C-unwind" {
            fn CFPlugInRegisterFactoryFunction(
                factory_uuid: Option<&CFUUID>,
                func: CFPlugInFactoryFunction,
            ) -> Boolean;
        }
        let ret = unsafe { CFPlugInRegisterFactoryFunction(factory_uuid, func) };
        ret != 0
    }

    #[doc(alias = "CFPlugInRegisterFactoryFunctionByName")]
    #[cfg(all(feature = "CFBundle", feature = "CFUUID"))]
    #[inline]
    pub fn register_factory_function_by_name(
        factory_uuid: Option<&CFUUID>,
        plug_in: Option<&CFPlugIn>,
        function_name: Option<&CFString>,
    ) -> bool {
        extern "C-unwind" {
            fn CFPlugInRegisterFactoryFunctionByName(
                factory_uuid: Option<&CFUUID>,
                plug_in: Option<&CFPlugIn>,
                function_name: Option<&CFString>,
            ) -> Boolean;
        }
        let ret =
            unsafe { CFPlugInRegisterFactoryFunctionByName(factory_uuid, plug_in, function_name) };
        ret != 0
    }

    #[doc(alias = "CFPlugInUnregisterFactory")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn unregister_factory(factory_uuid: Option<&CFUUID>) -> bool {
        extern "C-unwind" {
            fn CFPlugInUnregisterFactory(factory_uuid: Option<&CFUUID>) -> Boolean;
        }
        let ret = unsafe { CFPlugInUnregisterFactory(factory_uuid) };
        ret != 0
    }

    #[doc(alias = "CFPlugInRegisterPlugInType")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn register_plug_in_type(
        factory_uuid: Option<&CFUUID>,
        type_uuid: Option<&CFUUID>,
    ) -> bool {
        extern "C-unwind" {
            fn CFPlugInRegisterPlugInType(
                factory_uuid: Option<&CFUUID>,
                type_uuid: Option<&CFUUID>,
            ) -> Boolean;
        }
        let ret = unsafe { CFPlugInRegisterPlugInType(factory_uuid, type_uuid) };
        ret != 0
    }

    #[doc(alias = "CFPlugInUnregisterPlugInType")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn unregister_plug_in_type(
        factory_uuid: Option<&CFUUID>,
        type_uuid: Option<&CFUUID>,
    ) -> bool {
        extern "C-unwind" {
            fn CFPlugInUnregisterPlugInType(
                factory_uuid: Option<&CFUUID>,
                type_uuid: Option<&CFUUID>,
            ) -> Boolean;
        }
        let ret = unsafe { CFPlugInUnregisterPlugInType(factory_uuid, type_uuid) };
        ret != 0
    }

    #[doc(alias = "CFPlugInAddInstanceForFactory")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn add_instance_for_factory(factory_id: Option<&CFUUID>) {
        extern "C-unwind" {
            fn CFPlugInAddInstanceForFactory(factory_id: Option<&CFUUID>);
        }
        unsafe { CFPlugInAddInstanceForFactory(factory_id) }
    }

    #[doc(alias = "CFPlugInRemoveInstanceForFactory")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn remove_instance_for_factory(factory_id: Option<&CFUUID>) {
        extern "C-unwind" {
            fn CFPlugInRemoveInstanceForFactory(factory_id: Option<&CFUUID>);
        }
        unsafe { CFPlugInRemoveInstanceForFactory(factory_id) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfplugininstance?language=objc)
#[doc(alias = "CFPlugInInstanceRef")]
#[repr(C)]
pub struct CFPlugInInstance {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFPlugInInstance {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFPlugInInstance"> for CFPlugInInstance {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfplugininstancegetinterfacefunction?language=objc)
pub type CFPlugInInstanceGetInterfaceFunction = Option<
    unsafe extern "C-unwind" fn(
        *mut CFPlugInInstance,
        *const CFString,
        *mut *mut c_void,
    ) -> Boolean,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfplugininstancedeallocateinstancedatafunction?language=objc)
pub type CFPlugInInstanceDeallocateInstanceDataFunction =
    Option<unsafe extern "C-unwind" fn(*mut c_void)>;

impl CFPlugInInstance {
    /// # Safety
    ///
    /// - `interface_name` might not allow `None`.
    /// - `ftbl` must be a valid pointer.
    #[doc(alias = "CFPlugInInstanceGetInterfaceFunctionTable")]
    #[inline]
    pub unsafe fn interface_function_table(
        &self,
        interface_name: Option<&CFString>,
        ftbl: *mut *mut c_void,
    ) -> bool {
        extern "C-unwind" {
            fn CFPlugInInstanceGetInterfaceFunctionTable(
                instance: &CFPlugInInstance,
                interface_name: Option<&CFString>,
                ftbl: *mut *mut c_void,
            ) -> Boolean;
        }
        let ret = unsafe { CFPlugInInstanceGetInterfaceFunctionTable(self, interface_name, ftbl) };
        ret != 0
    }

    #[doc(alias = "CFPlugInInstanceGetFactoryName")]
    #[inline]
    pub fn factory_name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFPlugInInstanceGetFactoryName(
                instance: &CFPlugInInstance,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFPlugInInstanceGetFactoryName(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFPlugInInstanceGetInstanceData")]
    #[inline]
    pub fn instance_data(&self) -> *mut c_void {
        extern "C-unwind" {
            fn CFPlugInInstanceGetInstanceData(instance: &CFPlugInInstance) -> *mut c_void;
        }
        unsafe { CFPlugInInstanceGetInstanceData(self) }
    }
}

unsafe impl ConcreteType for CFPlugInInstance {
    #[doc(alias = "CFPlugInInstanceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFPlugInInstanceGetTypeID() -> CFTypeID;
        }
        unsafe { CFPlugInInstanceGetTypeID() }
    }
}

impl CFPlugInInstance {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `deallocate_instance_function` must be implemented correctly.
    /// - `factory_name` might not allow `None`.
    /// - `get_interface_function` must be implemented correctly.
    #[doc(alias = "CFPlugInInstanceCreateWithInstanceDataSize")]
    #[inline]
    pub unsafe fn with_instance_data_size(
        allocator: Option<&CFAllocator>,
        instance_data_size: CFIndex,
        deallocate_instance_function: CFPlugInInstanceDeallocateInstanceDataFunction,
        factory_name: Option<&CFString>,
        get_interface_function: CFPlugInInstanceGetInterfaceFunction,
    ) -> Option<CFRetained<CFPlugInInstance>> {
        extern "C-unwind" {
            fn CFPlugInInstanceCreateWithInstanceDataSize(
                allocator: Option<&CFAllocator>,
                instance_data_size: CFIndex,
                deallocate_instance_function: CFPlugInInstanceDeallocateInstanceDataFunction,
                factory_name: Option<&CFString>,
                get_interface_function: CFPlugInInstanceGetInterfaceFunction,
            ) -> Option<NonNull<CFPlugInInstance>>;
        }
        let ret = unsafe {
            CFPlugInInstanceCreateWithInstanceDataSize(
                allocator,
                instance_data_size,
                deallocate_instance_function,
                factory_name,
                get_interface_function,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[cfg(all(feature = "CFBundle", feature = "CFURL"))]
#[deprecated = "renamed to `CFPlugIn::new`"]
#[inline]
pub extern "C-unwind" fn CFPlugInCreate(
    allocator: Option<&CFAllocator>,
    plug_in_url: Option<&CFURL>,
) -> Option<CFRetained<CFPlugIn>> {
    extern "C-unwind" {
        fn CFPlugInCreate(
            allocator: Option<&CFAllocator>,
            plug_in_url: Option<&CFURL>,
        ) -> Option<NonNull<CFPlugIn>>;
    }
    let ret = unsafe { CFPlugInCreate(allocator, plug_in_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBundle")]
#[deprecated = "renamed to `CFPlugIn::bundle`"]
#[inline]
pub extern "C-unwind" fn CFPlugInGetBundle(plug_in: &CFPlugIn) -> Option<CFRetained<CFBundle>> {
    extern "C-unwind" {
        fn CFPlugInGetBundle(plug_in: &CFPlugIn) -> Option<NonNull<CFBundle>>;
    }
    let ret = unsafe { CFPlugInGetBundle(plug_in) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFBundle")]
#[deprecated = "renamed to `CFPlugIn::set_load_on_demand`"]
#[inline]
pub extern "C-unwind" fn CFPlugInSetLoadOnDemand(plug_in: &CFPlugIn, flag: bool) {
    extern "C-unwind" {
        fn CFPlugInSetLoadOnDemand(plug_in: &CFPlugIn, flag: Boolean);
    }
    unsafe { CFPlugInSetLoadOnDemand(plug_in, flag as _) }
}

#[cfg(feature = "CFBundle")]
#[deprecated = "renamed to `CFPlugIn::is_load_on_demand`"]
#[inline]
pub extern "C-unwind" fn CFPlugInIsLoadOnDemand(plug_in: &CFPlugIn) -> bool {
    extern "C-unwind" {
        fn CFPlugInIsLoadOnDemand(plug_in: &CFPlugIn) -> Boolean;
    }
    let ret = unsafe { CFPlugInIsLoadOnDemand(plug_in) };
    ret != 0
}

#[cfg(all(feature = "CFArray", feature = "CFUUID"))]
#[deprecated = "renamed to `CFPlugIn::find_factories_for_plug_in_type`"]
#[inline]
pub extern "C-unwind" fn CFPlugInFindFactoriesForPlugInType(
    type_uuid: Option<&CFUUID>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFPlugInFindFactoriesForPlugInType(
            type_uuid: Option<&CFUUID>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFPlugInFindFactoriesForPlugInType(type_uuid) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFBundle", feature = "CFUUID"))]
#[deprecated = "renamed to `CFPlugIn::find_factories_for_plug_in_type_in_plug_in`"]
#[inline]
pub extern "C-unwind" fn CFPlugInFindFactoriesForPlugInTypeInPlugIn(
    type_uuid: Option<&CFUUID>,
    plug_in: Option<&CFPlugIn>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFPlugInFindFactoriesForPlugInTypeInPlugIn(
            type_uuid: Option<&CFUUID>,
            plug_in: Option<&CFPlugIn>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFPlugInFindFactoriesForPlugInTypeInPlugIn(type_uuid, plug_in) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugInInstance::create`"]
#[inline]
pub extern "C-unwind" fn CFPlugInInstanceCreate(
    allocator: Option<&CFAllocator>,
    factory_uuid: Option<&CFUUID>,
    type_uuid: Option<&CFUUID>,
) -> *mut c_void {
    extern "C-unwind" {
        fn CFPlugInInstanceCreate(
            allocator: Option<&CFAllocator>,
            factory_uuid: Option<&CFUUID>,
            type_uuid: Option<&CFUUID>,
        ) -> *mut c_void;
    }
    unsafe { CFPlugInInstanceCreate(allocator, factory_uuid, type_uuid) }
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::register_factory_function`"]
#[inline]
pub extern "C-unwind" fn CFPlugInRegisterFactoryFunction(
    factory_uuid: Option<&CFUUID>,
    func: CFPlugInFactoryFunction,
) -> bool {
    extern "C-unwind" {
        fn CFPlugInRegisterFactoryFunction(
            factory_uuid: Option<&CFUUID>,
            func: CFPlugInFactoryFunction,
        ) -> Boolean;
    }
    let ret = unsafe { CFPlugInRegisterFactoryFunction(factory_uuid, func) };
    ret != 0
}

#[cfg(all(feature = "CFBundle", feature = "CFUUID"))]
#[deprecated = "renamed to `CFPlugIn::register_factory_function_by_name`"]
#[inline]
pub extern "C-unwind" fn CFPlugInRegisterFactoryFunctionByName(
    factory_uuid: Option<&CFUUID>,
    plug_in: Option<&CFPlugIn>,
    function_name: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn CFPlugInRegisterFactoryFunctionByName(
            factory_uuid: Option<&CFUUID>,
            plug_in: Option<&CFPlugIn>,
            function_name: Option<&CFString>,
        ) -> Boolean;
    }
    let ret =
        unsafe { CFPlugInRegisterFactoryFunctionByName(factory_uuid, plug_in, function_name) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::unregister_factory`"]
#[inline]
pub extern "C-unwind" fn CFPlugInUnregisterFactory(factory_uuid: Option<&CFUUID>) -> bool {
    extern "C-unwind" {
        fn CFPlugInUnregisterFactory(factory_uuid: Option<&CFUUID>) -> Boolean;
    }
    let ret = unsafe { CFPlugInUnregisterFactory(factory_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::register_plug_in_type`"]
#[inline]
pub extern "C-unwind" fn CFPlugInRegisterPlugInType(
    factory_uuid: Option<&CFUUID>,
    type_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFPlugInRegisterPlugInType(
            factory_uuid: Option<&CFUUID>,
            type_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFPlugInRegisterPlugInType(factory_uuid, type_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::unregister_plug_in_type`"]
#[inline]
pub extern "C-unwind" fn CFPlugInUnregisterPlugInType(
    factory_uuid: Option<&CFUUID>,
    type_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFPlugInUnregisterPlugInType(
            factory_uuid: Option<&CFUUID>,
            type_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFPlugInUnregisterPlugInType(factory_uuid, type_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::add_instance_for_factory`"]
#[inline]
pub extern "C-unwind" fn CFPlugInAddInstanceForFactory(factory_id: Option<&CFUUID>) {
    extern "C-unwind" {
        fn CFPlugInAddInstanceForFactory(factory_id: Option<&CFUUID>);
    }
    unsafe { CFPlugInAddInstanceForFactory(factory_id) }
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFPlugIn::remove_instance_for_factory`"]
#[inline]
pub extern "C-unwind" fn CFPlugInRemoveInstanceForFactory(factory_id: Option<&CFUUID>) {
    extern "C-unwind" {
        fn CFPlugInRemoveInstanceForFactory(factory_id: Option<&CFUUID>);
    }
    unsafe { CFPlugInRemoveInstanceForFactory(factory_id) }
}

#[deprecated = "renamed to `CFPlugInInstance::interface_function_table`"]
#[inline]
pub unsafe extern "C-unwind" fn CFPlugInInstanceGetInterfaceFunctionTable(
    instance: &CFPlugInInstance,
    interface_name: Option<&CFString>,
    ftbl: *mut *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn CFPlugInInstanceGetInterfaceFunctionTable(
            instance: &CFPlugInInstance,
            interface_name: Option<&CFString>,
            ftbl: *mut *mut c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFPlugInInstanceGetInterfaceFunctionTable(instance, interface_name, ftbl) };
    ret != 0
}

#[deprecated = "renamed to `CFPlugInInstance::factory_name`"]
#[inline]
pub extern "C-unwind" fn CFPlugInInstanceGetFactoryName(
    instance: &CFPlugInInstance,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFPlugInInstanceGetFactoryName(instance: &CFPlugInInstance)
            -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFPlugInInstanceGetFactoryName(instance) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFPlugInInstance::instance_data`"]
#[inline]
pub extern "C-unwind" fn CFPlugInInstanceGetInstanceData(
    instance: &CFPlugInInstance,
) -> *mut c_void {
    extern "C-unwind" {
        fn CFPlugInInstanceGetInstanceData(instance: &CFPlugInInstance) -> *mut c_void;
    }
    unsafe { CFPlugInInstanceGetInstanceData(instance) }
}

#[deprecated = "renamed to `CFPlugInInstance::with_instance_data_size`"]
#[inline]
pub unsafe extern "C-unwind" fn CFPlugInInstanceCreateWithInstanceDataSize(
    allocator: Option<&CFAllocator>,
    instance_data_size: CFIndex,
    deallocate_instance_function: CFPlugInInstanceDeallocateInstanceDataFunction,
    factory_name: Option<&CFString>,
    get_interface_function: CFPlugInInstanceGetInterfaceFunction,
) -> Option<CFRetained<CFPlugInInstance>> {
    extern "C-unwind" {
        fn CFPlugInInstanceCreateWithInstanceDataSize(
            allocator: Option<&CFAllocator>,
            instance_data_size: CFIndex,
            deallocate_instance_function: CFPlugInInstanceDeallocateInstanceDataFunction,
            factory_name: Option<&CFString>,
            get_interface_function: CFPlugInInstanceGetInterfaceFunction,
        ) -> Option<NonNull<CFPlugInInstance>>;
    }
    let ret = unsafe {
        CFPlugInInstanceCreateWithInstanceDataSize(
            allocator,
            instance_data_size,
            deallocate_instance_function,
            factory_name,
            get_interface_function,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
