create table category(
  category_id int not null primary key,
  category_name varchar(50)
);

create table film(
  film_id int not null primary key,
  film_name varchar(100),
  length int,
  release_year int
);

create table film_category(
  film_id int references film(film_id) on update cascade on delete cascade,
  category_id int references category(category_id) on update cascade on delete cascade
);

select *
from film_category
full join category c /*<# 0..n<->0..1: #>*/on c.category_id = film_category.category_id;