/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u001d\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u00052\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u00052\u0006\u0010&\u001a\u00020'H\u0014\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010,\u001a\u00020-H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "frame", "Lorg/openjdk/jmc/common/IMCFrame;", "argumentTypes", "", "", "<init>", "(Lorg/openjdk/jmc/common/IMCFrame;[Ljava/lang/String;)V", "getArgumentTypes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fullPackageName", "getFullPackageName", "()Ljava/lang/String;", "className", "getClassName", "methodName", "getMethodName", "inlined", "", "getInlined", "()Z", "formalDescriptor", "getFormalDescriptor", "lineNumber", "", "getLineNumber", "()I", "moduleName", "getModuleName", "fullName", "calcNavigatables", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "findNavigatableMethod", "cls", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)[Lcom/intellij/psi/NavigatablePsiElement;", "copyWithCustomName", "name", "findNavigatableInFileByLine", "file", "Lcom/intellij/psi/PsiFile;", "JFRMethodCallWithCustomName", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRMethodCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRMethodCall.kt\ncom/intellij/profiler/ultimate/jfr/JFRMethodCall\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n12767#2,2:207\n12970#2,2:213\n37#3,2:209\n67#4:211\n1#5:212\n*S KotlinDebug\n*F\n+ 1 JFRMethodCall.kt\ncom/intellij/profiler/ultimate/jfr/JFRMethodCall\n*L\n62#1:207,2\n70#1:213,2\n82#1:209,2\n99#1:211\n*E\n"})
public class JFRMethodCall
extends BaseJavaMethodCall {
    @NotNull
    private final IMCFrame frame;
    @Nullable
    private final String[] argumentTypes;

    public JFRMethodCall(@NotNull IMCFrame frame, @Nullable String[] argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
        this.argumentTypes = argumentTypes;
    }

    @Override
    @Nullable
    public String[] getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    @NotNull
    public String getFullPackageName() {
        String string = this.frame.getMethod().getType().getPackage().getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.frame.getMethod().getType().getTypeName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.frame.getMethod().getMethodName();
        if (string == null) {
            string = "[unknown]";
        }
        return string;
    }

    @Override
    public boolean getInlined() {
        return this.frame.getType() == IMCFrame.Type.INLINED;
    }

    @Override
    @Nullable
    public String getFormalDescriptor() {
        return this.frame.getMethod().getFormalDescriptor();
    }

    public int getLineNumber() {
        Integer n = this.frame.getFrameLineNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getFrameLineNumber(...)");
        return ((Number)n).intValue();
    }

    @Nullable
    public final String getModuleName() {
        IMCModule iMCModule = this.frame.getMethod().getType().getPackage().getModule();
        return iMCModule != null ? iMCModule.getName() : null;
    }

    @Override
    @NotNull
    public String fullName() {
        String[] stringArray;
        StringBuilder stringBuilder;
        StringBuilder $this$fullName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)this.getFullPackageName()).length() > 0) {
            stringArray = new String[]{this.getFullPackageName(), "."};
            StringsKt.append((StringBuilder)$this$fullName_u24lambda_u240, (String[])stringArray);
        }
        if (((CharSequence)this.getClassName()).length() > 0) {
            stringArray = new String[]{this.getClassName(), "."};
            StringsKt.append((StringBuilder)$this$fullName_u24lambda_u240, (String[])stringArray);
        }
        $this$fullName_u24lambda_u240.append(this.getMethodName());
        if (this.getArgumentTypes() != null) {
            $this$fullName_u24lambda_u240.append(this.argumentTypesString());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        boolean classesOrFiles;
        NavigatablePsiElement[] navigatables;
        block2: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NavigatablePsiElement[] $this$all$iv = navigatables = super.calcNavigatables(project);
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                NavigatablePsiElement element$iv;
                NavigatablePsiElement it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it instanceof PsiClass || it instanceof PsiFile) continue;
                bl = false;
                break block2;
            }
            bl = classesOrFiles = true;
        }
        if (!classesOrFiles) {
            return navigatables;
        }
        return (NavigatablePsiElement[])ActionsKt.runReadAction(() -> JFRMethodCall.calcNavigatables$lambda$1(this, project, navigatables));
    }

    @Override
    @NotNull
    protected NavigatablePsiElement[] findNavigatableMethod(@NotNull PsiClass cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        NavigatablePsiElement[] res = super.findNavigatableMethod(cls);
        if (!(res.length == 0)) {
            return res;
        }
        if (DebuggerUtilsEx.isLambdaName((String)this.getMethodName())) {
            PsiFile file = cls.getNavigationElement().getContainingFile();
            List list = DebuggerUtilsEx.collectLambdas((SourcePosition)SourcePosition.createFromLine((PsiFile)file, (int)this.getLineNumber()), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectLambdas(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return (NavigatablePsiElement[])thisCollection$iv.toArray(new PsiLambdaExpression[0]);
        }
        return new NavigatablePsiElement[0];
    }

    @Override
    @NotNull
    public JFRMethodCall copyWithCustomName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JFRMethodCallWithCustomName(name, this.frame, this.getArgumentTypes());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final NavigatablePsiElement findNavigatableInFileByLine(PsiFile file) {
        void $this$parentOfType$iv;
        Document document = file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        Document document2 = document;
        int lineNumber = this.getLineNumber() - 1;
        if (!DocumentUtil.isValidLine((int)lineNumber, (Document)document2)) {
            return null;
        }
        int offset = document2.getLineStartOffset(lineNumber);
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
            PsiElement psiElement2 = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
            if (psiElement2 == null) {
                psiElement2 = element;
            }
            element = psiElement2;
        }
        PsiElement psiElement3 = element;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, NavigatablePsiElement.class, (boolean)false);
    }

    private static final NavigatablePsiElement[] calcNavigatables$lambda$1(JFRMethodCall this$0, Project $project, NavigatablePsiElement[] $navigatables) {
        NavigatablePsiElement[] navigatablePsiElementArray;
        boolean targetIsInside;
        NavigatablePsiElement targetAtLine;
        NavigatablePsiElement[] fallbackResult;
        block6: {
            boolean bl;
            NavigatablePsiElement[] navigatablePsiElementArray2;
            PsiFile psiFile = this$0.findContainingFile($project);
            if (psiFile == null) {
                return $navigatables;
            }
            PsiFile file = psiFile;
            NavigatablePsiElement[] it = navigatablePsiElementArray2 = $navigatables;
            boolean bl2 = false;
            Object object = !(it.length == 0) ? navigatablePsiElementArray2 : null;
            if (object == null) {
                navigatablePsiElementArray2 = new PsiFile[]{file};
                object = navigatablePsiElementArray2;
            }
            fallbackResult = object;
            NavigatablePsiElement navigatablePsiElement = this$0.findNavigatableInFileByLine(file);
            if (navigatablePsiElement == null) {
                return fallbackResult;
            }
            targetAtLine = navigatablePsiElement;
            NavigatablePsiElement[] $this$any$iv = $navigatables;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                NavigatablePsiElement element$iv;
                NavigatablePsiElement it2 = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                if (!SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)((PsiElement)targetAtLine), (boolean)false), (Object)it2)) continue;
                bl = true;
                break block6;
            }
            bl = targetIsInside = false;
        }
        if (targetIsInside) {
            NavigatablePsiElement[] navigatablePsiElementArray3 = new NavigatablePsiElement[]{targetAtLine};
            navigatablePsiElementArray = navigatablePsiElementArray3;
        } else {
            navigatablePsiElementArray = fallbackResult;
        }
        return navigatablePsiElementArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall$JFRMethodCallWithCustomName;", "Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "className", "", "frame", "Lorg/openjdk/jmc/common/IMCFrame;", "argumentTypes", "", "<init>", "(Ljava/lang/String;Lorg/openjdk/jmc/common/IMCFrame;[Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
    private static final class JFRMethodCallWithCustomName
    extends JFRMethodCall {
        @NotNull
        private final String className;

        public JFRMethodCallWithCustomName(@NotNull String className, @NotNull IMCFrame frame, @Nullable String[] argumentTypes) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            super(frame, argumentTypes);
            this.className = className;
        }

        public /* synthetic */ JFRMethodCallWithCustomName(String string, IMCFrame iMCFrame, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                stringArray = null;
            }
            this(string, iMCFrame, stringArray);
        }

        @Override
        @NotNull
        public String getClassName() {
            return this.className;
        }
    }
}

