/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileContent;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlFileType;
import com.intellij.util.FileContentUtilCore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseElementSourceVirtualFileImpl
extends DatabaseElementVirtualFileImpl {
    private final DatabaseElementVirtualFileContent myContent;

    protected DatabaseElementSourceVirtualFileImpl(@NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind family, @NotNull DatabaseElementVirtualFileContent content) {
        if (dataSourceId == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (content == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(1);
        }
        super(dataSourceId, path, family);
        this.myContent = content;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameWithoutExtension() + ".sql";
        if (string == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return sqlFileType;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.myContent.getText().getBytes(this.getCharset()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() {
                DatabaseElementSourceVirtualFileImpl.this.myContent.setTextImpl(new String(this.buf, 0, this.count, DatabaseElementSourceVirtualFileImpl.this.getCharset()));
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{DatabaseElementSourceVirtualFileImpl.this});
            }
        };
    }

    public void setContent(@NotNull String content, int objectHash) {
        if (content == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(4);
        }
        this.myContent.setText(content, objectHash);
    }

    @NotNull
    public String getContent() {
        String string = this.myContent.getText();
        if (string == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isBusy() {
        return this.myContent.isBusy();
    }

    public void setBusy(boolean busy) {
        this.myContent.setBusy(busy);
    }

    @Override
    public byte @NotNull [] contentsToByteArray() {
        byte[] byArray = this.myContent.getText().getBytes(this.getCharset());
        if (byArray == null) {
            DatabaseElementSourceVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    @Override
    public long getModificationStamp() {
        return this.myContent.getModificationStamp();
    }

    @Override
    public long getLength() {
        return this.myContent.getText().length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isModifiedByUser() {
        return this.myContent.isModifiedByUser();
    }

    public int getObjectHash() {
        return this.myContent.getObjectHash();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseElementSourceVirtualFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseElementSourceVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

