/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.index.IndexerField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field {
    public static final String NOT_PRESENT = "N/P";
    private final Field parent;
    private final String namespace;
    private final String fieldName;
    private final String description;
    private final List<IndexerField> indexerFields;

    public Field(Field parent, String namespace, String name, String description) {
        this.parent = parent;
        this.namespace = namespace;
        this.fieldName = name;
        this.description = description;
        this.indexerFields = new ArrayList<IndexerField>();
    }

    public Field getParent() {
        return this.parent;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<IndexerField> getIndexerFields() {
        return Collections.unmodifiableList(this.indexerFields);
    }

    public boolean addIndexerField(IndexerField field) {
        return this.indexerFields.add(field);
    }

    public boolean removeIndexerField(IndexerField field) {
        return this.indexerFields.remove(field);
    }

    public String getFQN() {
        return this.getNamespace() + this.getFieldName();
    }

    public String toString() {
        return this.getFQN() + " (with " + this.getIndexerFields().size() + " registered index fields)";
    }
}

