/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
public final class KarmaServerRegistry
implements Disposable {
    private final Project myProject;
    private final ConcurrentMap<String, KarmaServer> myServerByConfigFile;
    private final ConcurrentMap<KarmaServerSettings, Promise<KarmaServer>> myServers;

    public KarmaServerRegistry(@NotNull Project project) {
        if (project == null) {
            KarmaServerRegistry.$$$reportNull$$$0(0);
        }
        this.myServerByConfigFile = new ConcurrentHashMap<String, KarmaServer>();
        this.myServers = new ConcurrentHashMap<KarmaServerSettings, Promise<KarmaServer>>();
        this.myProject = project;
    }

    @NotNull
    public static KarmaServerRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            KarmaServerRegistry.$$$reportNull$$$0(1);
        }
        KarmaServerRegistry karmaServerRegistry = (KarmaServerRegistry)project.getService(KarmaServerRegistry.class);
        if (karmaServerRegistry == null) {
            KarmaServerRegistry.$$$reportNull$$$0(2);
        }
        return karmaServerRegistry;
    }

    @Nullable
    public KarmaServer getServer(@NotNull KarmaServerSettings serverSettings) {
        Promise promise;
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(3);
        }
        if ((promise = (Promise)this.myServers.get(serverSettings)) != null && promise.isSucceeded()) {
            try {
                return (KarmaServer)promise.blockingGet(0);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
        return null;
    }

    @NotNull
    public Promise<KarmaServer> startServer(final @NotNull KarmaServerSettings serverSettings) {
        AsyncPromise promise;
        Promise<KarmaServer> prevPromise;
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(4);
        }
        if ((prevPromise = this.myServers.putIfAbsent(serverSettings, (Promise<KarmaServer>)(promise = new AsyncPromise()))) != null) {
            Promise<KarmaServer> promise2 = prevPromise;
            if (promise2 == null) {
                KarmaServerRegistry.$$$reportNull$$$0(5);
            }
            return promise2;
        }
        KarmaServer prevServer = (KarmaServer)this.myServerByConfigFile.get(serverSettings.getConfigurationFilePath());
        if (prevServer != null) {
            prevServer.onTerminated(new KarmaServerTerminatedListener(){

                @Override
                public void onTerminated(int exitCode) {
                    KarmaServerRegistry.this.doStartServer(serverSettings, (AsyncPromise<KarmaServer>)promise);
                }
            });
            prevServer.shutdownAsync();
        } else {
            this.doStartServer(serverSettings, (AsyncPromise<KarmaServer>)promise);
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            KarmaServerRegistry.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    private void doStartServer(final @NotNull KarmaServerSettings serverSettings, final @NotNull AsyncPromise<KarmaServer> promise) {
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(7);
        }
        if (promise == null) {
            KarmaServerRegistry.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                final KarmaServer server = new KarmaServer(this.myProject, serverSettings);
                this.myServerByConfigFile.put(serverSettings.getConfigurationFilePath(), server);
                server.onTerminated(new KarmaServerTerminatedListener(){

                    @Override
                    public void onTerminated(int exitCode) {
                        KarmaServerRegistry.this.myServers.remove(serverSettings, promise);
                        KarmaServerRegistry.this.myServerByConfigFile.remove(serverSettings.getConfigurationFilePath(), server);
                    }
                });
                promise.setResult((Object)server);
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerRegistry";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doStartServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

