/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.AnnotationUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.BarAnnotation;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathPoint;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PolygonData;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b28\u0010\n\u001a4\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010J0\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J.\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010H\u0002Jh\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b28\u0010\n\u001a4\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0010H\u0002JV\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u0012\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u001e\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012\u0018\u00010#2\u0006\u0010-\u001a\u00020\tH\u0002J\u0019\u0010.\u001a\u00020**\u00020\u00122\u0006\u0010/\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b0\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation;", "", "()V", "build", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "polygons", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PolygonData;", "transform", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lkotlin/ParameterName;", "name", "p", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "ctx", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "helper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "createLabelRect", "hPlacement", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation$PlacementInsideBar;", "vPlacement", "barRect", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "padding", "", "linearAnnotations", "nonLinearAnnotations", "placeLabel", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "index", "", "barsCount", "viewPort", "isHorizontallyOriented", "", "isUpsideDown", "recoverRectangleFromPolygonData", "polygonData", "contains", "other", "contains$plot_base", "PlacementInsideBar", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBarAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,321:1\n1855#2:322\n1856#2:324\n1855#2,2:325\n1477#2:327\n1502#2,3:328\n1505#2,3:338\n1045#2:342\n1864#2,2:343\n1549#2:345\n1620#2,3:346\n1855#2,2:349\n1866#2:351\n1549#2:353\n1620#2,3:354\n1#3:323\n372#4,7:331\n215#5:341\n216#5:352\n*S KotlinDebug\n*F\n+ 1 BarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation\n*L\n52#1:322\n52#1:324\n105#1:325,2\n117#1:327\n117#1:328,3\n117#1:338,3\n123#1:342\n126#1:343,2\n157#1:345\n157#1:346,3\n174#1:349,2\n126#1:351\n306#1:353\n306#1:354,3\n117#1:331,7\n120#1:341\n120#1:352\n*E\n"})
public final class BarAnnotation {
    @NotNull
    public static final BarAnnotation INSTANCE = new BarAnnotation();

    private BarAnnotation() {
    }

    public final void build(@NotNull SvgRoot root, @NotNull List<PolygonData> polygons, @NotNull Function2<? super DataPointAesthetics, ? super GeomContext, DoubleRectangle> transform2, @NotNull GeomHelper helper2, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(polygons, (String)"polygons");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        if (coord.isLinear()) {
            this.linearAnnotations(root, polygons, coord, ctx2);
        } else {
            this.nonLinearAnnotations(root, polygons, transform2, helper2, ctx2);
        }
    }

    private final void nonLinearAnnotations(SvgRoot root, List<PolygonData> polygons, Function2<? super DataPointAesthetics, ? super GeomContext, DoubleRectangle> transform2, GeomHelper helper2, GeomContext ctx2) {
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        Iterable $this$forEach$iv = polygons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DoubleVector zero;
            DoubleVector centroid;
            DoubleRectangle rect2;
            PolygonData polygon2 = (PolygonData)element$iv;
            boolean bl = false;
            DataPointAesthetics p = polygon2.getRings().get(0).get(0).getAes();
            if ((DoubleRectangle)transform2.invoke((Object)p, (Object)ctx2) == null || helper2.toClient(rect2.getCenter(), p) == null || helper2.toClient(0.0, 0.0, p) == null) continue;
            DoubleVector v = centroid.subtract(zero).orthogonal();
            double it = Math.atan2(v.getY(), v.getX());
            boolean bl2 = false;
            double d = Math.abs(it);
            double angle = (1.5707963267948966 <= d ? d <= 4.71238898038469 : false) ? Math.PI - it : Math.PI * 2 - it;
            String text2 = annotation2.getAnnotationText(p.index(), ctx2.getPlotContext());
            Color textColor2 = (Color)AnnotationUtil.INSTANCE.textColorAndLabelAlpha(annotation2, p.color(), p.fill(), true).component1();
            Object object = annotation2.getTextStyle();
            d = MathKt.toDegrees(angle);
            object = AnnotationUtil.INSTANCE.createLabelElement(text2, centroid, new AnnotationUtil.TextParams((TextStyle)object, textColor2, "middle", "center", d, null, 0.0, 32, null), ctx2);
            SvgNode p0 = (SvgNode)object;
            boolean bl3 = false;
            root.add(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void linearAnnotations(SvgRoot root, List<PolygonData> polygons, CoordinateSystem coord, GeomContext ctx2) {
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        DataPointAesthetics p;
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        DoubleRectangle p0 = GeomBase.Companion.overallAesBounds(ctx2);
        boolean bl = false;
        DoubleRectangle doubleRectangle = coord.toClient(p0);
        if (doubleRectangle == null) {
            return;
        }
        DoubleRectangle viewPort = doubleRectangle;
        double padding = annotation2.getTextStyle().getSize() / (double)2;
        boolean isHorizontallyOriented = ctx2.getFlipped();
        List rectangles = new ArrayList();
        Iterable $this$forEach$iv = polygons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DoubleRectangle clientRect;
            Pair<DataPointAesthetics, DoubleRectangle> pair2;
            PolygonData polygonData = (PolygonData)element$iv;
            boolean bl2 = false;
            if (INSTANCE.recoverRectangleFromPolygonData(polygonData) == null) continue;
            p = (DataPointAesthetics)pair2.component1();
            DoubleRectangle rect2 = (DoubleRectangle)pair2.component2();
            if (rect2.intersect(viewPort) == null) continue;
            DataPointAesthetics $this$linearAnnotations_u24lambda_u244_u24lambda_u243 = p;
            boolean bl3 = false;
            Double d = $this$linearAnnotations_u24lambda_u244_u24lambda_u243.y();
            Intrinsics.checkNotNull((Object)d);
            boolean isUpsideDown = d < 0.0;
            rectangles.add(new Triple((Object)p, (Object)clientRect, (Object)isUpsideDown));
        }
        $this$forEach$iv = rectangles;
        boolean $i$f$groupBy = false;
        Iterator<Object> iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            p = (Triple)element$iv$iv;
            boolean bl4 = false;
            DoubleRectangle rect3 = (DoubleRectangle)p.component2();
            Double key$iv$iv = isHorizontallyOriented ? rect3.getCenter().getY() : rect3.getCenter().getX();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEachIndexed$iv;
            Iterable $this$sortedBy$iv;
            Object element$iv;
            Object object = element$iv = (Map.Entry)iterator2.next();
            boolean bl6 = false;
            List bars = (List)object.getValue();
            int barsCount = bars.size();
            Iterable bl4 = bars;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(isHorizontallyOriented){
                final /* synthetic */ boolean $isHorizontallyOriented$inlined;
                {
                    this.$isHorizontallyOriented$inlined = bl;
                }

                public final int compare(T a2, T b2) {
                    Triple triple = (Triple)a2;
                    boolean bl = false;
                    DoubleRectangle rect2 = (DoubleRectangle)triple.component2();
                    triple = (Triple)b2;
                    Comparable comparable = Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY());
                    bl = false;
                    rect2 = (DoubleRectangle)triple.component2();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY()));
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapTo$iv$iv;
                double d;
                Pair<Text.HorizontalAnchor, DoubleRectangle> pair3;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple triple = (Triple)item$iv;
                int index = n;
                boolean bl7 = false;
                DataPointAesthetics p2 = (DataPointAesthetics)triple.component1();
                DoubleRectangle barRect = (DoubleRectangle)triple.component2();
                boolean isUpsideDown = (Boolean)triple.component3();
                String text2 = annotation2.getAnnotationText(p2.index(), ctx2.getPlotContext());
                DoubleVector textSize = (DoubleVector)AnnotationUtil.INSTANCE.textSizeGetter(annotation2.getTextStyle(), ctx2).invoke((Object)text2, (Object)p2);
                if (INSTANCE.placeLabel(barRect, index, barsCount, textSize, padding, viewPort, isHorizontallyOriented, isUpsideDown) == null) continue;
                Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair3.component1());
                DoubleRectangle textRect = (DoubleRectangle)pair3.component2();
                Pair<Color, Double> pair4 = AnnotationUtil.INSTANCE.textColorAndLabelAlpha(annotation2, p2.color(), p2.fill(), INSTANCE.contains$plot_base(barRect, textRect));
                Color textColor2 = (Color)pair4.component1();
                double alpha = ((Number)pair4.component2()).doubleValue();
                DoubleVector location2 = null;
                switch (WhenMappings.$EnumSwitchMapping$0[hAlignment.ordinal()]) {
                    case 1: {
                        d = textRect.getLeft();
                        break;
                    }
                    case 2: {
                        d = textRect.getRight();
                        break;
                    }
                    case 3: {
                        d = textRect.getCenter().getX();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                location2 = new DoubleVector(d, textRect.getTop());
                Iterable $this$map$iv = Label.Companion.splitLines(text2);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void line2;
                    SvgGElement svgGElement;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl8 = false;
                    TextStyle textStyle = annotation2.getTextStyle();
                    String string2 = hAlignment.toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    SvgGElement it = svgGElement = AnnotationUtil.INSTANCE.createLabelElement((String)line2, location2, new AnnotationUtil.TextParams(textStyle, textColor2, string2, "top", null, ctx2.getBackgroundColor(), alpha, 16, null), ctx2);
                    boolean bl9 = false;
                    location2 = location2.add(new DoubleVector(0.0, annotation2.getTextStyle().getSize()));
                    collection.add(svgGElement);
                }
                List labels = (List)destination$iv$iv2;
                Iterable $this$forEach$iv2 = labels;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SvgNode p02 = (SvgNode)element$iv2;
                    boolean bl10 = false;
                    root.add(p02);
                }
            }
        }
    }

    public final boolean contains$plot_base(@NotNull DoubleRectangle $this$contains, @NotNull DoubleRectangle other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.xRange().contains(other.xRange()) && $this$contains.yRange().contains(other.yRange());
    }

    private final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel(DoubleRectangle barRect, int index, int barsCount, DoubleVector textSize, double padding, DoubleRectangle viewPort, boolean isHorizontallyOriented, boolean isUpsideDown) {
        DoubleRectangle doubleRectangle;
        double pos;
        PlacementInsideBar placementInsideBar;
        Function1 coordSelector2 = isHorizontallyOriented ? (Function1)placeLabel.coordSelector.1.INSTANCE : (Function1)placeLabel.coordSelector.2.INSTANCE;
        if (barsCount == 1) {
            PlacementInsideBar it = isHorizontallyOriented ? PlacementInsideBar.MIN : PlacementInsideBar.MAX;
            boolean bl = false;
            placementInsideBar = isUpsideDown ? it.flip() : it;
        } else {
            placementInsideBar = index == 0 ? PlacementInsideBar.MIN : (index == barsCount - 1 ? PlacementInsideBar.MAX : PlacementInsideBar.MIDDLE);
        }
        PlacementInsideBar insideBar = placementInsideBar;
        Pair<Text.HorizontalAnchor, DoubleRectangle> pair2 = BarAnnotation.placeLabel$place(isHorizontallyOriented, barRect, textSize, padding, insideBar);
        Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair2.component1());
        DoubleRectangle textRect = (DoubleRectangle)pair2.component2();
        if (this.contains$plot_base(barRect, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (index != 0 && index != barsCount - 1) {
            return null;
        }
        if (barsCount == 1) {
            PlacementInsideBar placementInsideBar2 = insideBar = isHorizontallyOriented ? PlacementInsideBar.MAX : PlacementInsideBar.MIN;
            if (isUpsideDown) {
                insideBar = insideBar.flip();
            }
        }
        if (insideBar == PlacementInsideBar.MAX) {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.LEFT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue() + padding / (double)2;
            doubleRectangle = BarAnnotation.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        } else {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.RIGHT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() - ((Number)coordSelector2.invoke((Object)textSize)).doubleValue() - padding / (double)2;
            doubleRectangle = textRect = BarAnnotation.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        }
        if (this.contains$plot_base(viewPort, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (((Number)coordSelector2.invoke((Object)textSize)).doubleValue() + padding > ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue()) {
            return null;
        }
        return BarAnnotation.placeLabel$place(isHorizontallyOriented, barRect, textSize, padding, insideBar);
    }

    private final DoubleRectangle createLabelRect(PlacementInsideBar hPlacement, PlacementInsideBar vPlacement, DoubleRectangle barRect, DoubleVector textSize, double padding) {
        double originX2 = BarAnnotation.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originX.1.INSTANCE), hPlacement);
        double originY2 = BarAnnotation.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originY.1.INSTANCE), vPlacement);
        return new DoubleRectangle(originX2, originY2, textSize.getX(), textSize.getY());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<DataPointAesthetics, DoubleRectangle> recoverRectangleFromPolygonData(PolygonData polygonData) {
        double d;
        DoubleVector it;
        double d2;
        void $this$mapTo$iv$iv;
        DataPointAesthetics dp = polygonData.getRings().get(0).get(0).getAes();
        List<PathPoint> ring = polygonData.getRings().get(0);
        boolean bl = false;
        Iterable $this$map$iv = ring;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PathPoint pathPoint = (PathPoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(p0.getCoord());
        }
        List coords = (List)destination$iv$iv;
        if (coords.isEmpty() || coords.size() != 5) {
            return null;
        }
        Iterator iterator2 = ((Iterable)coords).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DoubleVector it2 = (DoubleVector)iterator2.next();
        boolean bl3 = false;
        double d3 = it2.getX();
        while (iterator2.hasNext()) {
            DoubleVector it3 = (DoubleVector)iterator2.next();
            $i$a$-minOf-BarAnnotation$recoverRectangleFromPolygonData$rect$1$minX$1 = false;
            d2 = it3.getX();
            d3 = Math.min(d3, d2);
        }
        double minX = d3;
        Iterator iterator3 = ((Iterable)coords).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        DoubleVector it4 = (DoubleVector)iterator3.next();
        boolean bl4 = false;
        double d4 = it4.getY();
        while (iterator3.hasNext()) {
            it = (DoubleVector)iterator3.next();
            $i$a$-minOf-BarAnnotation$recoverRectangleFromPolygonData$rect$1$minY$1 = false;
            d = it.getY();
            d4 = Math.min(d4, d);
        }
        double minY = d4;
        Iterator iterator4 = ((Iterable)coords).iterator();
        if (!iterator4.hasNext()) {
            throw new NoSuchElementException();
        }
        DoubleVector it5 = (DoubleVector)iterator4.next();
        boolean bl5 = false;
        d2 = it5.getX();
        while (iterator4.hasNext()) {
            DoubleVector it6 = (DoubleVector)iterator4.next();
            $i$a$-maxOf-BarAnnotation$recoverRectangleFromPolygonData$rect$1$maxX$1 = false;
            double d5 = it6.getX();
            d2 = Math.max(d2, d5);
        }
        double maxX = d2;
        Iterator iterator5 = ((Iterable)coords).iterator();
        if (!iterator5.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (DoubleVector)iterator5.next();
        boolean bl6 = false;
        d = it.getY();
        while (iterator5.hasNext()) {
            DoubleVector it7 = (DoubleVector)iterator5.next();
            $i$a$-maxOf-BarAnnotation$recoverRectangleFromPolygonData$rect$1$maxY$1 = false;
            double d6 = it7.getY();
            d = Math.max(d, d6);
        }
        double maxY = d;
        DoubleRectangle rect2 = new DoubleRectangle(new DoubleVector(minX, minY), new DoubleVector(maxX - minX, maxY - minY));
        return TuplesKt.to((Object)dp, (Object)rect2);
    }

    private static final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel$place(boolean $isHorizontallyOriented, DoubleRectangle $barRect, DoubleVector $textSize, double $padding, PlacementInsideBar placement) {
        Text.HorizontalAnchor horizontalAnchor;
        DoubleRectangle textRect;
        block6: {
            block5: {
                textRect = INSTANCE.createLabelRect($isHorizontallyOriented ? placement : PlacementInsideBar.MIDDLE, $isHorizontallyOriented ? PlacementInsideBar.MIDDLE : placement, $barRect, $textSize, $padding);
                if (!$isHorizontallyOriented) break block5;
                switch (WhenMappings.$EnumSwitchMapping$1[placement.ordinal()]) {
                    case 1: {
                        horizontalAnchor = Text.HorizontalAnchor.LEFT;
                        break block6;
                    }
                    case 2: {
                        horizontalAnchor = Text.HorizontalAnchor.RIGHT;
                        break block6;
                    }
                    case 3: {
                        horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
        }
        Text.HorizontalAnchor hAlignment = horizontalAnchor;
        return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
    }

    private static final DoubleRectangle placeLabel$moveTo(DoubleRectangle $this$placeLabel_u24moveTo, boolean $isHorizontallyOriented, double value) {
        DoubleVector newOrigin = $isHorizontallyOriented ? new DoubleVector(value, $this$placeLabel_u24moveTo.getOrigin().getY()) : new DoubleVector($this$placeLabel_u24moveTo.getOrigin().getX(), value);
        return new DoubleRectangle(newOrigin, $this$placeLabel_u24moveTo.getDimension());
    }

    private static final double createLabelRect$getCoord(DoubleRectangle $barRect, double $padding, DoubleVector $textSize, Function1<? super DoubleVector, Double> coordSelector2, PlacementInsideBar align) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$1[align.ordinal()]) {
            case 1: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + $padding;
                break;
            }
            case 2: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)$barRect.getDimension())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() - $padding;
                break;
            }
            case 3: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getCenter())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation$PlacementInsideBar;", "", "(Ljava/lang/String;I)V", "flip", "MIN", "MAX", "MIDDLE", "plot-base"})
    private static final class PlacementInsideBar
    extends Enum<PlacementInsideBar> {
        public static final /* enum */ PlacementInsideBar MIN = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MAX = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MIDDLE = new PlacementInsideBar();
        private static final /* synthetic */ PlacementInsideBar[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final PlacementInsideBar flip() {
            PlacementInsideBar placementInsideBar;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    placementInsideBar = MAX;
                    break;
                }
                case 2: {
                    placementInsideBar = MIN;
                    break;
                }
                case 3: {
                    placementInsideBar = MIDDLE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return placementInsideBar;
        }

        public static PlacementInsideBar[] values() {
            return (PlacementInsideBar[])$VALUES.clone();
        }

        public static PlacementInsideBar valueOf(String value) {
            return Enum.valueOf(PlacementInsideBar.class, value);
        }

        @NotNull
        public static EnumEntries<PlacementInsideBar> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = placementInsideBarArray = new PlacementInsideBar[]{PlacementInsideBar.MIN, PlacementInsideBar.MAX, PlacementInsideBar.MIDDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlacementInsideBar.values().length];
                try {
                    nArray[PlacementInsideBar.MIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MAX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlacementInsideBar.values().length];
            try {
                nArray[PlacementInsideBar.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

