/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.color;

import com.intellij.psi.css.impl.util.color.ColorSpace;
import com.intellij.psi.css.impl.util.color.CssColorConversionUtilKt;
import com.intellij.util.MathUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/intellij/psi/css/impl/util/color/CssColor;", "", "colorSpaceId", "Lcom/intellij/psi/css/impl/util/color/ColorSpace;", "components", "", "", "<init>", "(Lcom/intellij/psi/css/impl/util/color/ColorSpace;[Ljava/lang/Double;)V", "getColorSpaceId", "()Lcom/intellij/psi/css/impl/util/color/ColorSpace;", "alpha", "getAlpha", "()Ljava/lang/Double;", "setAlpha", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "getComponents", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "get", "index", "", "(I)Ljava/lang/Double;", "set", "", "value", "(ILjava/lang/Double;)V", "componentsToDoubleArray", "", "toString", "", "Companion", "intellij.css.psi"})
public final class CssColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace colorSpaceId;
    @Nullable
    private Double alpha;
    @NotNull
    private final Double[] components;
    public static final double DOUBLE_COMPARE_EPSILON = 1.0E-4;

    public CssColor(@NotNull ColorSpace colorSpaceId, Double ... components) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorSpaceId), (String)"colorSpaceId");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.colorSpaceId = colorSpaceId;
        switch (components.length) {
            case 3: {
                this.alpha = 1.0;
                break;
            }
            case 4: {
                this.alpha = components[3];
                break;
            }
            default: {
                throw new IllegalArgumentException("CssColor created with invalid components: [" + ArraysKt.joinToString$default((Object[])components, null, null, null, (int)0, null, CssColor::_init_$lambda$0, (int)31, null) + "]");
            }
        }
        Double[] doubleArray = new Double[]{null, null, null};
        this.components = doubleArray;
        for (int i = 0; i < 3; ++i) {
            if (components[i] == null) continue;
            this.components[i] = components[i];
        }
    }

    @NotNull
    public final ColorSpace getColorSpaceId() {
        return this.colorSpaceId;
    }

    @Nullable
    public final Double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(@Nullable Double d) {
        this.alpha = d;
    }

    @NotNull
    public final Double[] getComponents() {
        return this.components;
    }

    @Nullable
    public final Double get(int index) {
        if (!(0 <= index ? index < 3 : false)) {
            throw new IllegalArgumentException("Access components from 0..2. Use CssColor.alpha for the value of the alpha channel.");
        }
        return this.components[index];
    }

    public final void set(int index, @Nullable Double value) {
        if (!(0 <= index ? index < 3 : false)) {
            throw new IllegalArgumentException("Access components from 0..2. Use CssColor.alpha for the value of the alpha channel.");
        }
        this.components[index] = value;
    }

    @NotNull
    public final double[] componentsToDoubleArray() {
        double[] dArray = new double[3];
        Double d = this.get(0);
        dArray[0] = d != null ? d : 0.0;
        Double d2 = this.get(1);
        dArray[1] = d2 != null ? d2 : 0.0;
        Double d3 = this.get(2);
        dArray[2] = d3 != null ? d3 : 0.0;
        return dArray;
    }

    @NotNull
    public String toString() {
        return this.colorSpaceId + ": [" + this.components[0] + ", " + this.components[1] + ", " + this.components[2] + "] / " + this.alpha;
    }

    private static final CharSequence _init_$lambda$0(Double it) {
        return String.valueOf(it);
    }

    @JvmStatic
    @Nullable
    public static final CssColor fromJavaAwtColor(@Nullable Color color) {
        return Companion.fromJavaAwtColor(color);
    }

    @JvmStatic
    @Nullable
    public static final Color toJavaAwtColor(@Nullable CssColor cssColor) {
        return Companion.toJavaAwtColor(cssColor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0017\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/psi/css/impl/util/color/CssColor$Companion;", "", "<init>", "()V", "DOUBLE_COMPARE_EPSILON", "", "fromJavaAwtColor", "Lcom/intellij/psi/css/impl/util/color/CssColor;", "color", "Ljava/awt/Color;", "toJavaAwtColor", "cssColor", "componentTo255", "", "component", "(Ljava/lang/Double;)I", "intellij.css.psi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CssColor fromJavaAwtColor(@Nullable Color color) {
            if (color == null) {
                return null;
            }
            Double[] doubleArray = new Double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, (double)color.getAlpha() / 255.0};
            return new CssColor(ColorSpace.SRGB, doubleArray);
        }

        @JvmStatic
        @Nullable
        public final Color toJavaAwtColor(@Nullable CssColor cssColor) {
            if (cssColor == null) {
                return null;
            }
            CssColor converted = CssColorConversionUtilKt.convertColor(cssColor, ColorSpace.SRGB);
            return new Color(this.componentTo255(converted.get(0)), this.componentTo255(converted.get(1)), this.componentTo255(converted.get(2)), this.componentTo255(converted.getAlpha()));
        }

        private final int componentTo255(Double component) {
            if (component == null) {
                return 0;
            }
            int whole = (int)component.doubleValue();
            double partial = component - (double)whole;
            if (MathUtil.compare((double)(partial - 0.5), (double)0.0, (double)1.0E-4) == 0) {
                return MathUtil.clamp((int)((int)Math.ceil(component * 255.0)), (int)0, (int)255);
            }
            return MathUtil.clamp((int)((int)Math.round(component * 255.0)), (int)0, (int)255);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

