/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeKeyTypeImpl
extends JSLiteralKeyTypeBaseImpl {
    @NotNull
    private final Collection<PsiElement> myKeySourceElements;
    private final boolean myOptional;

    @NotNull
    public static JSTypeKeyTypeImpl createKeyType(@NotNull String literal, @NotNull List<JSRecordType> ownerTypes, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(0);
        }
        if (ownerTypes == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(2);
        }
        HashSet<PsiElement> sources = new HashSet<PsiElement>();
        boolean optional = !ownerTypes.isEmpty();
        for (JSRecordType type : ownerTypes) {
            JSRecordType.PropertySignature signature = type.findPropertySignature(literal);
            if (signature == null) continue;
            JSRecordType.MemberSource memberSource = signature.getMemberSource();
            sources.addAll(memberSource.getAllSourceElements());
            optional &= signature.isOptional();
        }
        return JSTypeKeyTypeImpl.createKeyType(literal, sources, optional, source);
    }

    @NotNull
    public static JSTypeKeyTypeImpl createKeyType(@NotNull String literal, @NotNull Collection<PsiElement> sources, boolean optional, @NotNull JSTypeSource source) {
        JSType type;
        PsiElement item;
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(3);
        }
        if (sources == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(5);
        }
        if (sources.size() == 1 && (item = (PsiElement)ContainerUtil.getFirstItem(sources)) instanceof TypeScriptPropertySignature && (type = ((TypeScriptPropertySignature)item).getKeyType()) instanceof JSTypeKeyTypeImpl && ((JSTypeKeyTypeImpl)type).isOptional() == optional && literal.equals(((JSTypeKeyTypeImpl)type).getLiteral())) {
            JSTypeKeyTypeImpl jSTypeKeyTypeImpl = (JSTypeKeyTypeImpl)type;
            if (jSTypeKeyTypeImpl == null) {
                JSTypeKeyTypeImpl.$$$reportNull$$$0(6);
            }
            return jSTypeKeyTypeImpl;
        }
        return new JSTypeKeyTypeImpl(literal, sources, optional, source);
    }

    public JSTypeKeyTypeImpl(@NotNull String literal, @Nullable JSRecordType.PropertySignature signature, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(7);
        }
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(8);
        }
        this(literal, signature == null ? ContainerUtil.emptyList() : signature.getMemberSource().getAllSourceElements(), signature != null && signature.isOptional(), source);
    }

    private JSTypeKeyTypeImpl(@NotNull String literal, @NotNull Collection<PsiElement> elements, boolean optional, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(10);
        }
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(11);
        }
        super(literal, source);
        this.myKeySourceElements = elements;
        this.myOptional = optional;
    }

    public JSTypeKeyTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(12);
        }
        if (inputStream == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(13);
        }
        super(source, inputStream);
        this.myKeySourceElements = ContainerUtil.emptyList();
        this.myOptional = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(14);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myOptional, outputStream);
    }

    @Override
    @NotNull
    protected JSLiteralKeyTypeBaseImpl createInstance(@NotNull String literal, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(15);
        }
        if (source == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(16);
        }
        return new JSTypeKeyTypeImpl(literal, this.myKeySourceElements, this.myOptional, source);
    }

    @Override
    @NotNull
    public String getTypeParserPrefix() {
        return "#literalkey";
    }

    @Override
    public ResolveResult[] resolveKey() {
        if (this.myKeySourceElements.size() == 1) {
            return new ResolveResult[]{new JSResolveResult((PsiElement)ContainerUtil.getFirstItem(this.myKeySourceElements))};
        }
        if (this.myKeySourceElements.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return (ResolveResult[])this.myKeySourceElements.stream().map(e -> new JSResolveResult((PsiElement)new TypeScriptMergedTypeImplicitElementImpl(this.getLiteral(), null, (PsiElement)e, false, false, true, JSRecordType.MemberSourceKind.TypeKey))).toArray(ResolveResult[]::new);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(super.hashCodeImpl(), JSTypeHashCodeUtil.getHashCode(this.myKeySourceElements), this.myOptional);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(17);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myKeySourceElements.equals(((JSTypeKeyTypeImpl)type).myKeySourceElements) && this.myOptional == ((JSTypeKeyTypeImpl)type).myOptional;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @NotNull
    public Collection<PsiElement> getKeySourceElements() {
        Collection<PsiElement> collection = this.myKeySourceElements;
        if (collection == null) {
            JSTypeKeyTypeImpl.$$$reportNull$$$0(18);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerTypes";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeKeyTypeImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeKeyTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeySourceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKeyType";
                break;
            }
            case 6: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 18 -> new IllegalStateException(string);
        };
    }
}

